/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannFont;
import com.tann.dice.util.ui.TextWriter;

public class TextMarquee
extends Actor {
    final String text;
    final Color col;
    final Color bg = Colours.dark;
    final int width;
    final int gap = 4;
    static final TannFont font = TannFont.font;
    float speed = 22.0f;
    float time = 0.0f;

    private TextMarquee(String text, Color col, int width) {
        this.text = "    -   " + text;
        this.col = col;
        this.width = width;
        this.setSize(width, font.getLineHeight() - 1);
    }

    public static Actor marqueeOrDots(String text, Color col, int maxWidth) {
        TextWriter tw = new TextWriter(TextWriter.getTag(col) + text);
        if (tw.getWidth() <= (float)maxWidth) {
            return tw;
        }
        if (!OptionLib.DISABLE_MARQUEE.c()) {
            return new TextMarquee(text, col, maxWidth);
        }
        for (int i = text.length() - 2; i > 4; --i) {
            String sub = text.substring(0, i) + "...";
            TextWriter dotted = new TextWriter(TextWriter.getTag(col) + sub);
            if (!(dotted.getWidth() <= (float)maxWidth)) continue;
            return dotted;
        }
        return new TextWriter("[red]err");
    }

    @Override
    public void act(float delta) {
        this.time += delta * this.speed;
        super.act(delta);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        TannFont font = TannFont.font;
        int totalWidth = font.getWidth(this.text);
        int offset = 4 - (int)(this.time % (float)totalWidth + (float)totalWidth) % totalWidth - 2;
        batch.setColor(this.col);
        for (boolean secondRun : Tann.BOTH) {
            String part;
            int pw;
            int drawX = offset + (secondRun ? totalWidth : 0);
            for (int i = 0; i < this.text.length() && !((float)(drawX + (pw = font.getWidth(part = this.text.charAt(i) + ""))) > this.getWidth()); ++i) {
                if (drawX > 0) {
                    font.drawString(batch, part, this.getX() + (float)drawX, this.getY());
                }
                drawX += pw + 1;
            }
        }
        batch.setColor(this.bg);
        Draw.fillRectangle(batch, this.getX(), this.getY(), 4.0f, this.getHeight());
        Draw.fillRectangle(batch, this.getX() + this.getWidth() - 4.0f, this.getY(), 4.0f, this.getHeight());
        super.draw(batch, parentAlpha);
    }
}

