/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.mode.creative.pastey.PasteMode;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.TextWriter;
import com.tann.dice.util.ui.choice.ChoiceDialog;
import com.tann.dice.util.ui.standardButton.StandardButton;
import java.util.ArrayList;
import java.util.List;

public class ClipboardUtils {
    public static final Color CLIPBOARD_COL = Colours.blue;
    public static final Color URN_COL = Colours.orange;

    public static void copyWithSoundAndToast(String copy) {
        Sounds.playSound(Sounds.slice);
        Gdx.app.getClipboard().setContents(copy);
        ClipboardUtils.showClipboardToast(copy);
    }

    public static String pasteSafer() {
        String s = Gdx.app.getClipboard().getContents();
        if (s == null) {
            return null;
        }
        return PasteMode.genericPasteTagHandleCleanup(s);
    }

    public static void offerToCopy(String copy, String message) {
        ClipboardUtils.offerToCopy(copy, message, new ArrayList<Actor>());
    }

    public static void offerToCopy(final String copy, String message, List<Actor> extra) {
        ChoiceDialog choiceDialog = new ChoiceDialog(message, extra, ChoiceDialog.ChoiceNames.YesCancel, new Runnable(){

            @Override
            public void run() {
                Main.getCurrentScreen().popSingleMedium();
                ClipboardUtils.copyWithSoundAndToast(copy);
                Main.getCurrentScreen().showDialog("Copied to clipboard");
            }
        }, new Runnable(){

            @Override
            public void run() {
                Main.getCurrentScreen().popSingleMedium();
            }
        });
        Main.getCurrentScreen().push(choiceDialog, true, true, false, 0.8f);
        Tann.center(choiceDialog);
    }

    public static void showClipboardToast(String copied) {
        boolean finalNeedsScroll;
        Group showText = new TextWriter(TextWriter.rebracketTags(copied));
        boolean bl = finalNeedsScroll = showText.getWidth() > (float)Main.width * 0.8f;
        if (finalNeedsScroll) {
            showText = Tann.makeScrollpane(new Pixl().actor(showText).row(2).pix());
        }
        Group a = new TextWriter(TextWriter.getTag(CLIPBOARD_COL) + "[b]clipboard: " + Tann.makeEllipses(copied, 10));
        a = new Pixl(3, 5).border(CLIPBOARD_COL).actor(a).pix();
        final Group finalShowText = showText;
        a.addListener(new TannListener(){

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                Group a = new Pixl(3, 3).border(CLIPBOARD_COL).text("[grey]This text was copied to clipboard:").row().actor(finalShowText).row().actor(OptionLib.SHOW_COPY.makeCogActor()).pix();
                Main.getCurrentScreen().push(a, true, true, false, 0.8f);
                Tann.center(a);
                return true;
            }
        });
        Main.getCurrentScreen().addPopup(a);
    }

    public static Actor makeSimpleCopyButton(final String toCopy) {
        StandardButton butt = new StandardButton(TextWriter.getTag(CLIPBOARD_COL) + "copy");
        butt.setRunnable(new Runnable(){

            @Override
            public void run() {
                Main.getCurrentScreen().popSingleMedium();
                ClipboardUtils.copyWithSoundAndToast(toCopy);
                Main.getCurrentScreen().showDialog(TextWriter.getTag(CLIPBOARD_COL) + "Copied [text]" + toCopy + "[cu] to clipboard", CLIPBOARD_COL);
            }
        });
        return butt;
    }
}

