/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.util.Colours;
import com.tann.dice.util.ui.TextWriter;

public class BorderText
extends Group {
    public BorderText(String text) {
        this(text, Colours.dark);
    }

    public BorderText(String text, Color outer) {
        this(text, outer, 1);
    }

    public BorderText(String text, Color outer, int border) {
        this.setTransform(false);
        String outerString = TextWriter.getTag(outer) + TextWriter.stripTags(text);
        TextWriter ex = new TextWriter(text);
        this.setSize(ex.getWidth() + (float)(border * 2), ex.getHeight() + (float)(border * 2));
        int size = 1 + border * 2;
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                int dy;
                int dx = Math.abs(border - x);
                float dist = (float)Math.sqrt(dx * dx + (dy = Math.abs(border - y)) * dy);
                if (dist > (float)border) continue;
                TextWriter tw = new TextWriter(outerString);
                this.addActor(tw);
                tw.setPosition(x, y);
            }
        }
        TextWriter tw = new TextWriter(text);
        this.addActor(tw);
        tw.setPosition(border, border);
    }
}

