/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util.saves;

import com.badlogic.gdx.Preferences;
import com.tann.dice.Main;
import com.tann.dice.gameplay.context.config.ContextConfig;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.saves.EncUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Prefs {
    private static final String MAIN_FILE = Main.self().control.getMainFileString();
    private static final String BACKUP_FILE = Prefs.makeBackupString(MAIN_FILE);
    private static final String V2_FILE = "slice-and-dice-2";
    public static final String STATS = "stats";
    public static final String RUN_HISTORY = "run_history";
    public static final String SETTINGS = "settings";
    private static Preferences prefs;

    private static String makeBackupString(String main) {
        if (main.contains(".")) {
            return main.replace(".", "x.");
        }
        return main + "x";
    }

    private static Preferences get() {
        if (prefs == null) {
            TannLog.log("init prefs1");
            prefs = Main.self().control.makePrefs(MAIN_FILE);
            TannLog.log("init prefs2");
            Prefs.initPrefs();
            TannLog.log("init prefs3");
        }
        return prefs;
    }

    private static void initPrefs() {
        boolean v2r;
        if (!Prefs.isNew(prefs)) {
            return;
        }
        boolean backupd = false;
        if (Main.self().control.useBackups()) {
            TannLog.log("new save file, checking for files to restore from");
            backupd = Prefs.attemptToRestoreFrom(BACKUP_FILE, prefs, false);
        }
        if (!backupd && (v2r = Prefs.attemptToRestoreFrom(V2_FILE, prefs, true))) {
            ContextConfig.CLEAR_ALL_SAVES();
        }
    }

    private static boolean attemptToRestoreFrom(String fileName, Preferences tmp, boolean migration) {
        Preferences otherFile = Main.self().control.makePrefs(fileName);
        if (Prefs.isNew(otherFile)) {
            TannLog.log("No file detected with name " + fileName);
            return false;
        }
        TannLog.log("restoring from " + fileName);
        Prefs.restore(tmp, otherFile, migration);
        return true;
    }

    private static void restore(Preferences tmp, Preferences otherFile, boolean migration) {
        boolean plainText = otherFile.getString(SETTINGS).contains("lastVersion");
        List<String> toChk = migration ? Arrays.asList(STATS) : Arrays.asList(STATS, RUN_HISTORY, SETTINGS);
        for (String tag : toChk) {
            String ofs = otherFile.getString(tag);
            String toPut = plainText && Main.self().control.saveContentEncryption() ? EncUtils.encrypt(ofs) : ofs;
            tmp.putString(tag, toPut);
        }
        tmp.flush();
    }

    private static boolean isNew(Preferences prefs) {
        return prefs.getString(SETTINGS, null) == null;
    }

    public static void setString(String key, String value) {
        if (Main.self().control.saveContentEncryption()) {
            value = EncUtils.encrypt(value);
        }
        Prefs.get().putString(key, value);
        Prefs.get().flush();
    }

    public static String getString(String key, String def) {
        String result = Prefs.get().getString(key, def);
        if (Main.self().control.saveContentEncryption()) {
            result = EncUtils.decrypt(result);
        }
        return result;
    }

    public static void clearPref(String key) {
        if (!Prefs.get().contains(key)) {
            return;
        }
        Prefs.get().remove(key);
        Prefs.get().flush();
    }

    public static void RESETSAVEDATA() {
        for (String s : new String[]{MAIN_FILE, BACKUP_FILE}) {
            Preferences p = Main.self().control.makePrefs(s);
            p.clear();
            p.flush();
        }
        prefs = null;
    }

    public static void backupSave() {
        Preferences clone = Main.self().control.makePrefs(BACKUP_FILE);
        clone.clear();
        clone.put(Prefs.getAllSaveData());
        clone.flush();
    }

    private static Map<String, ?> getAllSaveData() {
        return Prefs.get().get();
    }
}

