/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ScreenshotGenerator {
    private static Map<Runnable, Float> pendingRunnables = new HashMap<Runnable, Float>();
    private static int screenshotNumber = 0;

    public static void tick(float delta) {
        HashMap<Runnable, Float> clones = new HashMap<Runnable, Float>();
        clones.putAll(pendingRunnables);
        for (Runnable r : new HashSet(clones.keySet())) {
            float newValue = ((Float)clones.get(r)).floatValue() - delta;
            if (newValue <= 0.0f) {
                r.run();
                clones.remove(r);
                continue;
            }
            clones.put(r, Float.valueOf(newValue));
        }
        pendingRunnables = clones;
    }

    public void generate() {
        FileHandle handle = Gdx.files.local("../../randombits/screenshots/specs.json");
        String contents = handle.readString();
        JsonValue fromJson = new JsonReader().parse(contents);
        JsonValue sizes = fromJson.get("sizes");
        for (int i = 0; i < sizes.size; ++i) {
            final String size = sizes.getString(i);
            System.out.println(size);
            String[] parts = size.split("x");
            final int width = Integer.valueOf(parts[0]);
            final int height = Integer.valueOf(parts[1]);
            final Graphics.DisplayMode dm = Gdx.graphics.getDisplayMode();
            System.out.println("resolution: " + dm.width + "x" + dm.height);
            pendingRunnables.put(new Runnable(){

                @Override
                public void run() {
                    float targetWidth = width;
                    float targetHeight = height;
                    while (targetWidth > (float)dm.width || targetHeight > (float)dm.height) {
                        targetWidth = (float)((double)targetWidth * 0.8);
                        targetHeight = (float)((double)targetHeight * 0.8);
                    }
                    Gdx.graphics.setWindowedMode((int)targetWidth, (int)targetHeight);
                }
            }, Float.valueOf(2.0f * (float)i));
            final String suffix = "_" + screenshotNumber;
            pendingRunnables.put(new Runnable(){

                @Override
                public void run() {
                    ScreenshotGenerator.snap(size, suffix);
                }
            }, Float.valueOf(2.0f * (float)i + 1.0f));
        }
        ++screenshotNumber;
    }

    private static void snap(String name, String suffix) {
        Pixmap pixmap = Pixmap.createFromFrameBuffer(0, 0, Gdx.graphics.getBackBufferWidth(), Gdx.graphics.getBackBufferHeight());
        ByteBuffer pixels = pixmap.getPixels();
        int size = Gdx.graphics.getBackBufferWidth() * Gdx.graphics.getBackBufferHeight() * 4;
        for (int i = 3; i < size; i += 4) {
            pixels.put(i, (byte)-1);
        }
        String path = "../../randombits/screenshots/output/" + name + suffix + ".png";
        FileHandle file = Gdx.files.local(path);
        PixmapIO.writePNG(file, pixmap, -1, true);
        String command = "convert " + file.path() + " -resize " + name + "! " + path;
        System.out.println(command);
        try {
            Process p = Runtime.getRuntime().exec(command);
            p.waitFor();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        pixmap.dispose();
    }
}

