/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.util;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.battleTest.BattleResult;
import com.tann.dice.gameplay.battleTest.BattleTest;
import com.tann.dice.gameplay.battleTest.Difficulty;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.die.side.EntSidesLib;
import com.tann.dice.gameplay.content.ent.group.Party;
import com.tann.dice.gameplay.content.ent.type.EntType;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.EntTypeUtils;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeLib;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.context.config.ContextConfig;
import com.tann.dice.gameplay.context.config.difficultyConfig.ClassicConfig;
import com.tann.dice.gameplay.context.config.misc.BalanceConfig;
import com.tann.dice.gameplay.effect.Trait;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.effect.targetable.ability.spell.Spell;
import com.tann.dice.gameplay.effect.targetable.ability.spell.SpellLib;
import com.tann.dice.gameplay.level.Level;
import com.tann.dice.gameplay.level.LevelUtils;
import com.tann.dice.gameplay.level.Symmetricality;
import com.tann.dice.gameplay.mode.general.nightmare.NightmareConfig;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.screens.titleScreen.GameStart;
import com.tann.dice.util.Colours;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.listener.TannListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DebugUtilsUseful {
    public static DungeonContext dummyContext() {
        return DebugUtilsUseful.dummyContext(1);
    }

    public static DungeonContext dummyContext(int lv) {
        return new DungeonContext(new ClassicConfig(Difficulty.Normal), Party.generate(lv - 1), lv);
    }

    public static DungeonContext dummyContext(ContextConfig config) {
        return new DungeonContext(config, Party.generate(0), 1);
    }

    public static Group makeFreqGroup(Difficulty difficulty, int iterations) {
        return DebugUtilsUseful.makeFreqGroup(difficulty, iterations, null);
    }

    public static Group makeFreqGroup(Difficulty difficulty, int iterations, Integer levelRestriction) {
        int i;
        Pixl p = new Pixl(3, 5).border(difficulty.getColor());
        long t = System.currentTimeMillis();
        p.text("Most frequent levels for " + difficulty.getColourTaggedName() + " - " + iterations + " iterations").row();
        ArrayList<Level> levels = new ArrayList<Level>();
        if (levelRestriction == null) {
            for (int i2 = 0; i2 < iterations; ++i2) {
                levels.addAll(LevelUtils.generateFor(difficulty));
            }
        } else {
            for (int i2 = 0; i2 < iterations; ++i2) {
                levels.add(LevelUtils.generateFor(difficulty, levelRestriction));
            }
        }
        ArrayList freqMap = new ArrayList();
        ArrayList diffDeltaMap = new ArrayList();
        int MAX_LEVEL = 20;
        for (int i3 = 1; i3 <= MAX_LEVEL; ++i3) {
            freqMap.add(new HashMap());
            diffDeltaMap.add(new HashMap());
        }
        Comparator<MonsterType> cmp = new Comparator<MonsterType>(){

            @Override
            public int compare(MonsterType o1, MonsterType o2) {
                return o2.getName(false).compareTo(o1.getName(false));
            }
        };
        for (i = levels.size() - 1; i >= 0; --i) {
            Collections.sort(((Level)levels.get(i)).getMonsterList(), cmp);
        }
        for (i = 0; i < levels.size(); ++i) {
            int levelNum = levelRestriction == null ? i % MAX_LEVEL : levelRestriction;
            Level l = (Level)levels.get(i);
            HashMap tmp = (HashMap)freqMap.get(levelNum - 1);
            ((HashMap)diffDeltaMap.get(levelNum - 1)).put(l.getMonsterList(), l.getDiffD());
            if (tmp.get(l.getMonsterList()) == null) {
                tmp.put(l.getMonsterList(), 0);
            }
            tmp.put(l.getMonsterList(), (Integer)tmp.get(l.getMonsterList()) + 1);
        }
        for (int levelNumber = 1; levelNumber <= MAX_LEVEL; ++levelNumber) {
            if (levelRestriction != null && levelRestriction != levelNumber) continue;
            Pixl level = new Pixl(3, 3).border(Colours.grey);
            level.text("[grey]Level " + levelNumber).row();
            ArrayList list = new ArrayList(((HashMap)freqMap.get(levelNumber - 1)).entrySet());
            Collections.sort(list, new Comparator<Map.Entry<List<MonsterType>, Integer>>(){

                @Override
                public int compare(Map.Entry<List<MonsterType>, Integer> o1, Map.Entry<List<MonsterType>, Integer> o2) {
                    return o2.getValue() - o1.getValue();
                }
            });
            int total = 0;
            for (Map.Entry entry : list) {
                total += ((Integer)entry.getValue()).intValue();
            }
            for (int i5 = 0; i5 < Math.min(4, list.size()); ++i5) {
                final Map.Entry entry = (Map.Entry)list.get(i5);
                Pixl single = new Pixl(3, 3).border(Colours.purple);
                String txt = entry.getValue() + "/" + total;
                if (total != 100) {
                    txt = txt + " (" + Tann.floatFormat((float)((Integer)entry.getValue()).intValue() / (float)total) + ")";
                }
                single.text(txt);
                if (OptionLib.SHOW_LEVEL_DIFF.c()) {
                    single.text(Level.diffDeltaString((Float)((HashMap)diffDeltaMap.get(levelNumber - 1)).get(entry.getKey())));
                }
                single.row();
                for (MonsterType mt : (List)entry.getKey()) {
                    ImageActor ia = new ImageActor(mt.portrait);
                    single.actor(ia);
                }
                Group singleLevel = single.pix();
                final int finalLevelNum = levelNumber;
                singleLevel.addListener(new TannListener(){

                    @Override
                    public boolean action(int button, int pointer, float x, float y) {
                        Symmetricality.sort((List)entry.getKey());
                        DungeonContext dc = new DungeonContext(new BalanceConfig(finalLevelNum), Party.generate(finalLevelNum - 1), finalLevelNum);
                        List<MonsterType> hack = dc.getCurrentLevel().getMonsterList();
                        hack.clear();
                        hack.addAll((Collection)entry.getKey());
                        GameStart.start(dc);
                        return true;
                    }
                });
                level.actor(singleLevel, Main.width);
            }
            p.actor(level.pix());
            p.row();
        }
        t = System.currentTimeMillis() - t;
        p.row().text("took " + t + "ms");
        return p.pix(4);
    }

    public static List<Integer> getValidLevels(List<MonsterType> asList) {
        ArrayList<Integer> valids = new ArrayList<Integer>();
        for (int i = 1; i < 30; ++i) {
            int ret = DebugUtilsUseful.runBattle(i, asList);
            if ((ret & 2) <= 0) continue;
            valids.add(i);
        }
        return valids;
    }

    public static int runBattle(int tier, List<MonsterType> types) {
        BattleResult result = new BattleTest(tier, Difficulty.Unfair, types.toArray(new MonsterType[0])).runBattle();
        int ret = 0;
        if (result.isPlayerVictory()) {
            ret |= 1;
        }
        if (result.isValidLevel()) {
            ret |= 2;
        }
        return ret;
    }

    public static Actor showImages(int type, int width) {
        Pixl p = new Pixl(2);
        for (final TextureAtlas.AtlasRegion t : DebugUtilsUseful.getAllTextureRegions(type)) {
            if (t.name.contains("noise_packed")) continue;
            ImageActor ia = new ImageActor(t);
            ia.addListener(new TannListener(){

                @Override
                public boolean action(int button, int pointer, float x, float y) {
                    Group a = new Pixl(3, 3).border(Colours.grey).text(t.name).row().image(t).pix();
                    Main.getCurrentScreen().push(a);
                    Tann.center(a);
                    return true;
                }
            });
            p.actor(ia, width);
        }
        return p.pix();
    }

    public static List<TextureAtlas.AtlasRegion> getAllTextureRegions(int type) {
        TextureAtlas atlas;
        switch (type) {
            case 0: {
                atlas = Main.atlas;
                break;
            }
            case 1: {
                atlas = Main.atlas_3d;
                break;
            }
            case 2: {
                atlas = Main.atlas_big;
                break;
            }
            default: {
                throw new RuntimeException("blah");
            }
        }
        ArrayList<TextureAtlas.AtlasRegion> tr = new ArrayList<TextureAtlas.AtlasRegion>();
        for (TextureAtlas.AtlasRegion ar : atlas.getRegions()) {
            tr.add(ar);
        }
        return tr;
    }

    public static int getUses(EntSide target, Boolean player) {
        int total = 0;
        ArrayList<EntType> types = new ArrayList<EntType>();
        if (player == null) {
            types.addAll(HeroTypeLib.getMasterCopy());
            types.addAll(MonsterTypeLib.getMasterCopy());
        } else if (player.booleanValue()) {
            types.addAll(HeroTypeLib.getMasterCopy());
        } else {
            types.addAll(MonsterTypeLib.getMasterCopy());
        }
        for (EntType et : types) {
            for (EntSide es : et.sides) {
                if (!target.sameTexture(es)) continue;
                ++total;
            }
        }
        return total;
    }

    public static List<List<Choosable>> makeRewards(int amt) {
        ArrayList<List<Choosable>> result = new ArrayList<List<Choosable>>();
        for (int levelIndex = 0; levelIndex < amt; ++levelIndex) {
            DungeonContext dc = new DungeonContext(new NightmareConfig(), Party.generate(0), levelIndex);
            result.add(dc.getLootForPreviousLevel());
        }
        return result;
    }

    public static Map<Keyword, Integer> getUses() {
        List<Eff> effs = EntTypeUtils.getAllEffs();
        List<Keyword> ks = ItemLib.getAllKeywordRefrences();
        ks.addAll(DebugUtilsUseful.getKeywords(effs));
        HashMap<Keyword, Integer> uses = new HashMap<Keyword, Integer>();
        for (Keyword value : Keyword.values()) {
            uses.put(value, 0);
        }
        for (Keyword keyword : ks) {
            uses.put(keyword, (Integer)uses.get((Object)keyword) + 1);
        }
        return uses;
    }

    private static List<Keyword> getKeywords(List<Eff> effs) {
        ArrayList<Keyword> result = new ArrayList<Keyword>();
        for (Eff eff : effs) {
            result.addAll(eff.getKeywords());
        }
        return result;
    }

    public static String getAllStrings() {
        return DebugUtilsUseful.getHeroStrings() + DebugUtilsUseful.getMonsterStrings() + DebugUtilsUseful.getModifierStrings() + DebugUtilsUseful.itemStrings() + DebugUtilsUseful.spellStrings() + DebugUtilsUseful.traitStrings() + DebugUtilsUseful.sideStrings() + DebugUtilsUseful.getKeywordStrings();
    }

    private static String getKeywordStrings() {
        String result = "";
        for (Keyword value : Keyword.values()) {
            result = result + value.getColourTaggedString() + "-" + value.getRules() + "-" + value.getExtraRules() + "\n";
        }
        return result;
    }

    private static String sideStrings() {
        String result = "";
        HeroType et = HeroTypeLib.byName("thief");
        for (EntSide entSide : EntSidesLib.getAllSidesWithValue()) {
            result = result + entSide.toString() + "-" + entSide.getApproxTotalEffectTier(et) + "\n";
        }
        return result;
    }

    private static String traitStrings() {
        String result = "";
        for (EntType entType : EntTypeUtils.getAll()) {
            for (Trait trait : entType.traits) {
                if (!trait.visible) continue;
                result = result + entType.getName() + "-" + trait.personal.describeForSelfBuff() + "\n";
            }
        }
        return result;
    }

    private static String spellStrings() {
        String result = "";
        for (Spell spell : SpellLib.makeAllSpellsList()) {
            result = result + spell.getTitle() + "-" + spell.getBaseCost() + "-" + spell.describe() + "\n";
        }
        return result;
    }

    private static String itemStrings() {
        String result = "";
        for (Item item : ItemLib.getMasterCopy()) {
            result = result + item.getName() + "-" + item.getTier() + "-" + item.getDescription() + "\n";
        }
        return result;
    }

    private static String getMonsterStrings() {
        String result = "";
        for (MonsterType monsterType : MonsterTypeLib.getMasterCopy()) {
            String sideDetail = "";
            for (EntSide side : monsterType.sides) {
                sideDetail = sideDetail + side.getBaseEffect().describe(true);
            }
            String monString = monsterType.getName() + "-" + monsterType.getEffectiveHp() + "-" + monsterType.getAvgEffectTier(true) + "-" + monsterType.getSummonValue() + "-" + sideDetail + "\n";
            result = result + monString;
        }
        return result;
    }

    private static String getHeroStrings() {
        String result = "";
        for (HeroType heroType : HeroTypeLib.getMasterCopy()) {
            String hS = heroType.getName() + "-" + heroType.getEffectiveHp() + "-" + heroType.getAvgEffectTier(true) + "-" + DebugUtilsUseful.getAllSides(heroType) + "\n";
            result = result + hS;
        }
        return result;
    }

    private static String getAllSides(HeroType heroType) {
        String sep = ":";
        ArrayList<String> strings = new ArrayList<String>();
        for (EntSide side : heroType.sides) {
            strings.add(side.getApproxTotalEffectTier(heroType) + "");
        }
        return Tann.commaList(strings, sep, sep);
    }

    private static String getModifierStrings() {
        String result = "";
        for (Modifier modifier : ModifierLib.getAll((Boolean)null)) {
            String modString = modifier.getName() + "-" + modifier.getFloatTier() + "-" + modifier.getFullDescription() + "\n";
            result = result + modString;
        }
        return result;
    }

    public static int getLowest(List<MonsterType> asList) {
        int lowest = 5000;
        for (int i = 1; i < 30; ++i) {
            int ret = DebugUtilsUseful.runBattle(i, asList);
            if ((ret & 1) <= 0) continue;
            lowest = Math.min(lowest, i);
        }
        return lowest;
    }
}

