/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.test;

import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.modifier.ModifierType;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.gameplay.trigger.global.item.GlobalStartWithItem;
import com.tann.dice.gameplay.trigger.global.spell.GlobalLearnSpell;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.spell.learn.LearnSpell;
import com.tann.dice.test.util.Test;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TestUniqueness {
    @Test
    public static void modCounts() {
        Tann.assertEquals("Should be same number", ModifierLib.getAll().size(), ModifierLib.getAll(ModifierType.Tweak).size() + ModifierLib.getAll(ModifierType.Blessing).size() + ModifierLib.getAll(ModifierType.Curse).size());
    }

    @Test
    public static void testModifierUniqueness() {
        TestUniqueness.testUniqueness(ModifierLib.getAll((Boolean)null), new Stringifier<Modifier>(){

            @Override
            public String getString(Modifier input) {
                return input.getFullDescription();
            }
        }, new Skipifier<Modifier>(){

            @Override
            public boolean skip(Modifier input) {
                for (Global gt : input.getGlobals()) {
                    if (!(gt instanceof GlobalStartWithItem) && !(gt instanceof GlobalLearnSpell)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Test
    public static void testItemUniqueness() {
        TestUniqueness.testUniqueness(ItemLib.getMasterCopy(), new Stringifier<Item>(){

            @Override
            public String getString(Item input) {
                return input.getDescription();
            }
        }, new Skipifier<Item>(){

            @Override
            public boolean skip(Item input) {
                for (Personal pt : input.getPersonalTriggers()) {
                    if (!(pt instanceof LearnSpell)) continue;
                    return true;
                }
                String nf = input.getName(false);
                if (nf.contains("of Spades") || nf.contains("of Clubs")) {
                    return true;
                }
                String desc = input.getDescription();
                return desc.startsWith("Change ");
            }
        });
    }

    private static <T> void testUniqueness(List<T> toCheck, Stringifier<T> stringifier) {
        TestUniqueness.testUniqueness(toCheck, stringifier, new Skipifier<T>(){

            @Override
            public boolean skip(T input) {
                return false;
            }
        });
    }

    private static <T> void testUniqueness(List<T> toCheck, Stringifier<T> stringifier, Skipifier<T> skipifier) {
        ArrayList<String> descriptions = new ArrayList<String>();
        ArrayList<T> failed = new ArrayList<T>();
        for (T t : toCheck) {
            if (skipifier.skip(t)) continue;
            String desc = stringifier.getString(t);
            if (descriptions.contains(desc)) {
                for (int i = 0; i < toCheck.size(); ++i) {
                    T t2 = toCheck.get(i);
                    if (!Objects.equals(stringifier.getString(t2), desc) || t2 == t) continue;
                    failed.add(t2);
                }
                failed.add(t);
                continue;
            }
            descriptions.add(desc);
        }
        Tann.assertTrue("should be no dupes " + failed, failed.size() == 0);
    }

    static interface Stringifier<T> {
        public String getString(T var1);
    }

    static interface Skipifier<T> {
        public boolean skip(T var1);
    }
}

