/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.titleScreen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.net.HttpRequestBuilder;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.context.config.ContextConfig;
import com.tann.dice.gameplay.mode.Mode;
import com.tann.dice.gameplay.mode.meta.folder.FolderType;
import com.tann.dice.gameplay.progress.chievo.unlock.UnUtil;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.screens.Screen;
import com.tann.dice.screens.dungeon.DungeonUtils;
import com.tann.dice.screens.dungeon.panels.book.Book;
import com.tann.dice.screens.dungeon.panels.book.page.helpPage.LanguageThing;
import com.tann.dice.screens.dungeon.panels.threeD.DieSpinner;
import com.tann.dice.screens.titleScreen.ModesPanel;
import com.tann.dice.screens.titleScreen.ScaleRegionActor;
import com.tann.dice.statics.ImageUtils;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.TextWriter;
import java.util.ArrayList;
import java.util.List;

public class TitleScreen
extends Screen {
    public static final String VERSION_URL = "https://tann.fun/version/slice_and_dice";
    ImageActor logo;
    public static int LOGO_SPACE;
    Actor background;
    Actor oldBackground;
    public static String version;
    Group leftButtonsGroup;
    private static final int LOGO_SLIDE_DIST = 5;
    boolean logoIn;
    public Mode currentMode;
    Actor modeActor;
    ModesPanel modesPanel;
    int dbc;

    public TitleScreen() {
        this(Main.getSettings().getLastMode());
    }

    public TitleScreen(Mode prefMode) {
        ContextConfig.resetCache();
        if (Main.demo || prefMode == null || UnUtil.isLocked(prefMode) || !TitleScreen.getUnlockNotified().contains(Mode.CLASSIC)) {
            prefMode = Main.demo ? Mode.DEMO : Mode.CLASSIC;
        }
        this.layout(prefMode);
    }

    public static void showMode(Mode m) {
        Screen s = Main.getCurrentScreen();
        if (s instanceof TitleScreen) {
            ((TitleScreen)s).selectMode(m);
        }
    }

    @Override
    public void afterSet() {
        Main.getSettings().logVersion();
    }

    private static TextureRegion loadBackground(Mode mode) {
        return mode.getBackground();
    }

    public void layout(Mode prefMode) {
        if (prefMode == null) {
            prefMode = Main.getSettings().getLastMode();
        }
        this.currentMode = null;
        this.logoIn = false;
        this.clearChildren();
        this.resetPopupHolder();
        this.logo = new ImageActor(ImageUtils.loadExtBig("ui/logo"));
        this.logo.setTouchable(Touchable.disabled);
        LOGO_SPACE = (int)(this.logo.getHeight() + 10.0f + (float)(2 * Main.self().notch(0)));
        this.addActor(this.logo);
        Tann.center(this.logo);
        this.slideLogo(true);
        this.setupLeftButtons(null);
        this.modesPanel = new ModesPanel();
        this.modesPanel.setOnChangeMode(new Runnable(){

            @Override
            public void run() {
                TitleScreen.this.selectMode(TitleScreen.this.modesPanel.getSelectedMode());
            }
        });
        this.addActor(this.modesPanel);
        this.modesPanel.setX(Main.width - Main.self().notch(1));
        this.addListener(new TannListener(){

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                TitleScreen.this.modesPanel.slide(false, true);
                return true;
            }
        });
        TitleScreen.checkModeUnlocks(this);
        this.modesPanel.selectFirstUnlocked(prefMode);
        if (Main.self().control.checkVersion()) {
            if (version == null) {
                this.checkVersion();
            } else if (!version.equals("error")) {
                this.displayVersion(version);
            }
        }
    }

    private void addBackground(TextureRegion tr, Mode mode) {
        if (this.background != null && this.background instanceof ScaleRegionActor) {
            this.oldBackground = this.background;
            this.oldBackground.addAction(Actions.sequence((Action)Actions.alpha(0.0f, 0.5f), (Action)Actions.removeActor()));
        }
        this.background = new ScaleRegionActor(tr);
        this.background.setSize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.background != null) {
            this.background.act(delta);
        }
        if (this.oldBackground != null) {
            this.oldBackground.act(delta);
        }
    }

    private void displayVersion(String version) {
        TitleScreen.version = version;
        this.setupLeftButtons(version);
    }

    private void checkVersion() {
        Tann.thread(new Runnable(){

            @Override
            public void run() {
                Net.HttpRequest request = new HttpRequestBuilder().newRequest().method("GET").timeout(8000).url("https://tann.fun/version/slice_and_dice/" + Main.self().control.getPlatformString()).build();
                Gdx.net.sendHttpRequest(request, new Net.HttpResponseListener(){

                    @Override
                    public void handleHttpResponse(Net.HttpResponse httpResponse) {
                        final String result = httpResponse.getResultAsString().trim();
                        TannLog.log("Version check: " + result);
                        Gdx.app.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                TitleScreen.this.displayVersion(result);
                            }
                        });
                    }

                    @Override
                    public void failed(Throwable t) {
                        version = "error";
                        TannLog.log("Failed to get current version: " + t.getMessage(), TannLog.Severity.error);
                    }

                    @Override
                    public void cancelled() {
                        version = "error";
                        TannLog.log("Version fetch cancelled");
                    }
                });
            }
        });
    }

    private void setupLeftButtons(String result) {
        Mode parent;
        if (this.leftButtonsGroup != null) {
            this.leftButtonsGroup.remove();
        }
        Pixl p = new Pixl(5, 5);
        p.actor(DungeonUtils.makeCog()).row().actor(Book.makeAlmanacButton()).row().actor(LanguageThing.makeGlobeButton());
        if (Main.getSettings().isBypass()) {
            p.row().actor(OptionLib.makeLockButton());
        }
        if (result != null) {
            boolean newer;
            boolean valid = result.startsWith("1") || result.startsWith("2") || result.startsWith("3");
            boolean bl = newer = valid && Main.versionALower("3.0.18", result);
            if (newer) {
                Actor version = DungeonUtils.makeBasicButton(Images.versionNew);
                final String finalMsg = "Version: 3.0.18[n]Latest: " + result + "[n][green]New version available!";
                version.addListener(new TannListener(){

                    @Override
                    public boolean action(int button, int pointer, float x, float y) {
                        TitleScreen.this.showDialog(finalMsg, Colours.green);
                        return true;
                    }
                });
                p.row().actor(version);
            }
        }
        if (this.currentMode != null && !Main.demo && (parent = this.currentMode.getParent()) != null) {
            Actor backButton = DungeonUtils.makeBasicButton(Images.back);
            backButton.addListener(new TannListener(){

                @Override
                public boolean action(int button, int pointer, float x, float y) {
                    Sounds.playSound(Sounds.pop);
                    TitleScreen.this.selectMode(parent);
                    return true;
                }
            });
            p.row().actor(backButton);
        }
        this.leftButtonsGroup = p.pix(8);
        this.leftButtonsGroup.setTouchable(Touchable.childrenOnly);
        this.addActor(this.leftButtonsGroup);
        this.leftButtonsGroup.setPosition(Main.self().notch(3), (float)Main.height - this.leftButtonsGroup.getHeight() - (float)Main.self().notch(0));
        this.leftButtonsGroup.toBack();
    }

    public void slideLogo(boolean in) {
        if (in == this.logoIn) {
            return;
        }
        this.logoIn = in;
        this.logo.setX((int)(this.getWidth() / 2.0f - this.logo.getWidth() / 2.0f));
        if (Main.isPortrait()) {
            this.logo.setX(this.logo.getX() + 5.0f);
        }
        if (in) {
            this.logo.setY((float)Main.height - this.logo.getHeight() - 5.0f - (float)Main.self().notch(0));
        } else {
            this.logo.setY(Main.height);
        }
    }

    private void selectMode(Mode mode) {
        ContextConfig.resetCache();
        this.sdc(mode);
        if (mode == this.currentMode) {
            return;
        }
        if (mode == Mode.DEBUG) {
            mode = Mode.CLASSIC;
        }
        this.modesPanel.selectedMode = mode;
        Main.getSettings().setLastMode(mode);
        Main.getSettings().save();
        this.currentMode = mode;
        if (this.modeActor != null) {
            this.modeActor.remove();
        }
        this.modeActor = mode.makeStartGameDisplay();
        boolean showLogo = (float)Main.height - this.modeActor.getHeight() > 70.0f;
        this.slideLogo(showLogo);
        this.addActor(this.modeActor);
        this.modeActor.toBack();
        int middleX = Main.width / 2;
        this.modeActor.setX((int)((float)middleX - this.modeActor.getWidth() / 2.0f));
        int centerY = Main.height / 2;
        if (showLogo) {
            centerY = (Main.height - LOGO_SPACE) / 2;
        }
        if (mode.basicTitleBackground()) {
            centerY = (int)(this.modeActor.getHeight() * 3.0f / 4.0f);
        }
        this.modeActor.setY((int)((float)centerY - this.modeActor.getHeight() / 2.0f));
        this.addBackground(TitleScreen.loadBackground(mode), mode);
        this.setupLeftButtons(null);
    }

    private void sdc(Mode mode) {
        if (mode == Mode.ROOT) {
            ++this.dbc;
            if (this.dbc >= 60) {
                if (this.dbc % 5 == 0) {
                    Sounds.playSound(Sounds.error);
                }
                return;
            }
            for (int i = 0; i < this.dbc / 10; ++i) {
                DieSpinner a = new DieSpinner(HeroTypeUtils.random().makeEnt().getDie(), 30.0f);
                a.setTouchable(Touchable.disabled);
                this.addActor(a);
                a.addAction(Actions.delay(Tann.random(1.0f, 7.0f), Actions.removeActor()));
                Tann.randomPos(a);
            }
        }
    }

    @Override
    public void preDraw(Batch batch) {
        batch.setColor(Colours.dark);
        Draw.fillActor(batch, this);
        if (this.currentMode.basicTitleBackground()) {
            this.background.draw(batch, 1.0f);
        } else {
            Main.self().stop2d(true);
            SpriteBatch bg = Main.self().startBackground();
            if (this.background != null) {
                this.background.draw(bg, 1.0f);
            }
            if (this.oldBackground != null) {
                this.oldBackground.draw(bg, 1.0f);
            }
            Main.self().stopBackground();
            Main.self().start2d(true);
        }
    }

    @Override
    public void keyPress(int keycode) {
        switch (keycode) {
            case 32: {
                System.out.println("debug");
            }
        }
    }

    @Override
    public Screen copy() {
        return new TitleScreen(this.modesPanel.getSelectedMode());
    }

    @Override
    public void postDraw(Batch batch) {
    }

    @Override
    public void preTick(float delta) {
    }

    @Override
    public void postTick(float delta) {
    }

    public ModesPanel getModesPanel() {
        return this.modesPanel;
    }

    @Override
    public String getReportString() {
        return "from title screen";
    }

    private static void modeUnlocked(Screen screen, List<Mode> modes) {
        Pixl p = new Pixl(-1);
        boolean anyUnlocked = false;
        if (modes.size() > 5) {
            for (Mode m : modes) {
                Main.getSettings().notifyModeUnlock(m);
            }
            anyUnlocked = true;
            p.actor(new TextWriter("[b][blue]" + modes.size() + " modes unlocked!", 999, Colours.grey, 3));
        } else {
            for (Mode m : modes) {
                if (m.isDebug()) continue;
                Main.getSettings().notifyModeUnlock(m);
                if (!m.displayPopup()) continue;
                FolderType ft = m.getFolderType();
                String modeType = ft == null || m == Mode.CURSE ? "" : (Object)((Object)ft) + " ";
                p.actor(new TextWriter("New " + modeType + "mode unlocked: " + m.getTextButtonName(), 999, m.getColour(), 4));
                p.row(2);
                anyUnlocked = true;
            }
        }
        if (anyUnlocked) {
            Group g = p.pix();
            screen.push(g, 0.8f);
            Tann.center(g);
        }
    }

    public static void checkModeUnlocks(Screen screen) {
        if (Main.demo) {
            return;
        }
        ArrayList<Mode> unlockedModes = new ArrayList<Mode>();
        for (Mode m : Mode.getPlayableModes()) {
            if (m.skipUnlockNotify() || UnUtil.isLocked(m) || Main.getSettings().isModeUnlockNotified(m)) continue;
            unlockedModes.add(m);
        }
        TitleScreen.modeUnlocked(screen, unlockedModes);
    }

    public static List<Mode> getUnlockNotified() {
        ArrayList<Mode> result = new ArrayList<Mode>();
        for (Mode m : Mode.getPlayableModes()) {
            if (!Main.getSettings().isModeUnlockNotified(m)) continue;
            result.add(m);
        }
        return result;
    }

    static {
        version = null;
    }
}

