/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.shaderFx;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.Main;
import com.tann.dice.screens.dungeon.panels.entPanel.EntPanel;
import com.tann.dice.screens.shaderFx.FXAcid;
import com.tann.dice.screens.shaderFx.FXAlpha;
import com.tann.dice.screens.shaderFx.FXBurn;
import com.tann.dice.screens.shaderFx.FXContainer;
import com.tann.dice.screens.shaderFx.FXCut;
import com.tann.dice.screens.shaderFx.FXEllipse;
import com.tann.dice.screens.shaderFx.FXFlee;
import com.tann.dice.screens.shaderFx.FXSingularity;
import com.tann.dice.screens.shaderFx.FXWipe;
import com.tann.dice.util.Tann;

public enum DeathType {
    DelayedAlphaArrow,
    Acid,
    Alpha,
    Burn,
    Cut,
    CutDiagonal,
    Wipe,
    Singularity,
    Ellipse,
    Crush,
    BloodSplatterEdge,
    Flee;


    public float activate(Actor a) {
        FXContainer fxContainer;
        boolean player = true;
        EntPanel ep = null;
        Vector2 pos = Tann.getAbsoluteCoordinates(a);
        if (a instanceof EntPanel) {
            ep = (EntPanel)a;
            player = ep.ent.isPlayer();
        }
        switch (this) {
            case Acid: {
                fxContainer = new FXAcid(a);
                break;
            }
            case DelayedAlphaArrow: {
                fxContainer = new FXAlpha(a, 0.25f);
                break;
            }
            case Burn: {
                fxContainer = new FXBurn(a);
                break;
            }
            case Cut: {
                fxContainer = new FXCut(a, player ? -1 : 1, 0.2f, 0.35f, 20.0f, 0.5f, (float)(0.5 + (Math.random() * 2.0 - 1.0) * (double)0.4f));
                break;
            }
            case CutDiagonal: {
                fxContainer = new FXCut(a, player ? -1 : 1, 0.2f, 0.35f, 20.0f, 1.0f, 0.0f);
                break;
            }
            case Wipe: {
                fxContainer = new FXWipe(a, new Vector2(player ? -1.0f : 1.0f, 0.0f));
                break;
            }
            case Crush: {
                fxContainer = new FXWipe(a, new Vector2(0.0f, -1.0f));
                break;
            }
            case Singularity: {
                fxContainer = new FXSingularity(a);
                break;
            }
            case Ellipse: {
                fxContainer = new FXEllipse(a);
                break;
            }
            case BloodSplatterEdge: {
                fxContainer = new FXAlpha(a);
                int numBlood = 5;
                if (ep != null) {
                    numBlood = ep.ent.getSize().getNumBlood();
                }
                if (Main.getCurrentScreen() == null) {
                    return -1.0f;
                }
                int mult = player ? 1 : -1;
                Tann.addBlood(Main.getCurrentScreen(), numBlood, pos.x + a.getWidth() / 2.0f + a.getWidth() / 2.0f * (float)mult, 2.4f, pos.y + a.getHeight() / 2.0f, a.getHeight() / 4.0f, mult * 8, 12.0f, 0.0f, 8.0f);
                break;
            }
            case Flee: {
                fxContainer = new FXFlee(a, player);
                break;
            }
            default: {
                fxContainer = new FXAlpha(a);
            }
        }
        fxContainer.replace();
        return fxContainer.getDuration();
    }
}

