/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.entPanel;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.Hero;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.ExplanelReposition;
import com.tann.dice.screens.dungeon.panels.entPanel.choosablePanel.ItemPanel;
import com.tann.dice.screens.generalPanels.InventoryPanel;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannFont;
import com.tann.dice.util.listener.TannListener;

public class ItemHeroPanel
extends Group {
    public final Item item;
    public final Hero hero;
    final int slotIndex;

    public ItemHeroPanel(Item item, Hero hero) {
        this(item, hero, -1);
    }

    public ItemHeroPanel(final Item item, Hero hero, int slot) {
        this.hero = hero;
        this.item = item;
        this.slotIndex = slot;
        this.setTransform(false);
        int size = Images.itemBorder.getRegionHeight();
        this.setSize(size, size);
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                DungeonScreen ds = DungeonScreen.get();
                if (ds != null && item != null && ds.partyManagementPanel.hasParent() && pointer == 0) {
                    return ds.partyManagementPanel.dragPanel(ItemHeroPanel.this);
                }
                return false;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                DungeonScreen ds = DungeonScreen.get();
                if (ds != null && item != null && ds.partyManagementPanel.hasParent()) {
                    if (pointer == 0) {
                        ds.partyManagementPanel.releasePanel();
                    }
                } else {
                    super.touchUp(event, x, y, pointer, button);
                }
            }
        });
        this.addListener(new TannListener(){

            @Override
            public boolean info(int button, float x, float y) {
                DungeonScreen ds = DungeonScreen.get();
                if (ds != null && ds.partyManagementPanel.hasParent()) {
                    return false;
                }
                if (item == null || ItemHeroPanel.this.isLookingToEquip() || ItemHeroPanel.this.isDragging()) {
                    return false;
                }
                if (item instanceof Item) {
                    Actor a = Main.getCurrentScreen().getTopPushedActor();
                    if (a instanceof ItemPanel) {
                        Main.getCurrentScreen().popSingleLight();
                        ItemPanel old = (ItemPanel)a;
                        if (old.getItem() == item) {
                            return true;
                        }
                    }
                    ItemPanel exp = new ItemPanel(item, true);
                    a = Main.getCurrentScreen().getTopPushedActor();
                    Main.getCurrentScreen().push(exp, false, true, true, 0.0f);
                    Tann.center(exp);
                    Sounds.playSound(Sounds.pip);
                    if (!(a instanceof ExplanelReposition)) {
                        a = Main.getCurrentScreen();
                    }
                    return true;
                }
                return false;
            }
        });
        if (item != null) {
            Actor a = item.makeImageActor();
            this.addActor(a);
            Tann.center(a);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        boolean drawNumber;
        DungeonScreen ds = DungeonScreen.get();
        if (this.item == null && ds != null && !ds.partyManagementPanel.isDragging()) {
            return;
        }
        boolean lookingToEquip = this.isLookingToEquip();
        boolean draggingMyItem = this.isDragging();
        boolean drawBorder = lookingToEquip;
        if (this.getParent() != null && this.getParent() instanceof InventoryPanel) {
            drawBorder = true;
        }
        if (draggingMyItem || this.hasAbilityItem()) {
            drawBorder = false;
        }
        boolean canEquipMaybe = true;
        if (ds != null) {
            Item i = ds.partyManagementPanel.getDraggingItem();
            boolean bl = canEquipMaybe = i == null || i.canEquip(this.hero);
        }
        if (drawBorder && (canEquipMaybe || !lookingToEquip)) {
            batch.setColor(lookingToEquip ? Colours.light : Colours.grey);
            Draw.drawScaled(batch, Images.itemBorder, (float)((int)this.getX()), (float)((int)this.getY()), 1.0f, 1.0f);
        }
        boolean bl = drawNumber = this.item == null && (drawBorder || draggingMyItem) && this.slotIndex != -1;
        if (drawNumber) {
            if (!canEquipMaybe) {
                batch.setColor(Colours.red);
                TannFont.font.drawString(batch, "X", (float)((int)(this.getX() + this.getWidth() / 2.0f)), (float)((int)(this.getY() + this.getHeight() / 2.0f)), 1);
            } else {
                batch.setColor(Colours.withAlpha(Colours.text, 0.7f));
                TannFont.font.drawString(batch, "" + (this.slotIndex + 1), (float)((int)(this.getX() + this.getWidth() / 2.0f)), (float)((int)(this.getY() + this.getHeight() / 2.0f)), 1);
            }
        }
        super.draw(batch, parentAlpha);
    }

    private boolean hasAbilityItem() {
        return this.item != null && this.item.getAbility() != null;
    }

    private boolean isLookingToEquip() {
        DungeonScreen ds = DungeonScreen.get();
        if (ds == null) {
            return false;
        }
        return ds.partyManagementPanel.isDragging() && this.item == null;
    }

    private boolean isDragging() {
        DungeonScreen ds = DungeonScreen.get();
        if (ds == null) {
            return false;
        }
        return ds.partyManagementPanel.getDraggingItem() == this.item;
    }
}

