/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.combatEffects.slam;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.fightLog.FightLog;
import com.tann.dice.screens.dungeon.DungeonScreen;
import com.tann.dice.screens.dungeon.panels.combatEffects.CombatEffectActor;
import com.tann.dice.statics.ImageUtils;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Tann;

public class SlamEffectActor
extends CombatEffectActor {
    private static final TextureRegion crack = ImageUtils.loadExt("combatEffects/misc/crack");
    private final Actor entPanel;
    private static final float moveUp = 0.4f;
    private static final float moveDown = 0.15f;
    private static final float wait = 0.35f;

    public SlamEffectActor(Ent target) {
        this.entPanel = target.getEntPanel();
    }

    @Override
    protected void start(FightLog fightLog) {
        int moveBy = 20;
        this.entPanel.toFront();
        this.entPanel.addAction(Actions.sequence((Action)Actions.moveBy(0.0f, moveBy, 0.4f, Interpolation.pow2Out), (Action)Actions.moveBy(0.0f, -moveBy, 0.15f, Interpolation.pow3In), (Action)Actions.run(new Runnable(){

            @Override
            public void run() {
                SlamEffectActor.this.impact();
            }
        })));
    }

    private void impact() {
        Sounds.playSound(Sounds.slam);
        Image image = new Image(crack);
        DungeonScreen.get().addActor(image);
        image.addAction(Actions.sequence((Action)Actions.fadeOut(1.1f), (Action)Actions.removeActor()));
        Vector2 panelPos = Tann.getAbsoluteCoordinates(this.entPanel);
        image.setPosition(panelPos.x - this.entPanel.getWidth() * 0.7f + image.getWidth() / 2.0f, panelPos.y + this.entPanel.getHeight() / 2.0f - image.getHeight() / 2.0f);
        image.toBack();
    }

    @Override
    protected float getImpactDuration() {
        return 0.55f;
    }

    @Override
    protected float getExtraDuration() {
        return 0.35f;
    }
}

