/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.book.page.stuffPage;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.type.EntType;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeLib;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.content.gen.pipe.MissingnoPipe;
import com.tann.dice.gameplay.content.gen.pipe.Pipe;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.PipeHero;
import com.tann.dice.gameplay.content.gen.pipe.entity.hero.PipeHeroItem;
import com.tann.dice.gameplay.content.gen.pipe.entity.monster.PipeMonster;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItem;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeCache;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeMod;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.effect.eff.keyword.KUtils;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.progress.chievo.unlock.Unlockable;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.screens.dungeon.panels.Explanel.DiePanel;
import com.tann.dice.screens.dungeon.panels.book.page.BookPage;
import com.tann.dice.screens.dungeon.panels.book.page.stuffPage.PipeType;
import com.tann.dice.screens.dungeon.panels.entPanel.choosablePanel.ItemPanel;
import com.tann.dice.screens.dungeon.panels.entPanel.choosablePanel.ModifierPanel;
import com.tann.dice.screens.dungeon.panels.threeD.DieSpinner;
import com.tann.dice.screens.generalPanels.TextUrl;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.CopyButtonHolder;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Rectactor;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannFont;
import com.tann.dice.util.TannLog;
import com.tann.dice.util.TannStageUtils;
import com.tann.dice.util.lang.Words;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.ui.ClipboardUtils;
import com.tann.dice.util.ui.TextWriter;
import com.tann.dice.util.ui.resolver.MetaResolver;
import com.tann.dice.util.ui.standardButton.StandardButton;
import com.tann.dice.util.ui.standardButton.StandardButtonStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class APIUtils {
    private static final StandardButtonStyle STYLE = StandardButtonStyle.SimpleSquare;
    private static final String[] PAGES = new String[]{"info", "cool", "api", "api-2", "search"};
    public static final String ANY = "[yellow]a[cu][p][orange]n[cu][p][grey]y[cu]";
    public static final int CONTENT_GEN_AMT_SMALL = 6;
    public static final int CONTENT_GEN_AMT_LARGE = 20;

    public static Actor makeMetaApiPage(BookPage junkPage, int contentWidth) {
        String s = Main.getSettings().getLastTextmodPage();
        if (s != null && !s.isEmpty()) {
            if (s.equalsIgnoreCase("1")) {
                return APIUtils.makeMetaApiPage(junkPage, 0, contentWidth);
            }
            if (s.equalsIgnoreCase("2")) {
                return APIUtils.makeMetaApiPage(junkPage, 1, contentWidth);
            }
            if (s.equalsIgnoreCase("3")) {
                return APIUtils.makeMetaApiPage(junkPage, 2, contentWidth);
            }
            if (s.startsWith("4")) {
                if (s.length() > 1) {
                    String pipeString = s.substring(1);
                    return APIUtils.makeTMPageAPI2(contentWidth, junkPage, APIUtils.getPipe(pipeString));
                }
                return APIUtils.makeMetaApiPage(junkPage, 3, contentWidth);
            }
        }
        return APIUtils.makeMetaApiPage(junkPage, 0, contentWidth);
    }

    private static Pipe getPipe(String pipeString) {
        for (PipeType value : PipeType.values()) {
            for (Pipe content : value.contents) {
                if (!content.getIdTag().equalsIgnoreCase(pipeString)) continue;
                return content;
            }
        }
        return PipeType.Hero.getDefaultShownPipe();
    }

    public static Actor makeMetaApiPage(BookPage junkPage, int page, int contentWidth) {
        return APIUtils.makeApiPageIndex(page, contentWidth, junkPage);
    }

    private static Actor makeApiPageIndex(int pageIndex, int contentWidth, BookPage page) {
        switch (pageIndex) {
            case 0: {
                return APIUtils.makeTMPageInfo(contentWidth, page);
            }
            case 1: {
                return APIUtils.makeApiPageCool(contentWidth, page);
            }
            case 2: {
                return APIUtils.makeTMPageAPI1(contentWidth, page);
            }
            case 3: {
                return APIUtils.makeTMPageAPI2(contentWidth, page, PipeType.Modifier.getDefaultShownPipe());
            }
        }
        return new TextWriter("api page " + pageIndex + "??");
    }

    private static Actor makeApiPageCool(int contentWidth, BookPage page) {
        APIUtils.savePage("2");
        boolean pageIndex = true;
        Pixl p = APIUtils.makeTopPixl(1, page, contentWidth);
        ArrayList<Actor> actors = new ArrayList<Actor>();
        ArrayList<EntType> ents = new ArrayList<EntType>();
        ents.addAll(Arrays.asList(HeroTypeLib.byNames("Fey.hsv.00:-40:00.n.Shrine.hp.20.tier.3", "Ludus.hue.50.n.Bludus.col.b.i.wandcraft")));
        ents.addAll(Arrays.asList(MonsterTypeLib.byNames("x6.seed")));
        for (EntType entType : ents) {
            DiePanel dp = new DiePanel(entType.makeEnt(), false).withoutDice();
            actors.add(dp);
        }
        ArrayList<Choosable> unlcks = new ArrayList<Choosable>();
        unlcks.addAll(Arrays.asList(ItemLib.byName("Twisted Bar.m.0#k.flesh#self.Deaths Door.img.cloak.hsv.65:-65:15.b.900.n.Counts Cape"), ItemLib.byName("Peanut Shell.m.9.n.Peanut.tier.1.hsv.10:70:0")));
        unlcks.addAll(ModifierLib.getByNames("hero.unusable&hero.cantrip&2 Fewer Rerolls.mn.Autochess Mode.modtier.0"));
        for (Unlockable unlockable : unlcks) {
            Actor a = unlockable.makeUnlockActor(true);
            if (a.getWidth() > (float)contentWidth * 0.8f || a.getHeight() > (float)contentWidth) {
                a = unlockable.makeUnlockActor(false);
            }
            if (a.getWidth() > (float)contentWidth * 0.9f) continue;
            actors.add(a);
        }
        p.text("cool things made with [red]textmod", Math.min(55, (int)((float)contentWidth * 0.4f))).actor(OptionLib.SHOW_COPY.makeCogActor()).gap(15).row().listActor(actors, 5, (int)((float)contentWidth * 0.98f));
        return p.pix();
    }

    private static Pixl makeTopPixl(int page, final BookPage junkPage, final int contentWidth) {
        boolean TINY = contentWidth < 160;
        int GAP = TINY ? 1 : 3;
        Pixl p = new Pixl();
        for (int i = 0; i < PAGES.length; ++i) {
            boolean selected = page == i;
            StandardButton sb = new StandardButton((selected ? "[light]" : "[grey]") + PAGES[i]).setStyle(STYLE);
            if (TINY) {
                sb.makeTiny();
            }
            final int finalI = i;
            sb.setRunnable(new Runnable(){

                @Override
                public void run() {
                    if (finalI == PAGES.length - 1) {
                        APIUtils.showSearch();
                        return;
                    }
                    Sounds.playSound(Sounds.pipSmall);
                    junkPage.showThing(APIUtils.makeMetaApiPage(junkPage, finalI, contentWidth));
                }
            });
            p.actor(sb);
            if (i >= PAGES.length - 1) continue;
            p.gap(GAP);
        }
        Group a = p.pix();
        int gap = (int)(((float)contentWidth - a.getWidth()) / 2.0f);
        return new Pixl(2).gap(gap).actor(a).gap(gap).row();
    }

    private static void showSearch() {
        new MetaResolver(){

            @Override
            public void resolve(Object o) {
                Actor a = new Pixl().text("??").pix();
                if (o instanceof Choosable) {
                    Choosable ch = (Choosable)o;
                    a = ch.makeChoosableActor(true, 0);
                } else if (o instanceof Keyword) {
                    Keyword k = (Keyword)((Object)o);
                    a = KUtils.makeActor(k, null);
                } else if (o instanceof MonsterType) {
                    a = new DiePanel(((MonsterType)o).makeEnt()).withoutDice();
                }
                Main.getCurrentScreen().pushAndCenter(a, 0.8f);
            }
        }.activate();
    }

    public static Actor makeTMPageInfo(int contentWidth, BookPage page) {
        APIUtils.savePage("1");
        boolean pageIndex = false;
        Pixl p = APIUtils.makeTopPixl(0, page, contentWidth);
        String exampleHeroString = "thief.hp.50.n.Rita.i.longbow.hue.70";
        String exampleHeroStringColoured = "[orange]thief[cu][red][p].hp.50[cu][green][p].n.Rita[cu][grey][p].i.longbow[cu][p][blue].hue.70";
        String colTag = "[text]";
        int textWidth = Math.min(110, (int)((float)contentWidth * 0.45f));
        ArrayList<Actor> actors = new ArrayList<Actor>();
        actors.add(APIUtils.textIt(colTag + "[red]TextMod[cu]" + " is integrated cross-platform 'modding' by manipulating text.", textWidth));
        actors.add(APIUtils.textIt("Use your device's [light]clipboard[cu] to copy/paste/share. Create custom characters, items, modes.", textWidth));
        actors.add(new Pixl(1).text("[orange]thief[cu][red][p].hp.50[cu][green][p].n.Rita[cu][grey][p].i.longbow[cu][p][blue].hue.70", textWidth).row().actor(HeroTypeLib.byName("thief.hp.50.n.Rita.i.longbow.hue.70").makeEnt().getDiePanel().withoutDice()).pix());
        actors.add(OptionLib.SHOW_COPY.makeFullDescribedUnlockActor());
        actors.add(APIUtils.textIt("It's a bit like code:[n][orange]thief[p][red].withHp(50)[n][green].withName('Rita')[n][grey].withItem('longbow')[n][blue].withHueShift(70)[text][p];", textWidth));
        actors.add(APIUtils.textIt("You can [light]use[cu] textmod inventions into [blue]creative/[cu] modes. Or store them in Ledger-Pin.", textWidth));
        actors.add(APIUtils.textIt("For making complex things, it's recommended to use an external text-editor", textWidth));
        actors.add(APIUtils.textIt("[light]Warning: experimental[cu][n]It will be easy for you to crash the game. Be careful what you paste from the internet.", textWidth));
        actors.add(OptionLib.TEXTMOD_HIDDEN.makeCogActor());
        p.listActor(actors, 8, (int)((float)contentWidth * 0.98f));
        return p.pix(2);
    }

    private static void savePage(String extra) {
        Main.getSettings().setLastTextmodPage(extra);
    }

    private static Actor textIt(String s, int textWidth) {
        Group a = new Pixl().text(s, textWidth).pix();
        if (a.getHeight() < (float)(TannFont.font.getLineHeight() * 4)) {
            a = new Pixl().text(s, (int)((float)textWidth * 0.85f)).pix();
        }
        return a;
    }

    private static Actor makeTMPageAPI1(int contentWidth, BookPage page) {
        APIUtils.savePage("3");
        int pageIndex = 2;
        Pixl p = APIUtils.makeTopPixl(2, page, contentWidth);
        List<Actor> actors = Arrays.asList(APIUtils.makeDocumentation("modifier", Colours.purple, new ArrayList<Pipe>(PipeMod.pipes), page, contentWidth), APIUtils.makeDocumentation("hero", Colours.yellow, new ArrayList<Pipe>(PipeHero.pipes), page, contentWidth), APIUtils.makeDocumentation("monster", Colours.orange, new ArrayList<Pipe>(PipeMonster.pipes), page, contentWidth), APIUtils.makeDocumentation("item", Colours.grey, new ArrayList<Pipe>(PipeItem.pipes), page, contentWidth), APIUtils.makeDocumentation("texture", Colours.blue, Pipe.makeAllPipes(), page, contentWidth));
        Group a = Tann.makeGroup(actors.get(0));
        int gap = 3;
        int ww = (int)((float)contentWidth - a.getWidth() - 15.0f);
        float ts = Tann.layoutMinArea(actors.subList(1, actors.size()), 3, ww, 9999, 10).getHeight();
        Group b = Tann.layoutMinArea(actors.subList(1, actors.size() - 1), 3, ww, 9999, 10);
        if (a.getHeight() > b.getHeight() || ts == b.getHeight()) {
            b = Tann.layoutMinArea(actors.subList(1, actors.size()), 3, ww, 9999, 10);
        } else {
            a = new Pixl(3).actor(a).row().actor(actors.get(actors.size() - 1)).pix(18);
        }
        p.actor(a).gap(3).actor(b, contentWidth);
        String tap = Main.self().control.getSelectTapString();
        int pw = Math.min(110, (int)((float)contentWidth * 0.45f));
        Pixl inner = new Pixl(10);
        for (String s : Arrays.asList("Each line is a way of creating something, grouped by the type of object it creates. [green]" + tap + " one to see examples.", "Chain together apis for complex creations. " + PipeRegexNamed.MOD.getColDesc() + " can refer to any modifier, including ones you create", "[light]White text[cu] must be written exactly. Anything else is a token and should be replaced.", "- " + PipeRegexNamed.COLOUR.getColDesc() + " : hex color like [pink]d3e[cu][n]- " + PipeRegexNamed.ITEM.getColDesc() + " : any item[n]- " + PipeRegexNamed.ENTITY.getColDesc() + " : hero/monster[n]- " + PipeRegexNamed.UP_TO_FIFTEEN_HEX.getColDesc() + " : rng seed[n]- " + PipeRegexNamed.DIGIT.getColDesc() + " : 0-9", "Scroll up and use 'search' to test out ideas. Keep interesting things in Ledger-Pin to copy and tweak later.", new PipeHeroItem().document() + " is powerful, you can use custom items like [grey]'learn.harvest'[cu] or [grey]'t.slate'", "You can bracket things algebra-style if there are ordering issues. Many things just won't work though, try another way?", OptionLib.TEXTMOD_HIDDEN.c() ? "If you want to know about " + PipeRegexNamed.CHOOSABLE.getColDesc() + " or " + PipeRegexNamed.PHASE_STRING.getColDesc() + ", you'll need to learn yourself with paste mode probably. Or wait for someone to make a wiki." : "This is only half of it, there's an option to enable the rest.")) {
            inner.actor(new TextWriter(s, pw), contentWidth);
        }
        p.row().actor(inner.pix(2));
        return p.pix(2);
    }

    public static Actor makeTMPageAPI2(final int contentWidth, final BookPage almanacPage, Pipe selectedPipe) {
        APIUtils.savePage("4" + selectedPipe.getIdTag());
        int pageIndex = 3;
        Pixl p = APIUtils.makeTopPixl(3, almanacPage, contentWidth);
        int maxWidth = (int)((float)contentWidth * 0.95f);
        PipeType type = selectedPipe.getPipeType();
        if (type == null) {
            Main.getSettings().setLastTextmodPage(null);
            return new Pixl().text("[red]err: " + selectedPipe.getClass().getSimpleName()).pix();
        }
        for (final PipeType meta : PipeType.values()) {
            StandardButton sb = new StandardButton((meta == type ? "[light]" : "[grey]") + meta.name()).setStyle(STYLE);
            p.actor(sb, contentWidth);
            sb.setBorder(meta.col);
            if (meta == type) continue;
            sb.setRunnable(new Runnable(){

                @Override
                public void run() {
                    Sounds.playSound(Sounds.pipSmall);
                    almanacPage.showThing(APIUtils.makeTMPageAPI2(contentWidth, almanacPage, meta.getDefaultShownPipe()));
                }
            });
        }
        p.row();
        Pixl ptmp = new Pixl(2);
        List<Pipe> contents = APIUtils.sortedPipesToView(type.contents);
        int index = 0;
        for (int i = 0; i < contents.size(); ++i) {
            final Pipe pipe = contents.get(i);
            if (APIUtils.shouldSkip(pipe)) continue;
            String preTag = "[grey]";
            String text = (pipe == selectedPipe ? "[light]" : (pipe.skipAPI() ? "[purple]" : "")) + Words.DOUBLE_ALPHABET.charAt(index);
            StandardButton tb = new StandardButton(preTag + text, type.col).setStyle(STYLE);
            tb.makeTiny();
            tb.setRunnable(new Runnable(){

                @Override
                public void run() {
                    Sounds.playSound(Sounds.pipSmall);
                    almanacPage.showThing(APIUtils.makeTMPageAPI2(contentWidth, almanacPage, pipe));
                }
            });
            ptmp.actor(tb, maxWidth);
            ++index;
        }
        p.actor(ptmp.pix(), contentWidth - 10);
        if (selectedPipe.isRawTexture()) {
            p.row().actor(TextUrl.make("[pink]tx[cu] tool", "https://tann.fun/things/dice-img"));
        }
        p.row(3);
        p.actor(APIUtils.makeGenContent(selectedPipe, almanacPage, contentWidth));
        p.row(3).actor(OptionLib.SHOW_COPY.makeCogActor());
        return p.pix(2);
    }

    private static List<Pipe> sortedPipesToView(List<Pipe> pipes) {
        pipes = new ArrayList<Pipe>(pipes);
        if (!OptionLib.DISABLE_API_ORDER.c()) {
            Collections.sort(pipes, new Comparator<Pipe>(){

                @Override
                public int compare(Pipe o1, Pipe o2) {
                    if (o1.isTexturey() != o2.isTexturey()) {
                        return Boolean.compare(o1.isTexturey(), o2.isTexturey());
                    }
                    if (o1.skipAPI() != o2.skipAPI()) {
                        return Boolean.compare(o1.skipAPI(), o2.skipAPI());
                    }
                    return Boolean.compare(o2.showHigher(), o1.showHigher());
                }
            });
        }
        return pipes;
    }

    private static <T> Actor makeDocumentation(String title, Color col, List<Pipe> pipes, final BookPage page, final int contentWidth) {
        boolean texturey = title.equalsIgnoreCase("texture");
        int sectionMaxWidth = (int)((float)contentWidth * 0.5f) - 20;
        if (sectionMaxWidth < 50) {
            sectionMaxWidth = contentWidth;
        }
        int textWidth = sectionMaxWidth - 4;
        Pixl p = new Pixl(1, 2).border(col);
        p.text(TextWriter.getTag(col) + "[b]" + title).row(4);
        int actualIndex = 0;
        int startWidth = 10;
        pipes = APIUtils.sortedPipesToView(pipes);
        for (int i = 0; i < pipes.size(); ++i) {
            final Pipe pipe = pipes.get(i);
            if (APIUtils.shouldSkip(pipe) || pipe.isTexturey() != texturey || texturey && (pipe.document().contains("onster") || pipe.document().contains("item"))) continue;
            Group a = new Pixl().text((pipe.skipAPI() ? "[purple]" : "") + Words.DOUBLE_ALPHABET.charAt(actualIndex) + ")").pix();
            a.setWidth(10.0f);
            String doc = pipe.document();
            if (texturey) {
                doc = doc.replaceAll("hero", ANY);
            }
            a = new Pixl().actor(a).text("[grey]" + doc, textWidth).pix();
            a.addListener(new TannListener(){

                @Override
                public boolean action(int button, int pointer, float x, float y) {
                    page.showThing(APIUtils.makeTMPageAPI2(contentWidth, page, pipe));
                    return true;
                }
            });
            if (a.getHeight() > 8.0f) {
                Color c = Colours.withAlpha(Colours.randomHashed(pipe.getClass().getSimpleName().hashCode() + pipe.document().hashCode()), 0.09f).cpy();
                Rectactor ra = new Rectactor(a, c);
                a.addActor(ra);
                ra.toBack();
            }
            p.actor(a).row();
            ++actualIndex;
        }
        Group result = p.pix(8);
        return result;
    }

    private static boolean shouldSkip(Pipe pipe) {
        return pipe.document().equalsIgnoreCase("undocumented") || pipe instanceof MissingnoPipe || pipe instanceof PipeCache || pipe.skipAPI() && !OptionLib.TEXTMOD_HIDDEN.c();
    }

    private static Actor makeGenContent(Pipe pipe, BookPage almanacPage, int contentWidth) {
        return APIUtils.makeContent(pipe, almanacPage, contentWidth);
    }

    public static Actor makeContent(Pipe pipe, BookPage almanacPage, int contentWidth) {
        List l = pipe.examples(APIUtils.getContentGenAmt());
        if (l.isEmpty()) {
            return new Pixl().border(Colours.red).text("try again?").pix();
        }
        Object o = l.get(0);
        if (o instanceof HeroType) {
            return APIUtils.makeHeroes(pipe, pipe.examples(APIUtils.getContentGenAmt()), contentWidth);
        }
        if (o instanceof MonsterType) {
            return APIUtils.makeMonsters(pipe, pipe.examples(APIUtils.getContentGenAmt()), contentWidth);
        }
        if (o instanceof Item) {
            return APIUtils.makeItems(pipe, pipe.examples(APIUtils.getContentGenAmt()), contentWidth);
        }
        if (o instanceof Modifier) {
            return APIUtils.makeMods(pipe, pipe.examples(APIUtils.getContentGenAmt()), contentWidth);
        }
        return new Pixl(5).border(Colours.pink).text("hmm").pix();
    }

    static Actor makeMods(Pipe pipe, List<Modifier> mods, int contentWidth) {
        ArrayList<Actor> actors = new ArrayList<Actor>();
        for (int i = 0; i < mods.size(); ++i) {
            Modifier m = mods.get(i);
            ModifierPanel cp = new ModifierPanel(m, false);
            actors.add(cp);
        }
        return APIUtils.makeGen(pipe, actors, contentWidth);
    }

    static Actor makeMonsters(Pipe pipe, List<MonsterType> ex, int contentWidth) {
        ArrayList<Actor> actors = new ArrayList<Actor>();
        for (int i = 0; i < ex.size(); ++i) {
            MonsterType mt = ex.get(i);
            DiePanel dp = new DiePanel(mt.makeEnt(), false);
            dp.removeDice();
            actors.add(dp);
        }
        return APIUtils.makeGen(pipe, actors, contentWidth);
    }

    static Actor makeHeroes(Pipe pipe, List<HeroType> ex, int contentWidth) {
        ArrayList<Actor> actors = new ArrayList<Actor>();
        for (HeroType ht : ex) {
            if (ht == null) {
                TannLog.error("hmm ");
                continue;
            }
            DiePanel dp = new DiePanel(ht.makeEnt(), false);
            dp.removeDice();
            actors.add(dp);
        }
        return APIUtils.makeGen(pipe, actors, contentWidth);
    }

    static Actor makeItems(Pipe pipe, List<Item> ex, int contentWidth) {
        ArrayList<Actor> actors = new ArrayList<Actor>();
        for (int i = 0; i < ex.size(); ++i) {
            Item it = ex.get(i);
            ItemPanel cp = new ItemPanel(it, false);
            actors.add(cp);
        }
        return APIUtils.makeGen(pipe, actors, contentWidth);
    }

    private static Actor makeGen(Pipe pipe, List<Actor> actors, int contentWidth) {
        Pixl p = new Pixl(1);
        p.text(pipe.document()).gap(4).row(5);
        for (int i = 0; i < actors.size(); ++i) {
            if (actors.get(i) == null) {
                p.row(6);
                continue;
            }
            p.actor(actors.get(i), (float)contentWidth * 0.9f);
        }
        return p.pix();
    }

    public static void addCopyButton(Group g, String s) {
        APIUtils.addCopyButton(g, s, null);
    }

    public static void addCopyButton(Group g, String toCopy, String extra) {
        APIUtils.addCopyButton(g, toCopy, extra, null);
    }

    public static void addCopyButton(Group g, final String toCopy, String extra, Vector2 delta) {
        int sz;
        if (toCopy.equalsIgnoreCase("curse")) {
            return;
        }
        final ImageActor a = new ImageActor(Images.copyButton);
        g.addActor(a);
        if (delta != null) {
            a.setPosition(delta.x, delta.y);
        }
        int zi = sz = g.getChildren().size;
        for (int i = 0; i < sz; ++i) {
            if (!(g.getChild(i) instanceof DieSpinner)) continue;
            zi = i;
            break;
        }
        a.setZIndex(zi);
        a.addListener(new TannListener(){

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                if (x + y >= a.getWidth()) {
                    return false;
                }
                ClipboardUtils.copyWithSoundAndToast(toCopy);
                return true;
            }
        });
        a.setName("copy");
    }

    public static void refreshCopyButton() {
        List<Actor> copies = TannStageUtils.getActorsWithName("copy", Main.stage.getRoot());
        for (int i = copies.size() - 1; i >= 0; --i) {
            copies.get(i).remove();
        }
        if (OptionLib.shouldShowCopy()) {
            List<Actor> all = TannStageUtils.getAllActors(Main.stage.getRoot());
            for (int i = 0; i < all.size(); ++i) {
                Actor a = all.get(i);
                if (!(a instanceof CopyButtonHolder)) continue;
                ((CopyButtonHolder)((Object)a)).addCopyButton();
            }
        }
    }

    public static int getContentGenAmt() {
        return OptionLib.GENERATE_50.c() ? 20 : 6;
    }
}

