/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels.book.page.ledgerPage;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.progress.MasterStatsUtils;
import com.tann.dice.gameplay.progress.chievo.AchLib;
import com.tann.dice.gameplay.progress.chievo.Achievement;
import com.tann.dice.gameplay.progress.chievo.unlock.UnUtil;
import com.tann.dice.gameplay.progress.chievo.unlock.Unlockable;
import com.tann.dice.gameplay.progress.stats.stat.Stat;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.screens.dungeon.panels.book.TopTab;
import com.tann.dice.screens.dungeon.panels.book.page.BookPage;
import com.tann.dice.screens.dungeon.panels.book.page.ledgerPage.AchievementIconView;
import com.tann.dice.screens.dungeon.panels.book.page.ledgerPage.LedgerUtils;
import com.tann.dice.screens.dungeon.panels.book.page.stuffPage.APIUtils;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.lang.Words;
import com.tann.dice.util.ui.TextWriter;
import com.tann.dice.util.ui.choice.ChoiceDialog;
import com.tann.dice.util.ui.standardButton.StandardButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class LedgerPage
extends BookPage {
    public static final int CHALLENGES_SHOWN = 5;

    public LedgerPage(Map<String, Stat> allMergedStats, int width, int height) {
        super("[blue]ledger", allMergedStats, width, height);
    }

    @Override
    public void onFocus(String defaultSidebar) {
        super.onFocus(defaultSidebar);
        Main.stage.setScrollFocus(this.contentPanel);
    }

    @Override
    protected List<TopTab> getAllListItems() {
        ArrayList<TopTab> items = new ArrayList<TopTab>();
        for (LedgerPageType t : LedgerPageType.values()) {
            if (UnUtil.isLocked(t)) continue;
            items.add(new TopTab(t, TextWriter.getTag(t.col) + t, LedgerPage.getSideWidth()));
        }
        return items;
    }

    @Override
    protected Actor getContentActorFromSidebar(Object type, int contentWidth) {
        switch ((LedgerPageType)type) {
            case Hero: {
                return LedgerUtils.makeHeroGroup(this.allMergedStats, contentWidth);
            }
            case Monster: {
                return LedgerUtils.makeMonsterGroup(this.allMergedStats, contentWidth);
            }
            case Item: {
                return LedgerUtils.makeItemsGroup(this.allMergedStats, contentWidth);
            }
            case Modifier: {
                return LedgerUtils.makeModifiersGroup(this.allMergedStats, contentWidth, this, false, LedgerUtils.ModGenType.Designed);
            }
            case Keyword: {
                return LedgerUtils.makeKeywordsGroup(this.allMergedStats, contentWidth);
            }
            case Pin: {
                return LedgerUtils.makePinsGroup(this.allMergedStats, contentWidth, this);
            }
            case Unlock: {
                return this.makeChievoPage(contentWidth);
            }
            case TextMod: {
                return APIUtils.makeMetaApiPage(this, contentWidth);
            }
        }
        throw new RuntimeException("eep-" + type);
    }

    private Group makeChievoGroup(List<Achievement> all, List<Achievement> achievedInOrder, List<Achievement> show, int maxWidth, boolean secret) {
        boolean challenge = all.get(0).isChallenge();
        Pixl p = new Pixl(-1).row(0);
        int achieved = 0;
        for (Achievement a : all) {
            if (!a.isAchieved()) continue;
            ++achieved;
        }
        String allString = all.size() + "";
        String partString = achieved + "";
        if (secret && achieved < all.size()) {
            allString = "?";
        }
        p.text((challenge ? "[yellow]" : "[purple]") + partString + "/" + allString);
        p.row(2);
        if (achievedInOrder.size() > 1) {
            Group a = new Pixl().text("[green]most[n]recent").gap(1).text("[green]->").pix();
            Group g = Tann.makeGroup(a);
            g.setSize(35.0f, 18.0f);
            Tann.center(a);
            p.actor(g);
        }
        for (int i = achievedInOrder.size() - 1; i >= 0; --i) {
            Achievement a = achievedInOrder.get(i);
            p.actor(new AchievementIconView(a), maxWidth);
        }
        if (show.size() > 0) {
            p.row(4);
            p.text("[text]Some incomplete " + Words.plural("achievement") + ":").row(2);
            for (Achievement a : show) {
                p.actor(new AchievementIconView(a), maxWidth);
            }
        }
        return p.pix();
    }

    private Group makeChievoPage(int contentWidth) {
        Pixl p = new Pixl(0);
        int CHIEVO_GAP = 10;
        int CHIEVO_WIDTH = (int)((float)contentWidth * 0.9f);
        int INFO_GAP = 2;
        int MINI_CHIEV_GAP = 3;
        List<Achievement> extraChallenges = Main.unlockManager().getShownChallenges();
        String cc = TextWriter.getTag(Achievement.CHALLENGE_COL);
        String sc = TextWriter.getTag(Achievement.SECRET_COL);
        p.text(cc + Words.plural(Words.capitaliseFirst("achievement"))).gap(2).actor(LedgerPage.makeInfoButton(cc + "?", cc + Words.plural(Words.capitaliseFirst("achievement")) + " all unlock something.[n]" + 5 + " incomplete " + "achievement" + "s are shown below.")).row(3);
        p.actor(this.makeChievoGroup(AchLib.getChallenges(), Main.self().masterStats.getUnlockManager().getCompletedAchievements(false), extraChallenges, CHIEVO_WIDTH, false)).row(10);
        if (AchLib.anyAchieved(AchLib.getSecrets())) {
            p.text(sc + Words.plural(Words.capitaliseFirst("secret"))).gap(2).actor(LedgerPage.makeInfoButton(sc + "?", sc + Words.plural(Words.capitaliseFirst("secret")) + " are a type of achievement but they don't unlock anything and probably aren't fun to attempt!")).row(3);
            p.actor(this.makeChievoGroup(AchLib.getSecrets(), Main.self().masterStats.getUnlockManager().getCompletedAchievements(true), new ArrayList<Achievement>(), CHIEVO_WIDTH, true)).row(10);
        }
        p.actor(new Pixl(4).listActor(contentWidth, MasterStatsUtils.makeCopyAchievementsButton(), MasterStatsUtils.makeLoadProgressButton(), MasterStatsUtils.makeResetAchievementsButton(), LedgerPage.makeCopyPickRates(), OptionLib.BYPASS_UNLOCKS.makeCogActor()));
        return p.pix();
    }

    public static Actor makeCopyPickRates() {
        StandardButton copy = new StandardButton("[grey]Copy pick-rates");
        copy.setRunnable(new Runnable(){

            @Override
            public void run() {
                Sounds.playSound(Sounds.pip);
                ChoiceDialog choiceDialog = new ChoiceDialog(null, Arrays.asList(new TextWriter("[light]Copy pick-rates to clipboard?[n][nh][text]This may be very large and will not be easy to understand, I don't know what this is for yet...", 120)), ChoiceDialog.ChoiceNames.YesCancel, new Runnable(){

                    @Override
                    public void run() {
                        Main.getCurrentScreen().popSingleMedium();
                        Main.self().masterStats.savePickRatesToClipboard();
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        Main.getCurrentScreen().popSingleMedium();
                    }
                });
                Main.getCurrentScreen().push(choiceDialog, 0.8f);
                Tann.center(choiceDialog);
            }
        });
        return copy;
    }

    private static Actor makeInfoButton(String title, final String info) {
        StandardButton q = new StandardButton(title).makeTiny();
        q.setRunnable(new Runnable(){

            @Override
            public void run() {
                Sounds.playSound(Sounds.pip);
                Main.getCurrentScreen().showDialog(info);
            }
        });
        return q;
    }

    public static enum LedgerPageType implements Unlockable
    {
        Pin(Colours.blue),
        Unlock(Colours.green),
        Hero(HeroType.getIdCol()),
        Monster(MonsterType.getIdCol()),
        Item(com.tann.dice.gameplay.content.item.Item.getIdCol()),
        Modifier(Colours.purple),
        Keyword(Colours.pink),
        TextMod(Colours.red);

        final Color col;

        private LedgerPageType(Color col) {
            this.col = col;
        }

        @Override
        public Actor makeUnlockActor(boolean big) {
            return new TextWriter(this.getColourTaggedString());
        }

        @Override
        public TextureRegion getAchievementIcon() {
            return null;
        }

        @Override
        public String getAchievementIconString() {
            return "[pink]G";
        }

        public String getColourTaggedString() {
            return TextWriter.getTag(this.col) + this + "[cu]";
        }
    }
}

