/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.screens.dungeon.panels;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.gameplay.content.ent.Ent;
import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Draw;

public class DieSidePanel
extends Group {
    public static final float EQUIP_BONUS_FLASH_DURATION = 0.4f;
    public static final Color EQUIP_BONUS_FLASH_COLOUR = Colours.light;
    public static final Interpolation EQUIP_BONUS_FLASH_INTERPOLATION = Interpolation.smooth;
    public EntSide side;
    Ent ent;

    public DieSidePanel(EntSide side, Ent ent) {
        this.side = side;
        this.ent = ent;
        this.setSize(side.getTexture().getRegionWidth(), side.getTexture().getRegionHeight());
        this.setTransform(false);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.ent == null) {
            this.side.draw(batch, null, this.getX(), this.getY(), Colours.purple, null);
        } else {
            this.side.draw(batch, this.ent, this.getX(), this.getY(), this.ent.getColour(), this.ent.get2DLapel());
        }
        super.draw(batch, parentAlpha);
    }

    public void drawHighlight(Batch batch) {
        batch.setColor(Colours.light);
        Draw.drawRectangle(batch, this.getX() + this.getParent().getX(), this.getY() + this.getParent().getY(), this.getWidth(), this.getHeight(), 1);
    }
}

