/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.personal.linked;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.trigger.Collision;
import com.tann.dice.gameplay.trigger.Trigger;
import com.tann.dice.gameplay.trigger.global.linked.DipPanel;
import com.tann.dice.gameplay.trigger.global.scaffolding.turnRequirement.GlobalTurnRequirement;
import com.tann.dice.gameplay.trigger.global.scaffolding.turnRequirement.TurnRequirement;
import com.tann.dice.gameplay.trigger.global.scaffolding.turnRequirement.TurnRequirementN;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.linked.LinkedPersonal;
import com.tann.dice.screens.dungeon.panels.hourglass.HourglassElement;
import com.tann.dice.screens.dungeon.panels.hourglass.HourglassTime;
import com.tann.dice.util.lang.Words;
import java.util.Arrays;
import java.util.List;

public class PersonalTurnRequirement
extends LinkedPersonal {
    final TurnRequirement requirement;
    final Personal linked;
    static final String replaceTheTurn = "the turn";
    static final String replaceEachTurn = "each turn";
    boolean overrideShow = false;

    public PersonalTurnRequirement(int turn, Personal linked) {
        this(new TurnRequirementN(turn), linked);
    }

    public PersonalTurnRequirement(TurnRequirement requirement, Personal linked) {
        super(linked);
        this.requirement = requirement;
        this.linked = linked;
    }

    @Override
    public String describeForSelfBuff() {
        return PersonalTurnRequirement.describe(this.requirement, this.linked);
    }

    public static String describe(TurnRequirement requirement, Trigger linked) {
        String rq = requirement.describe();
        String lt = linked.describeForSelfBuff();
        if (lt.contains(replaceTheTurn)) {
            return lt.replaceAll(replaceTheTurn, rq.toLowerCase());
        }
        if (lt.endsWith(replaceEachTurn)) {
            return lt.replaceAll(replaceEachTurn, "on " + rq.toLowerCase());
        }
        if (lt.contains(replaceEachTurn)) {
            return lt.replaceAll(replaceEachTurn, rq.toLowerCase());
        }
        return Words.capitaliseFirst(rq) + ": " + lt;
    }

    @Override
    public List<Personal> getLinkedTriggers(Snapshot snapshot, EntState entState) {
        if (this.requirement.isValid(snapshot.getTurn())) {
            return Arrays.asList(this.linked);
        }
        return super.getLinkedTriggers(snapshot, entState);
    }

    @Override
    public Actor makePanelActorI(boolean big) {
        return DipPanel.makeSidePanelGroup(big, this.requirement.makePanelActor(), this.linked, GlobalTurnRequirement.TURN_COL);
    }

    @Override
    public long getCollisionBits(Boolean player) {
        return this.linked.getCollisionBits(player) | Collision.SPECIFIC_TURN;
    }

    @Override
    public HourglassElement hourglassUtil() {
        return new HourglassElement(this.requirement, this.linked.describeForSelfBuff(), HourglassTime.DURING);
    }

    @Override
    public float getPriority() {
        return -10.0f;
    }

    @Override
    public boolean showInEntPanelInternal() {
        return this.overrideShow;
    }

    public PersonalTurnRequirement show(boolean show) {
        this.overrideShow = show;
        return this;
    }

    public PersonalTurnRequirement show() {
        return this.show(true);
    }
}

