/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.personal.affectSideModular.condition;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.fightLog.EntSideState;
import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.RandomSidesView;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.AffectSideCondition;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.AddKeyword;
import com.tann.dice.util.Tann;
import java.util.ArrayList;

public class HasKeyword
extends AffectSideCondition {
    public final Keyword[] keywords;

    public HasKeyword(Keyword ... keywords) {
        this.keywords = keywords;
    }

    @Override
    public boolean validFor(EntSideState sideState, EntState owner, int triggerAffectSides) {
        for (Keyword k : this.keywords) {
            if (!sideState.getCalculatedEffect().hasKeyword(k)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String describe() {
        ArrayList<String> list = new ArrayList<String>();
        for (Keyword k : this.keywords) {
            list.add(k.getColourTaggedString());
        }
        return Tann.commaList(list);
    }

    @Override
    public boolean needsGraphic() {
        return true;
    }

    @Override
    public Actor getPrecon() {
        RandomSidesView result = new RandomSidesView(1);
        result.addDraw(new AddKeyword(this.keywords).getAddDraw(false, new ArrayList<AffectSideCondition>()));
        return result;
    }

    @Override
    public boolean needsArrow() {
        return true;
    }
}

