/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.trigger.global.linked;

import com.tann.dice.gameplay.fightLog.EntState;
import com.tann.dice.gameplay.fightLog.Snapshot;
import com.tann.dice.gameplay.trigger.Collision;
import com.tann.dice.gameplay.trigger.global.linked.GlobalLinked;
import com.tann.dice.gameplay.trigger.personal.Personal;
import java.util.List;

public class GlobalTopNonMagic
extends GlobalLinked {
    public final Personal trigger;

    public GlobalTopNonMagic(Personal trigger) {
        super(trigger);
        this.trigger = trigger;
    }

    @Override
    public String describeForSelfBuff() {
        String end = this.trigger.describeForSelfBuff();
        return "The top non-magic hero:[n]" + end;
    }

    @Override
    public Personal getLinkedTrigger(EntState entState) {
        if (!entState.getEnt().isPlayer()) {
            return super.getLinkedTrigger(entState);
        }
        if (!this.isValid(entState)) {
            return null;
        }
        return this.trigger;
    }

    private boolean isValid(EntState entState) {
        Snapshot s = entState.getSnapshot();
        List<EntState> ents = s.getStates(true, false);
        for (int i = 0; i < ents.size(); ++i) {
            EntState e = ents.get(i);
            if ((e.getEnt().entType.getCollisionBits() & Collision.SPELL) != 0L) continue;
            return e == entState;
        }
        return false;
    }
}

