/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.progress.stats.stat.pickRate;

import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeLib;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.special.LevelupHeroChoosable;
import com.tann.dice.gameplay.progress.stats.stat.Stat;
import com.tann.dice.gameplay.progress.stats.stat.StatLib;
import com.tann.dice.gameplay.progress.stats.stat.pickRate.BitStat;
import java.util.ArrayList;
import java.util.List;

public class PickStat
extends Stat {
    public static final int REJECT_VAL = 65536;
    public static final int PICK_VAL = 1;

    public PickStat(Choosable c) {
        super(PickStat.nameFor(c));
    }

    public static String nameFor(Choosable o) {
        if (o instanceof LevelupHeroChoosable) {
            return PickStat.nameFor(((LevelupHeroChoosable)o).getHeroType());
        }
        if (o instanceof HeroType) {
            return PickStat.nameFor((HeroType)o);
        }
        if (o instanceof Item) {
            return PickStat.nameFor((Item)o);
        }
        if (o instanceof Modifier) {
            return PickStat.nameFor((Modifier)o);
        }
        if (o == null) {
            return "no pick for null";
        }
        throw new RuntimeException("No pick for " + o.getClass().getSimpleName());
    }

    public static String nameFor(HeroType type) {
        return type.getName(false) + "-hp";
    }

    public static String nameFor(Modifier type) {
        return type.getName();
    }

    public static String nameFor(Item type) {
        return type.getName(false) + "-ip";
    }

    public static int val(Stat s, boolean reject) {
        return BitStat.val(s.getValue(), reject);
    }

    public static int getRandomValue(int rngMax) {
        return (int)(Math.random() * (double)rngMax) + (int)(Math.random() * (double)rngMax) * 65536;
    }

    public int getValue(boolean reject) {
        return PickStat.val(this, reject);
    }

    public static List<Stat> make(StatLib.StatSource statSource) {
        if (statSource == StatLib.StatSource.Dungeon) {
            return new ArrayList<Stat>();
        }
        ArrayList<Stat> result = new ArrayList<Stat>();
        for (HeroType ht : HeroTypeLib.getMasterCopy()) {
            if (ht.level == 1) continue;
            result.add(new PickStat(ht));
        }
        for (Item e : ItemLib.getMasterCopy()) {
            result.add(new PickStat(e));
        }
        return result;
    }

    @Override
    public boolean isBoring() {
        return true;
    }
}

