/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.progress.stats.stat;

import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.progress.stats.stat.Stat;
import com.tann.dice.gameplay.progress.stats.stat.endOfFight.EndOfFightStat;
import com.tann.dice.gameplay.progress.stats.stat.endOfRun.GameEndStat;
import com.tann.dice.gameplay.progress.stats.stat.endRound.EndRoundStat;
import com.tann.dice.gameplay.progress.stats.stat.leaderboardStat.LeaderboardStat;
import com.tann.dice.gameplay.progress.stats.stat.metaEnd.MetaEndOfRunStat;
import com.tann.dice.gameplay.progress.stats.stat.miscStat.MiscStat;
import com.tann.dice.gameplay.progress.stats.stat.pickRate.PickStat;
import com.tann.dice.gameplay.progress.stats.stat.rollStat.RollPhaseStat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class StatLib {
    public static List<Stat> makeAllStats() {
        return StatLib.makeAllStats(null);
    }

    public static List<Stat> makeAllStats(StatSource statSource) {
        return StatLib.makeAllStats(statSource, null);
    }

    public static List<Stat> makeAllStats(StatSource statSource, DungeonContext maybe) {
        ArrayList<Stat> stats = new ArrayList<Stat>();
        stats.addAll(EndOfFightStat.make(statSource, maybe));
        stats.addAll(PickStat.make(statSource));
        stats.addAll(GameEndStat.make());
        stats.addAll(EndRoundStat.make());
        stats.addAll(RollPhaseStat.make());
        stats.addAll(MiscStat.make());
        stats.addAll(MetaEndOfRunStat.make());
        stats.addAll(LeaderboardStat.make());
        return stats;
    }

    public static Map<String, Stat> makeStatsMap(List<Stat> allStats) {
        HashMap<String, Stat> map = new HashMap<String, Stat>();
        for (Stat s : allStats) {
            map.put(s.getName(), s);
        }
        return map;
    }

    public static List<Stat> getNonZeroStats(List<Stat> stats) {
        ArrayList<Stat> result = new ArrayList<Stat>();
        for (Stat s : stats) {
            if (s.getValue() <= 0) continue;
            result.add(s);
        }
        return result;
    }

    public static List<Stat> copy(List<Stat> nonZeroStats) {
        ArrayList<Stat> result = new ArrayList<Stat>();
        for (Stat s : nonZeroStats) {
            Stat n = new Stat(s.getName());
            n.setValue(s.getValue());
            result.add(n);
        }
        return result;
    }

    public static void mergeStats(List<Stat> base, List<Stat> add) {
        StatLib.mergeStats(base, add, false);
    }

    public static void mergeStats(List<Stat> base, List<Stat> add, boolean addNews) {
        Map<String, Stat> baseMap = StatLib.makeStatsMap(base);
        for (int addIndex = 0; addIndex < add.size(); ++addIndex) {
            Stat addStat = add.get(addIndex);
            Stat baseStat = baseMap.get(addStat.getName());
            if (baseStat != null) {
                baseStat.merge(addStat);
                continue;
            }
            if (!addNews) continue;
            base.add(addStat);
        }
    }

    public static enum StatSource {
        Master,
        Dungeon;

    }
}

