/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice;

import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.mode.Mode;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableType;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.special.EnumChoosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.special.OrChoosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.special.RandomTieredChoosable;
import com.tann.dice.gameplay.progress.chievo.unlock.Feature;
import com.tann.dice.gameplay.progress.chievo.unlock.UnUtil;
import com.tann.dice.util.TannLog;
import java.util.ArrayList;
import java.util.List;

public class ItemRewardUtils {
    public static Choosable getFinalReward(int quality, DungeonContext context) {
        ArrayList<SpecialItemRewardType> possibles = new ArrayList<SpecialItemRewardType>();
        for (SpecialItemRewardType value : SpecialItemRewardType.values()) {
            if (!value.validFor(quality, context.getContextConfig().mode)) continue;
            possibles.add(value);
        }
        return ItemRewardUtils.getActual(quality, ItemRewardUtils.randomSpecial(possibles));
    }

    private static Choosable getActual(int quality, SpecialItemRewardType type) {
        switch (type) {
            case RandomRandom: {
                ArrayList<Choosable> metas = new ArrayList<Choosable>();
                for (SpecialItemRewardType value : SpecialItemRewardType.values()) {
                    if (value == SpecialItemRewardType.SpecialKeyword7 || value == SpecialItemRewardType.SpecialKeyword1 || value == SpecialItemRewardType.RandomRandom) continue;
                    metas.add(ItemRewardUtils.getActual(quality, value));
                }
                return new OrChoosable(metas);
            }
            case SameTier: {
                return new RandomTieredChoosable(quality, 1, ChoosableType.Item);
            }
            case PlusOneMinusOne: {
                return new OrChoosable(new RandomTieredChoosable(quality - 1, 1, ChoosableType.Item), new RandomTieredChoosable(quality + 1, 1, ChoosableType.Item));
            }
            case DoubleHalf: {
                return new RandomTieredChoosable((quality + 1) / 2, 2, ChoosableType.Item);
            }
            case TripleThird: {
                return new RandomTieredChoosable((quality + 1) / 3, 3, ChoosableType.Item);
            }
            case NRandomTierOnes: {
                return new RandomTieredChoosable(1, quality, ChoosableType.Item);
            }
            case TwoNRandomTierZeros: {
                return new RandomTieredChoosable(0, quality * 2, ChoosableType.Item);
            }
            case SpecialKeyword7: {
                return EnumChoosable.RandoKeywordT7Item;
            }
            case SpecialKeyword5: {
                return EnumChoosable.RandoKeywordT5Item;
            }
            case SpecialKeyword1: {
                return EnumChoosable.RandoKeywordT1Item;
            }
        }
        throw new RuntimeException("Error getting item reward for :" + (Object)((Object)type));
    }

    private static SpecialItemRewardType randomSpecial(List<SpecialItemRewardType> possibles) {
        float totalChance = 0.0f;
        for (SpecialItemRewardType sirt : possibles) {
            totalChance += sirt.chance;
        }
        float random = (float)(Math.random() * (double)totalChance);
        if (Float.isNaN(random) || random <= 0.0f) {
            TannLog.error("randomerr");
            return SpecialItemRewardType.SameTier;
        }
        for (SpecialItemRewardType sirt : possibles) {
            if (!((random -= sirt.chance) <= 0.0f)) continue;
            return sirt;
        }
        if (possibles.size() == 0) {
            return SpecialItemRewardType.SameTier;
        }
        return possibles.get(0);
    }

    public static enum SpecialItemRewardType {
        SameTier(-99, 99, 1.0f),
        PlusOneMinusOne(-5, 98, 0.6f),
        DoubleHalf(2, 99, 0.4f),
        TripleThird(6, 99, 0.2f),
        NRandomTierOnes(3, 13, 0.03f),
        SpecialKeyword7(6, 7, 0.02f),
        SpecialKeyword5(3, 4, 0.02f),
        SpecialKeyword1(1, 2, 0.02f),
        TwoNRandomTierZeros(1, 5, 0.01f),
        RandomRandom(3, 99, 0.005f);

        final int minQuality;
        final int maxQuality;
        final float chance;

        private SpecialItemRewardType(int minQuality, int maxQuality, float chance) {
            this.minQuality = minQuality;
            this.maxQuality = maxQuality;
            this.chance = chance;
        }

        public boolean validFor(int quality, Mode mode) {
            return quality >= this.minQuality && quality <= this.maxQuality && (!UnUtil.isLocked(Feature.ALTERNATE_RANDOM_ITEMS) || this.chance > 0.7f) && (!UnUtil.isLocked(Feature.WEIRD_RANDOM_ITEMS) || this.chance > 0.1f);
        }
    }
}

