/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.modifier.modBal;

import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableType;
import com.tann.dice.util.TannLog;
import java.util.Arrays;
import java.util.List;

public class TierUtils {
    static final float ZENITH_FACTOR = 3.5f;

    private static float combineModTier(Choosable[] th) {
        return TierUtils.combineModTier(Arrays.asList(th));
    }

    private static float combineModTier(List<Choosable> th) {
        float result = 0.0f;
        for (int i = 0; i < th.size(); ++i) {
            result += th.get(i).getModTier();
        }
        return result;
    }

    public static float toModTier(ChoosableType tht, int tier) {
        switch (tht) {
            case Modifier: {
                return tier;
            }
            case Item: {
                return TierUtils.itemModTier(tier);
            }
            case Hero: {
                return TierUtils.extraHeroModTier(tier);
            }
        }
        TannLog.error("unimmp " + (Object)((Object)tht));
        return 489.0f;
    }

    public static float effectTierToModTier(float effectTier) {
        return effectTier * 3.5f;
    }

    public static float modTierToEffectTier(float modTier, int heroTier) {
        return modTier * 0.66f;
    }

    public static float extraHeroModTier(int tier) {
        return 1.0f + HeroTypeUtils.getEffectTierFor(tier) * 3.1f;
    }

    public static float levelupHeroChoosable(int tier) {
        return TierUtils.levelupHeroChoosable(tier - 1, tier);
    }

    public static float levelupHeroChoosable(int from, int to) {
        return TierUtils.extraHeroModTier(to) - TierUtils.extraHeroModTier(from);
    }

    public static float itemModTier(int tier) {
        if (tier == 0) {
            return 0.05f;
        }
        if (tier < 0) {
            return tier;
        }
        return (float)tier / 3.0f;
    }

    public static float totalModTier(List<Choosable> result) {
        float total = 0.0f;
        for (int i = 0; i < result.size(); ++i) {
            total += result.get(i).getModTier();
        }
        return total;
    }

    public static int fromModTier(ChoosableType cht, float targetModTier) {
        float lower = cht.getLower();
        float upper = cht.getUpper();
        int diff = (int)(upper - lower);
        int maxSteps = (int)(Math.log(Integer.highestOneBit(diff)) / Math.log(2.0) + 1.0);
        for (int i = 0; i < maxSteps; ++i) {
            int testTier = Math.round((upper + lower) / 2.0f);
            float val = TierUtils.toModTier(cht, testTier);
            if (val > targetModTier) {
                upper = testTier;
            } else if (val < targetModTier) {
                lower = testTier;
            } else {
                return testTier;
            }
            if (i != maxSteps - 1) continue;
            if (Math.abs(TierUtils.toModTier(cht, testTier + 1) - targetModTier) < Math.abs(val - targetModTier)) {
                return testTier + 1;
            }
            if (Math.abs(TierUtils.toModTier(cht, testTier - 1) - targetModTier) < Math.abs(val - targetModTier)) {
                return testTier - 1;
            }
            return testTier;
        }
        return -999;
    }

    public static int equivalent(ChoosableType tht, Choosable th) {
        return TierUtils.fromModTier(tht, th.getModTier());
    }

    public static int equivalent(ChoosableType tht, List<Choosable> th) {
        return TierUtils.fromModTier(tht, TierUtils.combineModTier(th));
    }

    public static int equivalentInverse(ChoosableType tht, List<Choosable> th) {
        return TierUtils.fromModTier(tht, -TierUtils.combineModTier(th));
    }

    public static float totalHeroEffectTierForTactic(int tier) {
        return (float)tier * 0.13f;
    }

    public static float doubleLoot() {
        return TierUtils.itemModTier(5) * 5.0f;
    }

    public static float doubleXp() {
        return TierUtils.levelupHeroChoosable(2) * 5.0f;
    }
}

