/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.modifier.modBal;

import com.tann.dice.gameplay.battleTest.Difficulty;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.level.Level;
import com.tann.dice.gameplay.level.LevelUtils;
import com.tann.dice.gameplay.progress.chievo.unlock.UnUtil;
import com.tann.dice.util.TannLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MonFreq {
    private static Map<MonsterType, Float> cache;
    static final int iter = 1000;

    public static float getRelativeFrequency(MonsterType type) {
        return MonFreq.getCachedFrequencies().get(type).floatValue();
    }

    private static Map<MonsterType, Float> getCachedFrequencies() {
        if (cache == null) {
            HashMap<MonsterType, Integer> monsterMap = new HashMap<MonsterType, Integer>();
            for (MonsterType monsterType : MonsterTypeLib.getMasterCopy()) {
                if (UnUtil.isLocked(monsterType)) {
                    TannLog.error("Cannot calculate monfreq with locked enemies");
                }
                monsterMap.put(monsterType, 0);
            }
            ArrayList<Level> levels = new ArrayList<Level>();
            for (int i = 0; i < 1000; ++i) {
                levels.addAll(LevelUtils.generateFor(Difficulty.Unfair));
            }
            int totalMonsters = 0;
            for (Level level : levels) {
                for (MonsterType mt : level.getMonsterList()) {
                    ++totalMonsters;
                    monsterMap.put(mt, (Integer)monsterMap.get(mt) + 1);
                }
            }
            cache = new HashMap<MonsterType, Float>();
            for (Map.Entry entry : monsterMap.entrySet()) {
                cache.put((MonsterType)entry.getKey(), Float.valueOf((float)((Integer)entry.getValue()).intValue() / (float)totalMonsters));
            }
        }
        return cache;
    }
}

