/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.modifier.modBal;

import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeLib;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.modifier.modBal.MonFreq;
import com.tann.dice.gameplay.modifier.modBal.TierUtils;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.SpecificSidesType;
import com.tann.dice.util.Tann;
import java.util.List;

public class ModTierUtils {
    private static final float DEAD_HERO_VAL = -8.0f;
    private static final float ALL_BLANK_SIDES_VAL = -5.3333335f;
    private static final float ALL_DEATH_SIDES_VAL = -4.266667f;
    private static final float ALL_PAIN_SIDES_VAL = -2.1333334f;
    private static final float WITHOUT_HERO_VAL = -7.0f;
    private static final float FULL_DAMAGED_VAL = -2.24f;
    private static final float ONE_HP_VAL = -2.6880002f;
    private static final float PLUS_ONE_HERO_HP = 0.42f;
    private static final float BONUS_ALL_SIDES = 3.0f;
    private static final float DOUBLE_SIDES = 5.3999996f;
    private static final float DOUBLE_MONSTER_HP_VAL = -20.0f;
    private static final float SET_MONSTER_HP_ONE_VAL = 35.0f;
    private static final float MONSTER_IMMUNE_TURN_1 = -11.0f;
    private static final float MONSTER_IMMUNE_TURN_2 = -5.4f;
    private static final float MONSTER_SHIELD_1_EACH_TURN = -4.5f;
    private static final float START_WITH_ONE_MANA = 1.5f;

    public static float doubleSides(float mult) {
        return 5.3999996f * mult;
    }

    public static float doubleSidesAllHeroes(float mult) {
        return 5.3999996f * mult * 5.0f;
    }

    public static float heroBonusAllSides(float add) {
        return 3.0f * add;
    }

    public static float randomItem(int tier) {
        return TierUtils.itemModTier(tier) * 0.9f;
    }

    public static float deadHero(float mult) {
        return -8.0f * mult;
    }

    public static float missingHero(float mult) {
        return -7.0f * mult;
    }

    public static float deathKeyword(float mult) {
        return -4.266667f * mult;
    }

    public static float painKeyword(float mult) {
        return -2.1333334f * mult;
    }

    public static float setSingleHeroOneHp(float mult) {
        return -2.6880002f * mult;
    }

    public static float blanked(float mult) {
        return -5.3333335f * mult;
    }

    public static float blankedStasis(float mult) {
        return ModTierUtils.blanked(mult * 1.25f);
    }

    public static float blankedStuck(float mult) {
        return ModTierUtils.blanked(mult * 1.45f);
    }

    public static float blankedSticky(float mult) {
        return ModTierUtils.blanked(mult * 1.45f);
    }

    public static float fullyPoisoned() {
        return ModTierUtils.deadHero(0.8f);
    }

    public static float startDamaged(float ratio) {
        return -2.24f * ratio;
    }

    public static float startWithMana(float manaStart) {
        return 1.5f * manaStart;
    }

    public static float bonusAllHeroHp(float flatBonus) {
        return 0.42f * flatBonus * 5.0f;
    }

    public static float extraMonsterHP(float ratio) {
        if (ratio > 0.0f) {
            return -20.0f * ratio;
        }
        return 35.0f * -ratio;
    }

    public static float monsterShieldEachTurn(float shield) {
        return -4.5f * Tann.niceTerp(shield, 10.0f, 7.0f, 0.9f);
    }

    public static float monsterImmuneTurnOne(float mult) {
        return -11.0f * mult;
    }

    public static float monsterImmuneTurnTwo(float mult) {
        return -5.4f * mult;
    }

    public static float keywordToSides(SpecificSidesType sst, float keywordVal) {
        return keywordVal * ModTierUtils.getSSTFactor(sst, keywordVal);
    }

    private static float getSSTFactor(SpecificSidesType sst, float keywordVal) {
        float result = sst.getFactor();
        float pow = 1.12f;
        result = keywordVal > 0.0f ? (float)Math.pow(result, 0.8928571343421936) : (float)Math.pow(result, 1.12f);
        return result;
    }

    public static boolean validForTier(float tier) {
        return ModTierUtils.validForTier(tier, 0.1f);
    }

    public static boolean validForTier(float tier, float thresholdFactor) {
        return Math.abs((tier - (float)Math.round(tier)) / tier) < thresholdFactor;
    }

    public static float getDamagedRatio(int damaged, int per) {
        float total = 0.0f;
        List<HeroType> heroes = HeroTypeLib.getMasterCopy();
        for (HeroType type : heroes) {
            float ratio = (float)(damaged * (type.hp / per)) / (float)type.hp;
            total += ratio;
        }
        return total / (float)heroes.size();
    }

    public static float getBonusMonsterHpRatio(int amt, int per) {
        float total = 0.0f;
        List<MonsterType> monsters = MonsterTypeLib.getMasterCopy();
        for (MonsterType type : monsters) {
            float ratio = (float)(amt * (type.hp / per)) / (float)type.hp;
            total += ratio * MonFreq.getRelativeFrequency(type);
        }
        return total;
    }

    public static float getBonusMonsterHpFlat(float flat) {
        if (flat > 0.0f) {
            return flat * -5.25f;
        }
        return (float)(Math.pow(Math.abs(flat), 0.8f) * (double)Math.signum(flat) * (double)-6.4f);
    }

    public static float calcBonusMonsterHpFlat(int flat) {
        float total = 0.0f;
        List<MonsterType> monsters = MonsterTypeLib.getMasterCopy();
        for (MonsterType type : monsters) {
            int oldHp = type.hp;
            int newHp = Math.max(1, type.hp + flat);
            float ratio = (float)(newHp - oldHp) / (float)oldHp;
            total += ratio * MonFreq.getRelativeFrequency(type);
        }
        return total;
    }

    public static float getBonusMonsterHpLetterRatio(int amt, char[] chars) {
        float total = 0.0f;
        List<MonsterType> monsters = MonsterTypeLib.getMasterCopy();
        for (MonsterType type : monsters) {
            int count = Tann.countCharsInString(chars, type.getName().toLowerCase()) * amt;
            float ratio = (float)count / (float)type.hp;
            total += ratio * MonFreq.getRelativeFrequency(type);
        }
        return total;
    }

    public static float startPoisoned(float poisonAmt) {
        int maxPoison = 8;
        return Tann.niceTerp(poisonAmt, 8.0f, 1.0f, 0.75f) * ModTierUtils.fullyPoisoned();
    }

    public static float monsterPlus(int bonus) {
        return Tann.niceTerp(bonus, 3.0f, -17.0f, 0.55f);
    }
}

