/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.modifier.generation;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.gameplay.content.ent.EntSize;
import com.tann.dice.gameplay.content.ent.die.side.blob.ESB;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.effect.Buff;
import com.tann.dice.gameplay.effect.eff.Eff;
import com.tann.dice.gameplay.effect.eff.EffBill;
import com.tann.dice.gameplay.effect.eff.EffType;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.conditionalRequirement.CombinedRequirement;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.conditionalRequirement.GSCConditionalRequirement;
import com.tann.dice.gameplay.effect.eff.conditionalBonus.conditionalRequirement.ParamCondition;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.effect.targetable.ability.spell.SpellLib;
import com.tann.dice.gameplay.fightLog.event.snapshot.SoundSnapshotEvent;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierPickContext;
import com.tann.dice.gameplay.modifier.ModifierUtils;
import com.tann.dice.gameplay.modifier.generation.CurseDistribution;
import com.tann.dice.gameplay.modifier.generation.CurseSingles;
import com.tann.dice.gameplay.modifier.generation.GenUtils;
import com.tann.dice.gameplay.modifier.generation.MMS;
import com.tann.dice.gameplay.modifier.generation.ModMaker;
import com.tann.dice.gameplay.modifier.generation.NameMaker;
import com.tann.dice.gameplay.modifier.generation.TierMaker;
import com.tann.dice.gameplay.modifier.generation.tierMaker.TierMakerPreset;
import com.tann.dice.gameplay.modifier.modBal.ModTierUtils;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableType;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.gameplay.trigger.global.GlobalDescribeOnly;
import com.tann.dice.gameplay.trigger.global.GlobalMaxMana;
import com.tann.dice.gameplay.trigger.global.chance.GlobalRarity;
import com.tann.dice.gameplay.trigger.global.chance.Rarity;
import com.tann.dice.gameplay.trigger.global.changeHero.GlobalChangeHeroAll;
import com.tann.dice.gameplay.trigger.global.changeHero.effects.LevelupHero;
import com.tann.dice.gameplay.trigger.global.eff.GlobalEndTurnEff;
import com.tann.dice.gameplay.trigger.global.eff.GlobalStartTurnEff;
import com.tann.dice.gameplay.trigger.global.item.GlobalItemQuality;
import com.tann.dice.gameplay.trigger.global.item.GlobalItemQuantity;
import com.tann.dice.gameplay.trigger.global.item.GlobalLevelupQuantity;
import com.tann.dice.gameplay.trigger.global.level.GlobalAddMonster;
import com.tann.dice.gameplay.trigger.global.level.GlobalSetMonsters;
import com.tann.dice.gameplay.trigger.global.linked.GlobalAllEntitiesRestricted;
import com.tann.dice.gameplay.trigger.global.linked.GlobalAllMonstersExcept;
import com.tann.dice.gameplay.trigger.global.linked.GlobalEveryNthDice;
import com.tann.dice.gameplay.trigger.global.linked.GlobalHeroTier;
import com.tann.dice.gameplay.trigger.global.linked.GlobalPositional;
import com.tann.dice.gameplay.trigger.global.linked.GlobalSize;
import com.tann.dice.gameplay.trigger.global.linked.all.GlobalAllEntities;
import com.tann.dice.gameplay.trigger.global.linked.all.GlobalHeroes;
import com.tann.dice.gameplay.trigger.global.linked.all.GlobalMonsters;
import com.tann.dice.gameplay.trigger.global.linked.perN.PerDefeatedBossGlobal;
import com.tann.dice.gameplay.trigger.global.phase.GlobalSkipPhase;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.GlobalAddPhase;
import com.tann.dice.gameplay.trigger.global.phase.addPhase.phaseGen.PhaseGeneratorModifierPick;
import com.tann.dice.gameplay.trigger.global.roll.GlobalLockDiceLimit;
import com.tann.dice.gameplay.trigger.global.roll.GlobalNotMoreRolls;
import com.tann.dice.gameplay.trigger.global.scaffolding.HeroPosition;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.GlobalLevelRequirement;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.LevelRequirementBeforeBoss;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.LevelRequirementBoss;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.LevelRequirementEach;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.LevelRequirementRange;
import com.tann.dice.gameplay.trigger.global.scaffolding.turnRequirement.GlobalTurnRequirement;
import com.tann.dice.gameplay.trigger.global.scaffolding.turnRequirement.TurnRequirementAll;
import com.tann.dice.gameplay.trigger.global.scaffolding.turnRequirement.TurnRequirementFirst;
import com.tann.dice.gameplay.trigger.global.scaffolding.turnRequirement.TurnRequirementFirstN;
import com.tann.dice.gameplay.trigger.global.scaffolding.turnRequirement.TurnRequirementN;
import com.tann.dice.gameplay.trigger.global.spell.GlobalForgetSpell;
import com.tann.dice.gameplay.trigger.global.spell.GlobalSpellCostChange;
import com.tann.dice.gameplay.trigger.global.spell.GlobalSpellKeyword;
import com.tann.dice.gameplay.trigger.global.spell.GlobalSpellsLimit;
import com.tann.dice.gameplay.trigger.personal.IncomingEffBonus;
import com.tann.dice.gameplay.trigger.personal.OnDamage;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.AffectSides;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.AffectSideCondition;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.OrMoreCondition;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.SpecificSidesType;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.TypeCondition;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.AddKeyword;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.FlatBonus;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.MultiplyEffect;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.ReplaceWith;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.ReplaceWithBlank;
import com.tann.dice.gameplay.trigger.personal.death.OnDeathEffect;
import com.tann.dice.gameplay.trigger.personal.finalLayer.NumberLimit;
import com.tann.dice.gameplay.trigger.personal.hp.BonusHpPerBase;
import com.tann.dice.gameplay.trigger.personal.hp.MaxHP;
import com.tann.dice.gameplay.trigger.personal.hp.MaxHpSet;
import com.tann.dice.gameplay.trigger.personal.hp.StartDamagedPer;
import com.tann.dice.gameplay.trigger.personal.linked.stateCondition.GenericStateCondition;
import com.tann.dice.gameplay.trigger.personal.linked.stateCondition.PersonalConditionLink;
import com.tann.dice.gameplay.trigger.personal.linked.stateCondition.StateConditionType;
import com.tann.dice.gameplay.trigger.personal.onHit.Spiky;
import com.tann.dice.gameplay.trigger.personal.specialPips.GhostHP;
import com.tann.dice.gameplay.trigger.personal.specialPips.TriggerHPSummon;
import com.tann.dice.gameplay.trigger.personal.specialPips.pipLoc.PipLoc;
import com.tann.dice.gameplay.trigger.personal.specialPips.pipLoc.PipLocType;
import com.tann.dice.gameplay.trigger.personal.specialPips.resistive.ResistSpecialHp;
import com.tann.dice.gameplay.trigger.personal.specialPips.resistive.StoneSpecialHp;
import com.tann.dice.gameplay.trigger.personal.specialPips.resistive.ToughSpecialHp;
import com.tann.dice.gameplay.trigger.personal.startBuffed.StartPoisoned;
import com.tann.dice.gameplay.trigger.personal.startBuffed.StartRegenned;
import com.tann.dice.screens.dungeon.panels.entPanel.choosablePanel.ModifierPanel;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Tann;
import com.tann.dice.util.tp.TP;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class CurseLib {
    public static List<Modifier> makeAll() {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        result.addAll(CurseSingles.makeSingles());
        result.addAll(CurseLib.makeAmends());
        result.addAll(CurseLib.makeAllWorseItems());
        result.addAll(CurseLib.makeTriggerPips());
        result.addAll(CurseLib.makeDoom());
        result.addAll(CurseLib.makeRightPlus());
        result.addAll(CurseLib.makeRightTwoPlus());
        result.addAll(CurseLib.makePerBoss());
        result.addAll(CurseLib.makeSkipPhases());
        result.addAll(CurseLib.makeT0Replace());
        result.addAll(CurseLib.makeColumn());
        result.addAll(CurseLib.makeRow());
        result.addAll(CurseLib.makeMonsterFlatBonus());
        result.addAll(CurseLib.makeExposeds());
        result.addAll(CurseLib.makeTypeMaluses());
        result.addAll(CurseLib.makePositionSetHp1());
        result.addAll(CurseLib.makeSmallBonus());
        result.addAll(CurseLib.makeShieldResponse());
        result.addAll(CurseLib.makeCaltrops());
        result.addAll(CurseLib.makeMortality());
        result.addAll(CurseLib.makeBasicChains());
        result.addAll(CurseLib.makeMeta());
        result.addAll(CurseLib.makeNth());
        result.addAll(GlobalSetMonsters.makeDesigned());
        return result;
    }

    private static List<Modifier> makeNth() {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        result.add(GlobalEveryNthDice.makeNthKeyword(4, Keyword.death));
        result.add(GlobalEveryNthDice.makeNthKeyword(3, Keyword.death));
        result.add(GlobalEveryNthDice.makeNthKeyword(2, Keyword.death));
        result.add(GlobalEveryNthDice.makeNthKeyword(5, Keyword.pain));
        result.add(GlobalEveryNthDice.makeNthKeyword(3, Keyword.pain));
        result.add(GlobalEveryNthDice.makeNthKeyword(2, Keyword.pain));
        result.add(GlobalEveryNthDice.makeNthKeyword(4, Keyword.singleUse));
        result.add(GlobalEveryNthDice.makeNthKeyword(3, Keyword.singleUse));
        result.add(GlobalEveryNthDice.makeNthKeyword(2, Keyword.singleUse));
        result.add(GlobalEveryNthDice.makeNthKeyword(4, Keyword.exert));
        result.add(GlobalEveryNthDice.makeNthKeyword(3, Keyword.exert));
        result.add(GlobalEveryNthDice.makeNthKeyword(2, Keyword.exert));
        return result;
    }

    public static List<Modifier> makeDoom() {
        return GenUtils.cChain("Doom", new TierMakerPreset(-1, -2, -3, -4, -6, -8, -13, -25), (ModMaker)new MMS(Rarity.FIFTH){

            @Override
            public Global ms(int i) {
                return new GlobalTurnRequirement(new TurnRequirementN(8 - i), (Global)new GlobalEndTurnEff(new EffBill().friendly().group().damage(8).bEff()));
            }
        });
    }

    private static List<Modifier> makeBasicChains() {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        result.addAll(GenUtils.cChain("Quick Nap", new TierMakerPreset(-17, -40, -90), (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalTurnRequirement(i == 0 ? new TurnRequirementFirst() : new TurnRequirementFirstN(i + 1), (Global)new GlobalHeroes(new AffectSides(new ReplaceWithBlank(ChoosableType.Modifier)).buffPriority()));
            }
        }));
        result.addAll(GenUtils.cChain("Slippery Dice", new TierMakerPreset(-1, -2, -4, -6), (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalLockDiceLimit(3 - i);
            }
        }));
        result.addAll(GenUtils.cChain("Heavy Dice", new TierMakerPreset(-1, -2, -3, -10), (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalNotMoreRolls(4 - i);
            }
        }));
        result.addAll(GenUtils.cChain("Tough Hp", 4, new TierMaker(){

            @Override
            public float makeTier(int i) {
                return ModTierUtils.getBonusMonsterHpFlat((float)(Math.pow(i + 1, 0.83f) * (double)1.28f));
            }
        }, new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalMonsters(new ToughSpecialHp(2, new PipLoc(PipLocType.LeftmostN, i + 1)));
            }
        }));
        result.addAll(GenUtils.cChain("Big Hitter", 6, (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalMonsters(new AffectSides((AffectSideCondition)new OrMoreCondition((int)((float)(9 - i) * 1.1f)), new MultiplyEffect(2)));
            }
        }));
        result.addAll(GenUtils.cChain("Death Shield", 2, new TierMaker(){

            @Override
            public float makeTier(int i) {
                return ModTierUtils.monsterShieldEachTurn(0.35f * (float)(i + 1) + 0.0f);
            }
        }, new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalMonsters(new OnDeathEffect(new EffBill().shield(i + 1).group().bEff()));
            }
        }));
        result.addAll(GenUtils.cChain("Sickly", 4, (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                if (i == 0) {
                    return new GlobalAllEntitiesRestricted(true, new CombinedRequirement(new ParamCondition(ParamCondition.ParamConType.OrLessHp, 1), new GSCConditionalRequirement(StateConditionType.Dying)), (Personal)new AffectSides(new AddKeyword(Keyword.pain)).buffPriority());
                }
                return new GlobalAllEntitiesRestricted(true, new ParamCondition(ParamCondition.ParamConType.OrLessHp, i), (Personal)new AffectSides(new AddKeyword(Keyword.pain)).buffPriority());
            }
        }));
        result.addAll(GenUtils.cChain("Mana Debt", 7, (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                switch (i) {
                    default: {
                        return new GlobalSpellCostChange(3, (Integer)3);
                    }
                    case 1: {
                        return new GlobalSpellCostChange(1, (Integer)1);
                    }
                    case 2: {
                        return new GlobalSpellCostChange(2, (Integer)1);
                    }
                    case 3: {
                        return new GlobalSpellCostChange(3, (Integer)1);
                    }
                    case 4: {
                        return new GlobalSpellCostChange(5, (Integer)2);
                    }
                    case 5: {
                        return new GlobalSpellCostChange(4, (Integer)1);
                    }
                    case 6: 
                }
                return new GlobalSpellCostChange(6, (Integer)1);
            }
        }));
        result.addAll(GenUtils.cChain("Tower", 4, (ModMaker)new MMS(Rarity.THIRD){

            @Override
            public Global ms(int i) {
                return new GlobalSize(EntSize.huge, new MaxHP((int)Math.pow(3.5f * (float)(i + 1), 1.2f)));
            }
        }));
        result.addAll(GenUtils.cChain("Bottom Poison", 4, (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalPositional(HeroPosition.BOT, new StartPoisoned(1 + i + i / 3));
            }
        }));
        result.addAll(GenUtils.cChain("Skulk", new TierMakerPreset(-1, -2, -4), new ModMaker(){

            @Override
            public List<Global> make(int level) {
                return Arrays.asList(new GlobalTurnRequirement(new TurnRequirementN(4 - level - 1), (Global)new GlobalStartTurnEff(new Eff[]{new EffBill().group().buff(new Buff(1, new AffectSides(new FlatBonus(1)).show(true))).bEff()})));
            }
        }));
        result.addAll(GenUtils.cChain("Slow Spells", 4, new TierMaker(){

            @Override
            public float makeTier(int i) {
                switch (i) {
                    case 0: {
                        return -5.0f;
                    }
                    case 1: {
                        return -3.0f;
                    }
                    case 2: {
                        return -2.0f;
                    }
                    case 3: {
                        return -1.0f;
                    }
                }
                return 999.0f;
            }
        }, new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalSpellsLimit(i + 1);
            }
        }));
        result.addAll(GenUtils.cChain("Monster Shields", 3, new TierMaker(){

            @Override
            public float makeTier(int i) {
                return ModTierUtils.monsterShieldEachTurn(i + 1);
            }
        }, new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalStartTurnEff(new Eff[]{new EffBill().shield(i + 1).enemy().group().bEff()});
            }
        }));
        result.addAll(GenUtils.cChain("Ghostly Monsters", new TierMakerPreset(-4, -10), (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                switch (i) {
                    case 0: {
                        return new GlobalMonsters(new GhostHP(PipLoc.offsetEvery(5, 3)));
                    }
                    case 1: {
                        return new GlobalMonsters(new GhostHP(PipLoc.all()));
                    }
                }
                throw new RuntimeException("eep");
            }
        }));
        result.add(new Modifier(-16.0f, "Ghoststone", new GlobalMonsters(new StoneSpecialHp(PipLoc.offsetEvery(2, 0))), new GlobalMonsters(new GhostHP(PipLoc.offsetEvery(2, 1)))));
        result.addAll(GenUtils.cChain(2, new NameMaker(){

            @Override
            public String name(int i, List<Global> globals) {
                return 2 + i + " less max mana";
            }
        }, (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalMaxMana(-2 - i);
            }
        }));
        result.addAll(GenUtils.cChain("Boss Armour", 2, (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalLevelRequirement(new LevelRequirementBoss(), new GlobalTurnRequirement(new TurnRequirementFirst(), (Global)new GlobalStartTurnEff(new Eff[]{new EffBill().shield((i + 1) * 2).enemy().group().bEff()})));
            }
        }));
        result.addAll(GenUtils.cChain("Rushed", new TierMakerPreset(-1, -2), (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalItemQuantity(-(i + 1));
            }
        }));
        result.addAll(GenUtils.cChain("Hurried", new TierMakerPreset(-1, -2), (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalLevelupQuantity(-(i + 1));
            }
        }));
        result.addAll(GenUtils.cChain("Tunnel Vision", new TierMakerPreset(-2, -4), new ModMaker(){

            @Override
            public List<Global> make(int i) {
                return Arrays.asList(new GlobalLevelupQuantity(-(i + 1)), new GlobalItemQuantity(-(i + 1)));
            }
        }));
        result.addAll(GenUtils.cChain("Arthritis", 2, (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalHeroTier(3, new MaxHP(-i - 1));
            }
        }));
        final List<TP> data = Arrays.asList(new TP<Integer, Integer>(1, 7), new TP<Integer, Integer>(1, 5), new TP<Integer, Integer>(2, 7), new TP<Integer, Integer>(1, 4), new TP<Integer, Integer>(3, 6), new TP<Integer, Integer>(1, 3), new TP<Integer, Integer>(2, 4), new TP<Integer, Integer>(3, 5), new TP<Integer, Integer>(1, 2), new TP<Integer, Integer>(3, 4), new TP<Integer, Integer>(2, 3));
        result.addAll(GenUtils.cChain("Monster HP Per", data.size(), (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                TP datum = (TP)data.get(i);
                return new GlobalMonsters(new BonusHpPerBase((Integer)datum.a, (Integer)datum.b));
            }
        }));
        result.addAll(CurseLib.makeMonsterFlatHP(false));
        result.addAll(GenUtils.cChain("Spiky Monsters", new TierMakerPreset(-1, -2, -3, -4, -7, -14), (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                switch (i) {
                    case 0: {
                        return new GlobalAllEntitiesRestricted(false, new ParamCondition(ParamCondition.ParamConType.OrMoreMaxHp, 20), (Personal)new Spiky(1));
                    }
                    case 1: {
                        return new GlobalAllEntitiesRestricted(false, new ParamCondition(ParamCondition.ParamConType.OrMoreMaxHp, 8), (Personal)new Spiky(1));
                    }
                    case 2: {
                        return new GlobalAllEntitiesRestricted(false, new ParamCondition(ParamCondition.ParamConType.OrMoreMaxHp, 5), (Personal)new Spiky(1));
                    }
                    case 3: {
                        return new GlobalMonsters(new Spiky(1));
                    }
                    case 4: {
                        return new GlobalMonsters(new Spiky(2));
                    }
                    case 5: {
                        return new GlobalMonsters(new Spiky(5));
                    }
                }
                throw new RuntimeException();
            }
        }));
        result.addAll(GenUtils.cChain("Start Damaged", 8, (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                StartDamagedPer sdp;
                switch (i) {
                    case 0: {
                        sdp = new StartDamagedPer(6);
                        break;
                    }
                    case 1: {
                        sdp = new StartDamagedPer(4);
                        break;
                    }
                    case 2: {
                        sdp = new StartDamagedPer(2, 6);
                        break;
                    }
                    case 3: {
                        sdp = new StartDamagedPer(1, 3);
                        break;
                    }
                    case 4: {
                        sdp = new StartDamagedPer(2, 4);
                        break;
                    }
                    case 5: {
                        sdp = new StartDamagedPer(2);
                        break;
                    }
                    case 6: {
                        sdp = new StartDamagedPer(2, 3);
                        break;
                    }
                    case 7: {
                        sdp = new StartDamagedPer(3, 4);
                        break;
                    }
                    default: {
                        sdp = new StartDamagedPer(420);
                    }
                }
                return new GlobalHeroes(sdp);
            }
        }));
        result.addAll(GenUtils.cChain("Wurst", 4, (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                switch (i) {
                    case 0: {
                        return new GlobalSpellKeyword("burst", Keyword.cooldown);
                    }
                    case 1: {
                        return new GlobalSpellKeyword("burst", Keyword.deplete);
                    }
                    case 2: {
                        return new GlobalSpellKeyword("burst", Keyword.singleCast);
                    }
                    case 3: {
                        return new GlobalForgetSpell(SpellLib.BURST);
                    }
                }
                throw new RuntimeException();
            }
        }));
        result.addAll(GenUtils.cChain("Armour", 5, (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                int shieldAmt = i == 0 || i == 1 ? 1 : (i == 3 ? 2 : 3);
                int turn = i == 0 || i == 2 ? 2 : 1;
                return new GlobalTurnRequirement(new TurnRequirementN(turn), (Global)new GlobalStartTurnEff(new Eff[]{new EffBill().shield(shieldAmt).enemy().group().bEff()}));
            }
        }));
        result.add(new Modifier(-2.0f, "Restless Bones", new GlobalHeroes(new OnDeathEffect(new EffBill().summon("bones", 1).bEff(), null, false))).rarity(Rarity.THIRD));
        result.addAll(GenUtils.cChain("Monster Left", 5, (ModMaker)new MMS(Rarity.HALF){

            @Override
            public Global ms(int i) {
                return new GlobalMonsters(new AffectSides(SpecificSidesType.Left, new FlatBonus(i + 1)));
            }
        }));
        result.addAll(GenUtils.cChain("Sandstorm", new TierMakerPreset(-6, -12, -17), (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalTurnRequirement(new TurnRequirementAll(), (Global)new GlobalEndTurnEff(new EffBill().friendly().group().damage(i + 1)));
            }
        }));
        result.addAll(GenUtils.cChain("Lightning", new TierMakerPreset(-1, -3, -4), (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalTurnRequirement(new TurnRequirementN(3), (Global)new GlobalEndTurnEff(new EffBill().friendly().group().damage(i + 1)));
            }
        }));
        result.addAll(CurseLib.makeAllPoisoned());
        return result;
    }

    public static List<Modifier> makeMonsterFlatHP(final boolean bless) {
        return GenUtils.cChain(bless ? "Monster Hp Down" : "Monster HP", 5, new TierMaker(){

            @Override
            public float makeTier(int i) {
                return ModTierUtils.getBonusMonsterHpFlat((i + 1) * (bless ? -1 : 1));
            }
        }, new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalMonsters(new MaxHP((i + 1) * (bless ? -1 : 1)));
            }
        });
    }

    public static List<Modifier> makeAllPoisoned() {
        return GenUtils.cChain("All Poisoned", 5, new TierMaker(){

            @Override
            public float makeTier(int index) {
                return ModTierUtils.startPoisoned(index + 1) * 5.0f;
            }
        }, new MMS(){

            @Override
            public Global ms(int i) {
                int poisonAmt = 1 + i;
                return new GlobalHeroes(new StartPoisoned(poisonAmt));
            }
        });
    }

    public static List<Modifier> makeAllWorseItems() {
        return GenUtils.cChain("Worse Items", new TierMakerPreset(-1.2f, -3.3f, -7.0f, -11.2f), (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalItemQuality(-i - 1);
            }
        });
    }

    public static Collection<Modifier> makeRightPlus() {
        return GenUtils.cChain("Monster Right", 2, new TierMaker(){

            @Override
            public float makeTier(int index) {
                return (index + 1) * -2;
            }
        }, new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalMonsters(new AffectSides(SpecificSidesType.RightMost, new FlatBonus(i + 1)));
            }
        });
    }

    public static Collection<Modifier> makeRightTwoPlus() {
        return GenUtils.cChain("Monster Rights", 3, new TierMaker(){

            @Override
            public float makeTier(int index) {
                return (index + 1) * -3;
            }
        }, new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalMonsters(new AffectSides(SpecificSidesType.RightTwo, new FlatBonus(i + 1)));
            }
        });
    }

    public static Collection<Modifier> makeColumn() {
        return GenUtils.cChain("Monster Column", 2, new TierMaker(){

            @Override
            public float makeTier(int index) {
                return (index + 1) * -5;
            }
        }, new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalAllEntities(false, new AffectSides(SpecificSidesType.Column, new FlatBonus(i + 1)));
            }
        });
    }

    public static Collection<Modifier> makeRow() {
        return GenUtils.cChain("Monster Row", 2, new TierMaker(){

            @Override
            public float makeTier(int index) {
                return (index + 1) * -7;
            }
        }, new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalAllEntities(false, new AffectSides(SpecificSidesType.Row, new FlatBonus(i + 1)));
            }
        });
    }

    public static List<Modifier> makeMonsterFlatBonus() {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        for (int i = 0; i < 3; ++i) {
            int bonus = i + 1;
            GlobalAllEntities g = new GlobalAllEntities(false, new AffectSides(new FlatBonus(bonus)));
            result.add(new Modifier(ModTierUtils.monsterPlus(bonus), ModifierUtils.makeName("Monster Bonus", i, g), g));
        }
        return result;
    }

    public static List<Modifier> makeExposeds() {
        String name = "Exposed";
        PersonalConditionLink conLink = new PersonalConditionLink(new GSCConditionalRequirement(new GenericStateCondition(StateConditionType.GainedNoShields), true), (Personal)new IncomingEffBonus(2, true, EffType.Damage));
        GlobalRarity rarity = GlobalRarity.fromRarity(Rarity.TWO_THIRDS);
        return Arrays.asList(new Modifier(-1.0f, name + " middle", new GlobalPositional(HeroPosition.MIDDLE, conLink), rarity), new Modifier(-3.0f, name + " edges", new GlobalPositional(HeroPosition.TOP_AND_BOTTOM, conLink), rarity), new Modifier(-9.0f, name, new GlobalHeroes(conLink), rarity));
    }

    public static List<Modifier> makeAmends() {
        return GenUtils.cChain("Monster Regen", 5, (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                StartRegenned p = new StartRegenned(i / 3 + 1);
                if (i == 0) {
                    return new GlobalAllEntitiesRestricted(false, new ParamCondition(ParamCondition.ParamConType.OrLessMaxHp, 5), (Personal)p);
                }
                if (--i % 2 == 0) {
                    return new GlobalAllEntitiesRestricted(false, new ParamCondition(ParamCondition.ParamConType.OrLessMaxHp, 10), (Personal)p);
                }
                return new GlobalMonsters(p);
            }
        });
    }

    public static List<Modifier> makePerBoss() {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        result.add(new Modifier(-7.0f, "Reanimated Bosses", new PerDefeatedBossGlobal(new GlobalAddMonster(MonsterTypeLib.byName("bones")))));
        result.add(new Modifier(-15.0f, "Boss Spirits", new PerDefeatedBossGlobal(new GlobalAddMonster(MonsterTypeLib.byName("ghost")))));
        return result;
    }

    public static List<Modifier> makeSkipPhases() {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        String prefix = "Skip rewards ";
        Rarity r = Rarity.THIRD;
        GlobalSkipPhase gsp = new GlobalSkipPhase();
        result.add(new Modifier(-2.0f, prefix + 5, new GlobalLevelRequirement(new LevelRequirementRange(5), gsp)).rarity(r));
        result.add(new Modifier(-2.0f, prefix + "end", new GlobalLevelRequirement(new LevelRequirementRange(19, 20), gsp)).rarity(r));
        result.add(new Modifier(-15.0f, prefix + "later", new GlobalLevelRequirement(new LevelRequirementRange(11, 20), gsp)).rarity(r));
        result.add(new Modifier(-40.0f, "Skip Rewards", gsp).rarity(r));
        return result;
    }

    public static List<Modifier> makeT0Replace() {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        String prefix = "Delevel";
        LevelupHero dh = new LevelupHero(-1);
        result.add(new Modifier(-16.5f, prefix, new GlobalChangeHeroAll(dh)));
        return result;
    }

    public static List<Modifier> makeTriggerPips() {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        result.add(new Modifier(-4.0f, "Stone First", new GlobalTurnRequirement(1, (Global)new GlobalMonsters(new StoneSpecialHp(PipLoc.all())))));
        result.add(new Modifier(-25.0f, "Stone Monsters", new GlobalMonsters(new StoneSpecialHp(PipLoc.all()))));
        result.add(new Modifier(-5.0f, "Sparkly Monsters", new GlobalMonsters(new ResistSpecialHp(ResistSpecialHp.DamageType.Spell, new PipLoc(PipLocType.Specific, 2)))));
        result.add(new Modifier(-3.0f, "Slimedemic", new GlobalAllMonstersExcept(MonsterTypeLib.byName("slimelet"), new TriggerHPSummon("slimelet", 1, new SoundSnapshotEvent(Sounds.slime), new PipLoc(PipLocType.Specific, 2))), GlobalRarity.fromRarity(Rarity.HALF)));
        return result;
    }

    public static List<Modifier> makeTypeMaluses() {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        String suffix = " Reduced";
        GlobalRarity gr = GlobalRarity.fromRarity(Rarity.TENTH);
        for (TP tp : new TP[]{new TP<EffType, Float>(EffType.Mana, Float.valueOf(-5.0f)), new TP<EffType, Float>(EffType.Damage, Float.valueOf(-6.0f)), new TP<EffType, Float>(EffType.Shield, Float.valueOf(-3.0f)), new TP<EffType, Float>(EffType.Heal, Float.valueOf(-2.0f))}) {
            result.add(new Modifier(((Float)tp.b).floatValue(), tp.a + suffix, new GlobalHeroes(new AffectSides((AffectSideCondition)new TypeCondition((EffType)((Object)tp.a)), new FlatBonus(-1))), gr));
        }
        return result;
    }

    public static List<Modifier> makePositionSetHp1() {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        String suffix = " 1 hp";
        GlobalRarity r = GlobalRarity.fromRarity(Rarity.FIFTH);
        for (HeroPosition hp : new HeroPosition[]{HeroPosition.BOT, HeroPosition.TOP, HeroPosition.MIDDLE}) {
            result.add(new Modifier(ModTierUtils.setSingleHeroOneHp(1.0f), hp.describe().replaceAll(" hero", "") + suffix, new GlobalPositional(hp, new MaxHpSet(1)), r));
        }
        return result;
    }

    public static List<Modifier> makeSmallBonus() {
        return GenUtils.cChain("Small Bonus", new TierMakerPreset(-2, -4, -5), (ModMaker)new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalSize(EntSize.small, new AffectSides(new FlatBonus(i + 1)));
            }
        });
    }

    public static List<Modifier> makeShieldResponse() {
        return GenUtils.cChain("Shield Response", 2, new TierMaker(){

            @Override
            public float makeTier(int i) {
                return ModTierUtils.monsterShieldEachTurn(0.9f * (float)(i + 1));
            }
        }, new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalMonsters(new OnDamage(new EffBill().self().shield(i + 1).bEff(), false, null).overrideShow(false));
            }
        });
    }

    public static List<Modifier> makeCaltrops() {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        String prefix = "Caltrops";
        for (SpecificSidesType value : Arrays.asList(SpecificSidesType.RightMost, SpecificSidesType.Left, SpecificSidesType.Bot, SpecificSidesType.RightTwo)) {
            if (value.isWeird()) continue;
            float tier = ModTierUtils.blanked(value.getFactor() * 5.0f * 0.8f) + (float)value.sideIndices.length * -2.6f;
            String name = value.name() + " " + prefix;
            result.add(new Modifier(tier, name, new GlobalHeroes(new AffectSides(value, new ReplaceWith(ESB.dmgSelfCantrip.val(1))))));
        }
        return result;
    }

    public static List<Modifier> makeMortality() {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        int index = 0;
        int max = 12;
        for (int i = 12; i > 0; --i) {
            float maxStr = 0.6f;
            float mortalFactor = Tann.niceTerp(i - 1, 11.0f, 0.6f, 0.4f);
            float floatTier = ModTierUtils.deadHero(0.6f - mortalFactor) * 5.0f;
            if (i <= 8) {
                floatTier *= 1.0f + 0.4f * Tann.splang(i, 8.0f, 3.0f);
            }
            if (!ModTierUtils.validForTier(floatTier, 0.3f)) continue;
            GlobalHeroes g = new GlobalHeroes(new NumberLimit(i));
            result.add(new Modifier(floatTier, ModifierUtils.makeName("Mortal", index++, g), g).rarity(Rarity.TWENTIETH));
        }
        return result;
    }

    private static List<Modifier> makeMeta() {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        result.addAll(GenUtils.cChain("Many Curses", 4, new TierMaker(){

            @Override
            public float makeTier(int index) {
                return CurseDistribution.getEachLevelAdd(-1 - index);
            }
        }, new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalLevelRequirement(new LevelRequirementEach(), new GlobalAddPhase(new PhaseGeneratorModifierPick(3, 1, -1 - i, true, ModifierPickContext.Difficulty_But_Midgame)));
            }
        }));
        result.addAll(GenUtils.cChain("First 10 Curses", 4, new TierMaker(){

            @Override
            public float makeTier(int index) {
                return CurseDistribution.getMultLevelUntilEndEnd(1, 10, -1 - index);
            }
        }, new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalLevelRequirement(new LevelRequirementRange(1, 10), new GlobalAddPhase(new PhaseGeneratorModifierPick(3, 1, -1 - i, true, ModifierPickContext.Difficulty_But_Midgame)));
            }
        }));
        result.addAll(GenUtils.cChain("Early Curses", 4, new TierMaker(){

            @Override
            public float makeTier(int index) {
                return CurseDistribution.getMultLevelUntilEndEnd(1, 4, -1 - index);
            }
        }, new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalLevelRequirement(new LevelRequirementRange(1, 4), new GlobalAddPhase(new PhaseGeneratorModifierPick(3, 1, -1 - i, true, ModifierPickContext.Difficulty_But_Midgame)));
            }
        }));
        result.addAll(GenUtils.cChain("Boss Curses", 4, new TierMaker(){

            @Override
            public float makeTier(int index) {
                return CurseDistribution.getBossLevelsAdd(-1 - index);
            }
        }, new MMS(){

            @Override
            public Global ms(int i) {
                return new GlobalLevelRequirement(new LevelRequirementBeforeBoss(), new GlobalAddPhase(new PhaseGeneratorModifierPick(3, 1, -i - 1, true, ModifierPickContext.Difficulty_But_Midgame)));
            }
        }));
        result.add(CurseLib.addCurseAfter(14, -8));
        result.add(CurseLib.addCurseAfter(19, -10));
        return result;
    }

    private static Modifier addCurseAfter(int level, int curseValue) {
        float tier = CurseDistribution.getMultLevelAndAfter(level, curseValue);
        return new Modifier(tier, "Fight " + level + " curse", new GlobalLevelRequirement(new LevelRequirementRange(level), new GlobalAddPhase(new PhaseGeneratorModifierPick(3, 1, curseValue, true, ModifierPickContext.Difficulty_But_Midgame))));
    }

    public static Actor makeChooseModifierPanel(float tier) {
        boolean bless = tier > 0.0f;
        String coltag = bless ? "[green]" : "[purple]";
        return new ModifierPanel(new Modifier(tier, bless ? "blessing" : "curse", new GlobalDescribeOnly(coltag + "choose")), false);
    }
}

