/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.mode.chooseParty;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.context.config.ContextConfig;
import com.tann.dice.gameplay.context.config.difficultyConfig.ChoosePartyConfig;
import com.tann.dice.gameplay.mode.Mode;
import com.tann.dice.gameplay.mode.chooseParty.HeroSelector;
import com.tann.dice.gameplay.mode.meta.folder.FolderType;
import com.tann.dice.gameplay.save.settings.Settings;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.ImageButton;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.listener.TannListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ChoosePartyMode
extends Mode {
    List<HeroType> types = new ArrayList<HeroType>();
    final List<HeroSelector> selectors = new ArrayList<HeroSelector>();

    public ChoosePartyMode() {
        super("Choose-Party");
    }

    @Override
    public Color getColour() {
        return Colours.yellow;
    }

    private void setupStuff() {
        this.types.clear();
        this.selectors.clear();
        for (String basic : HeroTypeUtils.BASICS) {
            this.types.add(HeroTypeUtils.byName(basic));
            HeroSelector hs = new HeroSelector();
            hs.setToggleRun(new Runnable(){

                @Override
                public void run() {
                    ChoosePartyMode.this.refreshHeroes();
                }
            });
            this.selectors.add(hs);
        }
    }

    @Override
    public String[] getDescriptionLines() {
        return new String[]{"choose a starting party", "duplicate levelups allowed"};
    }

    @Override
    protected List<Actor> getLeftOfTitleActors() {
        return Arrays.asList(this.makeRerollButton(), this.makeSelectorActor());
    }

    @Override
    public boolean skipShowTitleDesc() {
        return Main.isPortrait();
    }

    private Actor makeRerollButton() {
        ImageButton a = new ImageButton(Images.singleDie, 4);
        a.addListener(new TannListener(){

            @Override
            public boolean action(int button, int pointer, float x, float y) {
                Sounds.playSound(Sounds.clacks);
                Sounds.playSound(Sounds.clocks);
                for (HeroSelector hs : ChoosePartyMode.this.selectors) {
                    hs.setToRandomHeroType();
                }
                ChoosePartyMode.this.refreshHeroes();
                return true;
            }
        });
        return a;
    }

    private Actor makeSelectorActor() {
        int i;
        this.setupStuff();
        List<String> customs = Main.getSettings().getChoosePartyHeroes();
        if (customs != null && customs.size() == 5) {
            for (i = 0; i < 5; ++i) {
                HeroType t = HeroTypeUtils.byName(customs.get(i));
                this.types.set(i, t);
            }
        }
        for (i = 0; i < 5; ++i) {
            this.selectors.get(i).setInternal(this.types.get(i));
        }
        this.refreshHeroes();
        int gap = 3;
        Pixl selectorPix = new Pixl(3);
        for (int col = 0; col < 2; ++col) {
            Pixl colPix = new Pixl(3);
            boolean first = true;
            for (int i2 = 0; i2 < this.selectors.size(); ++i2) {
                if (i2 % 2 != col) continue;
                HeroSelector hs = this.selectors.get(i2);
                if (!first) {
                    colPix.row();
                }
                colPix.actor(hs);
                first = false;
            }
            selectorPix.actor(colPix.pix());
        }
        return selectorPix.pix();
    }

    @Override
    protected List<ContextConfig> makeAllConfigs() {
        return ChoosePartyConfig.make(this.types);
    }

    private void refreshHeroes() {
        for (int i = 0; i < 5; ++i) {
            HeroType ht = this.selectors.get((int)i).type;
            this.types.set(i, ht);
        }
        ArrayList<String> saveTypes = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            saveTypes.add(this.selectors.get((int)i).type.getSaveString());
        }
        Settings s = Main.getSettings();
        s.setChoosePartyHeroes(saveTypes);
        s.save();
    }

    @Override
    public String getSaveKey() {
        return "custom-party";
    }

    @Override
    public boolean disablePartyLayout() {
        return true;
    }

    @Override
    public FolderType getFolderType() {
        return FolderType.cool;
    }
}

