/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.mode;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.tann.dice.Main;
import com.tann.dice.gameplay.battleTest.Zone;
import com.tann.dice.gameplay.context.DungeonContext;
import com.tann.dice.gameplay.context.config.ContextConfig;
import com.tann.dice.gameplay.leaderboard.Leaderboard;
import com.tann.dice.gameplay.leaderboard.LeaderboardBlob;
import com.tann.dice.gameplay.mode.chooseParty.ChoosePartyMode;
import com.tann.dice.gameplay.mode.creative.WishMode;
import com.tann.dice.gameplay.mode.creative.custom.CustomMode;
import com.tann.dice.gameplay.mode.creative.pastey.PasteMode;
import com.tann.dice.gameplay.mode.cursey.BlursedMode;
import com.tann.dice.gameplay.mode.cursey.BlurtraMode;
import com.tann.dice.gameplay.mode.cursey.CurseMode;
import com.tann.dice.gameplay.mode.cursey.CurseModeHyper;
import com.tann.dice.gameplay.mode.cursey.CurseModeUltra;
import com.tann.dice.gameplay.mode.debuggy.BalanceMode;
import com.tann.dice.gameplay.mode.debuggy.CustomFightMode;
import com.tann.dice.gameplay.mode.debuggy.DebugMode;
import com.tann.dice.gameplay.mode.debuggy.EmptyMode;
import com.tann.dice.gameplay.mode.debuggy.PickMode;
import com.tann.dice.gameplay.mode.debuggy.SavesMode;
import com.tann.dice.gameplay.mode.general.AlternateHeroesMode;
import com.tann.dice.gameplay.mode.general.ClassicMode;
import com.tann.dice.gameplay.mode.general.DemoMode;
import com.tann.dice.gameplay.mode.general.DreamMode;
import com.tann.dice.gameplay.mode.general.GenerateHeroesMode;
import com.tann.dice.gameplay.mode.general.InstantMode;
import com.tann.dice.gameplay.mode.general.LootMode;
import com.tann.dice.gameplay.mode.general.RaidMode;
import com.tann.dice.gameplay.mode.general.ShortcutMode;
import com.tann.dice.gameplay.mode.general.nightmare.NightmareMode;
import com.tann.dice.gameplay.mode.meta.folder.BasicFolderMode;
import com.tann.dice.gameplay.mode.meta.folder.FolderType;
import com.tann.dice.gameplay.mode.meta.folder.RootFolder;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.phase.endPhase.statsPanel.GameEndStatsPanel;
import com.tann.dice.gameplay.progress.chievo.AchLib;
import com.tann.dice.gameplay.progress.chievo.Achievement;
import com.tann.dice.gameplay.progress.chievo.unlock.UnUtil;
import com.tann.dice.gameplay.progress.chievo.unlock.Unlockable;
import com.tann.dice.gameplay.save.RunHistory;
import com.tann.dice.gameplay.save.SaveState;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.screens.dungeon.panels.book.page.ledgerPage.AchievementIconView;
import com.tann.dice.screens.titleScreen.GameStart;
import com.tann.dice.statics.ImageUtils;
import com.tann.dice.statics.Images;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Colours;
import com.tann.dice.util.ImageActor;
import com.tann.dice.util.LockOverlay;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.listener.TannListener;
import com.tann.dice.util.saves.Prefs;
import com.tann.dice.util.tp.TP;
import com.tann.dice.util.ui.TextWriter;
import com.tann.dice.util.ui.standardButton.StandardButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class Mode
implements Unlockable {
    private static List<Mode> allModes = new ArrayList<Mode>();
    private static List<Mode> playableModes = new ArrayList<Mode>();
    public static ClassicMode CLASSIC;
    public static DebugMode DEBUG;
    public static CurseMode CURSE;
    public static BlursedMode BLURSED;
    public static BlurtraMode BLURTRA;
    public static CurseModeUltra CURSED_ULTRA;
    public static ChoosePartyMode CHOOSE_PARTY;
    public static InstantMode INSTANT;
    public static ShortcutMode SHORTCUT;
    public static DemoMode DEMO;
    public static CurseModeHyper CURSE_HYPER;
    public static LootMode LOOT;
    public static GenerateHeroesMode GENERATE_HEROES;
    public static AlternateHeroesMode ALTERNATE_HEROES;
    public static RaidMode RAID;
    public static PasteMode PASTE;
    public static BalanceMode BALANCE;
    public static PickMode PICK;
    public static CustomFightMode CUSTOM_FIGHT;
    public static CustomMode CUSTOM;
    public static DreamMode DREAM;
    public static RootFolder ROOT;
    public static NightmareMode NIGHTMARE;
    public static WishMode WISH;
    public static SavesMode SAVES;
    public static EmptyMode EMPTY;
    protected final String name;
    private List<ContextConfig> configs;

    protected Mode(String name) {
        this.name = name;
    }

    public static void init() {
        allModes = new ArrayList<Mode>();
        playableModes = new ArrayList<Mode>();
        DEMO = new DemoMode();
        Mode.addMode(DEMO);
        CLASSIC = new ClassicMode();
        Mode.addMode(CLASSIC);
        SHORTCUT = new ShortcutMode();
        Mode.addMode(SHORTCUT);
        CHOOSE_PARTY = new ChoosePartyMode();
        Mode.addMode(CHOOSE_PARTY);
        LOOT = new LootMode();
        Mode.addMode(LOOT);
        RAID = new RaidMode();
        Mode.addMode(RAID);
        GENERATE_HEROES = new GenerateHeroesMode();
        Mode.addMode(GENERATE_HEROES);
        ALTERNATE_HEROES = new AlternateHeroesMode();
        Mode.addMode(ALTERNATE_HEROES);
        NIGHTMARE = new NightmareMode();
        Mode.addMode(NIGHTMARE);
        DREAM = new DreamMode();
        Mode.addMode(DREAM);
        PASTE = new PasteMode();
        Mode.addMode(PASTE);
        CUSTOM = new CustomMode();
        Mode.addMode(CUSTOM);
        CURSE = new CurseMode();
        Mode.addMode(CURSE);
        BLURSED = new BlursedMode();
        Mode.addMode(BLURSED);
        CURSE_HYPER = new CurseModeHyper();
        Mode.addMode(CURSE_HYPER);
        CURSED_ULTRA = new CurseModeUltra();
        Mode.addMode(CURSED_ULTRA);
        BLURTRA = new BlurtraMode();
        Mode.addMode(BLURTRA);
        INSTANT = new InstantMode();
        Mode.addMode(INSTANT);
        BALANCE = new BalanceMode();
        Mode.addMode(BALANCE);
        PICK = new PickMode();
        Mode.addMode(PICK);
        CUSTOM_FIGHT = new CustomFightMode();
        Mode.addMode(CUSTOM_FIGHT);
        WISH = new WishMode();
        Mode.addMode(WISH);
        SAVES = new SavesMode();
        Mode.addMode(SAVES);
        EMPTY = new EmptyMode();
        Mode.addMode(EMPTY);
        DEBUG = new DebugMode();
        Mode.addMode(DEBUG);
        for (Mode mode : BasicFolderMode.makeAll()) {
            Mode.addMode(mode);
        }
        ROOT = new RootFolder();
        Mode.addMode(ROOT);
    }

    public Color getColour() {
        return Colours.pink;
    }

    private static void addMode(Mode mode) {
        allModes.add(mode);
        if (mode.isPlayable()) {
            playableModes.add(mode);
        }
    }

    public static List<Mode> getAllModes() {
        return allModes;
    }

    protected static List<Mode> getAllModesOmni() {
        ArrayList<Mode> pm = new ArrayList<Mode>(Mode.getPlayableModes());
        for (int i = pm.size() - 1; i >= 0; --i) {
            if (((Mode)pm.get(i)).getFolderType() == null && !((Mode)pm.get(i)).isDebug()) continue;
            pm.remove(i);
        }
        return pm;
    }

    public static List<Mode> getPlayableModes() {
        return playableModes;
    }

    public static List<Mode> getAllSaveBearingModes() {
        ArrayList<Mode> tmp = new ArrayList<Mode>();
        for (Mode m : allModes) {
            if (m.getSaveKey() == null) continue;
            tmp.add(m);
        }
        return tmp;
    }

    public static List<ContextConfig> getAllSaveBearingConfigs() {
        ArrayList<ContextConfig> contextConfigs = new ArrayList<ContextConfig>();
        for (Mode m : Mode.getAllSaveBearingModes()) {
            contextConfigs.addAll(m.getConfigs());
        }
        return contextConfigs;
    }

    public Actor makeStartGameDisplay() {
        ArrayList<String> descList = new ArrayList<String>();
        String[] lines = this.getDescriptionLines();
        if (lines != null) {
            descList.addAll(Arrays.asList(lines));
        }
        if (this.skipStats()) {
            descList.add("no stats/run history");
        }
        if (this.getConfigs().size() > 0) {
            ContextConfig cc = this.configs.get(0);
            for (Modifier m : cc.getStartingModifiers()) {
                for (Global gt : m.getGlobals()) {
                    String desc = gt.describeForMode();
                    if (desc == null) continue;
                    descList.add(desc);
                }
            }
            for (Global gt : cc.getModeGlobals()) {
                String desc = gt.describeForMode();
                if (desc == null) continue;
                descList.add(desc);
            }
        }
        if (descList.size() == 0) {
            descList.add("no description?");
        }
        return this.makeStandardDisplay(this.getColour(), this.name, descList);
    }

    public List<ContextConfig> getConfigs() {
        if (this.configs == null) {
            this.configs = this.makeAllConfigs();
        }
        return this.configs;
    }

    protected List<Actor> getLeftOfTitleActors() {
        return new ArrayList<Actor>();
    }

    public String[] getDescriptionLines() {
        return new String[0];
    }

    protected abstract List<ContextConfig> makeAllConfigs();

    public StandardButton makeModeSelectButton() {
        boolean locked = UnUtil.isLocked(this);
        String text = locked ? "      " : this.getTextButtonName();
        StandardButton tb = new StandardButton(text);
        if (locked) {
            new LockOverlay(tb, false);
        }
        return tb;
    }

    public abstract String getSaveKey();

    public boolean hasSave() {
        return Prefs.getString(this.getSaveKey(), null) != null;
    }

    public boolean isPlayable() {
        return this.getFolderType() != FolderType.debug && this.getFolderType() != FolderType.unfinished;
    }

    public final Actor makeStartGameCard() {
        return this.makeStartGameCard(this.getConfigs());
    }

    public Actor makeStartGameCard(List<ContextConfig> all) {
        ContextConfig first = all.get(0);
        ArrayList<ContextConfig> unlocked = new ArrayList<ContextConfig>(all);
        for (int i = unlocked.size() - 1; i >= 0; --i) {
            if (!((ContextConfig)unlocked.get(i)).isLocked()) continue;
            unlocked.remove(i);
        }
        StandardButton example = first.makeStartButton(true);
        boolean big = example != null && (float)Main.width * 0.87f > (float)unlocked.size() * example.getWidth();
        int gap = (int)((float)(big ? 6 : 4) * (Main.isPortrait() ? 1.5f : 1.0f));
        Pixl main = new Pixl(gap);
        main.row(0);
        for (int i = 0; i < unlocked.size(); ++i) {
            if (i == 10) {
                main.row();
            }
            final ContextConfig cc = (ContextConfig)unlocked.get(i);
            Pixl p = new Pixl(0);
            if (!cc.skipStats()) {
                p.actor(this.makeWinsActor(cc));
            }
            p.row(4);
            StandardButton button = cc.makeStartButton(big);
            p.actor(button);
            button.setRunnable(new Runnable(){

                @Override
                public void run() {
                    Mode.this.onStartButtonPress(cc);
                }
            });
            if (Main.isPortrait()) {
                main.actor(p.pix(), (float)Main.width * 0.75f);
                continue;
            }
            main.actor(p.pix());
        }
        Group loadButton = SaveState.getLoadButton(first.getGeneralSaveKey());
        if (loadButton != null) {
            main.row().actor(loadButton);
        }
        return main.pix();
    }

    protected void onStartButtonPress(ContextConfig cc) {
        GameStart.startWithPLTChoice(cc, null);
    }

    public Actor makeWinsActor(final ContextConfig config) {
        Actor a;
        int wins = config.getWins();
        TextureRegion wreath = Images.wreath;
        if (wins == 0) {
            a = new Actor();
            a.setSize(wreath.getRegionWidth(), wreath.getRegionHeight());
        } else {
            Group g = Tann.makeGroup();
            ImageActor ia = new ImageActor(wreath);
            g.setSize(ia.getWidth(), ia.getHeight());
            g.addActor(ia);
            if (wins > 1) {
                TextWriter tw = new TextWriter("[yellow]" + wins);
                g.addActor(tw);
                tw.setPosition((int)(g.getWidth() / 2.0f - tw.getWidth() / 2.0f), (int)(g.getHeight() / 2.0f - tw.getHeight() / 2.0f));
            }
            a = g;
        }
        if (config.getWins() > 0) {
            a.addListener(new TannListener(){

                @Override
                public boolean info(int button, float x, float y) {
                    Object a;
                    int losses;
                    int wins = config.getWins();
                    if (wins + (losses = config.getLosses()) == 0) {
                        return true;
                    }
                    Pixl p = new Pixl(2, 3).border(Colours.yellow);
                    p.text(config.getEndTitle()).row().text(Mode.getWinsString(wins, losses)).row();
                    int currentStreak = config.getStreak(false);
                    int bestStreak = config.getStreak(true);
                    if (bestStreak > 0) {
                        p.text("[purple]Streak: " + currentStreak + " (best " + bestStreak + ")");
                    }
                    if ((a = Mode.this.getHistoryButtonIfRelevant(config)) != null) {
                        p.row().actor((Actor)a);
                    }
                    for (Leaderboard leaderboard : LeaderboardBlob.all) {
                        boolean valid;
                        if (UnUtil.isLocked(leaderboard) || !(valid = leaderboard.validForModeInfo(config))) continue;
                        p.actor(leaderboard.makeInfoActor(TextWriter.getTag(leaderboard.getCol()) + "Leaderboard"));
                    }
                    Group g = p.pix(8);
                    Main.getCurrentScreen().pushAndCenter(g);
                    return true;
                }
            });
        }
        return a;
    }

    public static String getWinsString(int wins, int losses) {
        String colTag = wins > 0 ? "[green]" : "[text]";
        float ratio = (float)wins / (float)(wins + losses);
        String ratioString = Math.round(ratio * 100.0f) + "%";
        return colTag + "Wins: " + wins + "/" + (losses + wins) + " (" + ratioString + ")";
    }

    private Actor getHistoryButtonIfRelevant(List<ContextConfig> configs) {
        final ArrayList<RunHistory> runs = new ArrayList<RunHistory>();
        for (ContextConfig config : configs) {
            runs.addAll(Main.self().masterStats.getRunHistoryStore().getRuns(config));
        }
        if (runs.size() > 0) {
            Collections.sort(runs, new Comparator<RunHistory>(){

                @Override
                public int compare(RunHistory o1, RunHistory o2) {
                    return (int)(o1.getDate() - o2.getDate());
                }
            });
            StandardButton tb = new StandardButton("History");
            tb.setRunnable(new Runnable(){

                @Override
                public void run() {
                    Group runsActor = new Pixl(3, 3).border(Colours.grey).actor(RunHistory.makeGroup(runs)).pix();
                    ScrollPane sp = Tann.makeScrollpane(runsActor);
                    sp.setSize(runsActor.getWidth() + 6.0f, (int)Math.min(runsActor.getHeight(), (float)Main.height * 0.9f));
                    Main.getCurrentScreen().pushAndCenter(sp);
                }
            });
            return tb;
        }
        return null;
    }

    private Actor getHistoryButtonIfRelevant(ContextConfig config) {
        return this.getHistoryButtonIfRelevant(Arrays.asList(config));
    }

    public List<Actor> getEndInfo(DungeonContext context, int previousFurthestReached, boolean victory) {
        ArrayList<Actor> result = new ArrayList<Actor>();
        String reached = context.getLevelProgressString(true);
        if (reached != null) {
            result.add(new TextWriter(reached));
        }
        if (victory && previousFurthestReached == context.getCurrentLevelNumber()) {
            int currentStreak = context.getContextConfig().getStreak(false);
            int bestStreak = context.getContextConfig().getStreak(true);
            result.add(new TextWriter("[text]Current streak: " + currentStreak));
            result.add(new TextWriter("[text]Best streak: " + bestStreak));
        } else if (previousFurthestReached > 1 && previousFurthestReached < 20) {
            result.add(new TextWriter("[text]Previous best: " + previousFurthestReached));
            if (previousFurthestReached < context.getCurrentLevelNumber()) {
                result.add(new TextWriter("[yellow](new record!)"));
            }
        }
        for (Leaderboard l : LeaderboardBlob.all) {
            if (UnUtil.isLocked(l) || !l.validForEndCard(context.getContextConfig()) || !l.canSubmitBetterScore()) continue;
            result.add(l.getSubmitHighscoreButton());
            break;
        }
        return result;
    }

    public List<Actor> getEndOptions(final DungeonContext dungeonContext, boolean victory) {
        ArrayList<Actor> result = new ArrayList<Actor>();
        StandardButton quit = new StandardButton(dungeonContext.getVictoryString());
        quit.setRunnable(new Runnable(){

            @Override
            public void run() {
                Sounds.playSound(Sounds.pip);
                ContextConfig cc = dungeonContext.getContextConfig();
                cc.clearSave();
                cc.quitAction();
            }
        });
        result.add(quit);
        if (!dungeonContext.getContextConfig().skipStats()) {
            result.add(GameEndStatsPanel.makeStatsButton(dungeonContext, victory));
        }
        return result;
    }

    public static List<TP<Zone, Integer>> getStandardLevelTypes() {
        return Arrays.asList(new TP<Zone, Integer>(Zone.Forest, 4), new TP<Zone, Integer>(Zone.Dungeon, 4), new TP<Zone, Integer>(Zone.Catacombs, 4), new TP<Zone, Integer>(Zone.Lair, 4), new TP<Zone, Integer>(Zone.Pit, 4));
    }

    public static int[] getStandardBossLevels() {
        return new int[]{4, 8, 12, 16, 20};
    }

    @Override
    public Actor makeUnlockActor(boolean big) {
        if (Main.demo) {
            return new Pixl(0, 3).text(this.getTextButtonName()).row(3).text("[grey](full game only)").pix();
        }
        return new Pixl(0, 3).text(this.getTextButtonName()).pix();
    }

    @Override
    public TextureRegion getAchievementIcon() {
        return null;
    }

    @Override
    public String getAchievementIconString() {
        return TextWriter.getTag(this.getColour()) + "M";
    }

    public String getName() {
        return this.name;
    }

    public String getTextButtonName() {
        return TextWriter.getTag(this.getColour()) + this.getName() + "[cu]";
    }

    public void showModeInfo() {
        if (this.skipMetaInfoOnNameClick()) {
            return;
        }
        Sounds.playSound(Sounds.pip);
        Actor a = this.makeMoreInfoActor();
        Main.getCurrentScreen().push(a, 0.8f);
        Tann.center(a);
    }

    private Actor makeMoreInfoActor() {
        Object lp;
        int WIDTH = (int)Math.min(130.0f, (float)Main.width * 0.9f);
        List<ContextConfig> cc = this.getConfigs();
        Pixl p = new Pixl(5, 5).border(this.getColour());
        p.text(this.getTextButtonName() + " [text]mode").row();
        String extraDesc = this.getExtraDescription();
        if (extraDesc != null) {
            p.text(extraDesc, WIDTH).row();
        }
        if (!this.skipStats()) {
            int wins = 0;
            int losses = 0;
            for (ContextConfig config : cc) {
                wins += config.getWins();
                losses += config.getLosses();
            }
            p.text(Mode.getWinsString(wins, losses)).row();
            Actor a = this.getHistoryButtonIfRelevant(cc);
            if (a != null) {
                p.actor(a).row();
            }
        }
        ArrayList<Actor> leaderboardActors = new ArrayList<Actor>();
        for (Leaderboard leaderboard : LeaderboardBlob.all) {
            if (UnUtil.isLocked(leaderboard)) continue;
            boolean valid = false;
            for (ContextConfig contextConfig : cc) {
                valid |= leaderboard.validForModeInfo(contextConfig);
            }
            if (!valid) continue;
            leaderboardActors.add(leaderboard.makeInfoActor());
        }
        if (!leaderboardActors.isEmpty()) {
            lp = new Pixl(3, 4).border(Colours.blue).text("[blue]Leaderboards").row();
            for (Actor leaderboardActor : leaderboardActors) {
                ((Pixl)lp).actor(leaderboardActor, WIDTH);
            }
            p.actor(((Pixl)lp).pix()).row();
        }
        ArrayList<Achievement> specific = new ArrayList<Achievement>();
        for (Achievement achievement : AchLib.getAll()) {
            if (!achievement.isChallenge() || !achievement.isCompletable() || !achievement.forSpecificMode(this)) continue;
            specific.add(achievement);
        }
        Collections.sort(specific, new Comparator<Achievement>(){

            @Override
            public int compare(Achievement o1, Achievement o2) {
                return (int)Math.signum(o1.getDifficulty() - o2.getDifficulty());
            }
        });
        if (!specific.isEmpty()) {
            lp = new Pixl(3, 2).border(Colours.orange).text("[orange]challenges").row();
            for (Achievement achievement : specific) {
                ((Pixl)lp).actor(new AchievementIconView(achievement), WIDTH);
            }
            p.actor(((Pixl)lp).pix());
        }
        return p.pix();
    }

    protected String getExtraDescription() {
        return null;
    }

    protected Actor makeStandardDisplay(Color color, String title, List<String> descriptionsLines) {
        String tag = TextWriter.getTag(color);
        String prefix = descriptionsLines.size() == 1 ? "" : "- ";
        Pixl descPix = new Pixl(2, 3).border(Colours.dark, color, 1);
        descPix.multiText(Tann.prefixAll(descriptionsLines, "[text]" + prefix), 140);
        for (Actor extraDescActor : this.extraDescActors()) {
            descPix.row().actor(extraDescActor);
        }
        Group tw = descPix.pix(8);
        tw.setTouchable(Touchable.childrenOnly);
        Pixl topPix = new Pixl(10);
        float mw = (float)Main.width * 0.9f;
        if (!Main.isPortrait()) {
            for (Actor a : this.getLeftOfTitleActors()) {
                topPix.actor(a, mw);
            }
        }
        if (!Main.demo) {
            TextWriter modeNameActor = new TextWriter("[b]" + tag + title, 5000, color, 4);
            Pixl pp = new Pixl().actor(modeNameActor);
            if (!this.skipShowTitleDesc()) {
                tw.addListener(new TannListener(){

                    @Override
                    public boolean action(int button, int pointer, float x, float y) {
                        Mode.this.showModeInfo();
                        return true;
                    }
                });
                pp.row(-1).actor(tw);
            }
            Group titleActor = pp.pix();
            titleActor.setTouchable(Touchable.childrenOnly);
            topPix.actor(titleActor);
            modeNameActor.addListener(new TannListener(){

                @Override
                public boolean action(int button, int pointer, float x, float y) {
                    Mode.this.showModeInfo();
                    return true;
                }
            });
        }
        if (Main.isPortrait()) {
            topPix.row();
            for (Actor a : this.getLeftOfTitleActors()) {
                topPix.actor(a, mw);
            }
        }
        Group topActor = topPix.pix();
        topActor.setTouchable(Touchable.childrenOnly);
        Pixl p = new Pixl();
        p.actor(topActor);
        Actor a = this.makeStartGameCard();
        if (a != null) {
            a.setTouchable(Touchable.childrenOnly);
            int aWidth = (int)a.getWidth();
            int aHeight = (int)a.getHeight();
            int maxWidth = (int)((float)Main.width * 0.98f);
            if (aWidth > maxWidth) {
                a = Tann.makeScrollpane(a);
                a.setSize(maxWidth, aHeight + 6);
            }
            p.row(5).actor(a);
        }
        Group result = p.pix();
        result.setTouchable(Touchable.childrenOnly);
        return result;
    }

    protected List<Actor> extraDescActors() {
        return new ArrayList<Actor>();
    }

    public boolean skipShowTitleDesc() {
        return false;
    }

    public boolean displayPopup() {
        return true;
    }

    public static Mode getModeFromString(String name) {
        for (Mode m : allModes) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public static TextureRegion getBackgroundFromFolderType(FolderType ft) {
        if (ft == null) {
            return ImageUtils.loadExtBig("ui/titleTemple");
        }
        switch (ft) {
            case creative: {
                return ImageUtils.loadExtBig("ui/titleChurch");
            }
            case cursed: {
                return ImageUtils.loadExtBig("ui/titleLighthouse");
            }
            case debug: 
            case crappy: 
            case unfinished: {
                return ImageUtils.loadExtBig("ui/titleOld");
            }
        }
        return ImageUtils.loadExtBig("ui/titleTemple");
    }

    public TextureRegion getBackground() {
        return Mode.getBackgroundFromFolderType(this.getFolderType());
    }

    public boolean basicTitleBackground() {
        return false;
    }

    public boolean showMinimap() {
        return true;
    }

    public boolean skipStats() {
        return false;
    }

    public boolean skipFromMainList() {
        if (this.isDebug()) {
            return true;
        }
        if (!this.isPlayable()) {
            return true;
        }
        return this.getFolderType() != null;
    }

    public boolean isDebug() {
        return false;
    }

    public Mode getParent() {
        FolderType ft = this.getFolderType();
        if (ft != null) {
            return BasicFolderMode.get(ft);
        }
        RootFolder m = ROOT;
        if (UnUtil.isLocked(m)) {
            return null;
        }
        return m;
    }

    public boolean skipUnlockNotify() {
        return false;
    }

    public FolderType getFolderType() {
        return null;
    }

    public long getBannedCollisionBits() {
        return 0L;
    }

    public boolean disablePartyLayout() {
        return false;
    }

    public boolean skipShowBoss() {
        return false;
    }

    public boolean skipMetaInfoOnNameClick() {
        if (!Main.getSettings().hasAttemptedLevel()) {
            return true;
        }
        return this.getFolderType() == FolderType.creative;
    }

    public String getRawSave() {
        if (!this.hasSave()) {
            return null;
        }
        String sk = this.getSaveKey();
        if (sk == null) {
            return null;
        }
        return Prefs.getString(sk, null);
    }
}

