/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.level;

import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.EntTypeUtils;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.content.gen.pipe.entity.monster.PipeMonster;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Tann;
import com.tann.dice.util.ui.TextWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Level {
    private final List<MonsterType> monsterList;
    private final Float difficultyDelta;

    public Level(MonsterType ... monsterTypes) {
        this((Float)null, monsterTypes);
    }

    public Level(Float diffD, MonsterType ... monsterTypes) {
        this(diffD, new ArrayList<MonsterType>(Arrays.asList(monsterTypes)));
    }

    public Level(Float diffD, List<MonsterType> monsterTypes) {
        if (monsterTypes == null) {
            monsterTypes = new ArrayList<MonsterType>(Arrays.asList(PipeMonster.getMissingno()));
        }
        this.monsterList = monsterTypes;
        this.difficultyDelta = diffD;
    }

    public static Level errorLevel(int levelNumber) {
        if (levelNumber < 6) {
            return new Level(PipeMonster.getMissingno());
        }
        if (levelNumber < 12) {
            return new Level(PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno());
        }
        if (levelNumber < 16) {
            return new Level(PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno());
        }
        if (levelNumber <= 20) {
            return new Level(PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno());
        }
        return new Level(PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno(), PipeMonster.getMissingno());
    }

    public List<MonsterType> getMonsterList() {
        return this.monsterList;
    }

    public static List<Level> generateRandomLevels() {
        ArrayList<Level> results = new ArrayList<Level>();
        results.add(new Level(MonsterTypeLib.randomWithRarity(), MonsterTypeLib.randomWithRarity(), MonsterTypeLib.randomWithRarity()));
        List<MonsterType> copy = MonsterTypeLib.getMasterCopy();
        for (int i = 0; i < 10; ++i) {
            results.add(new Level(Tann.pickNRandomElements(copy, (int)(Math.random() * 3.0 + 1.0)).toArray(new MonsterType[0])));
        }
        return results;
    }

    public String toString() {
        return "Level: " + this.monsterList;
    }

    public Float getDiffD() {
        return this.difficultyDelta;
    }

    public String diffDeltaString() {
        return Level.diffDeltaString(this.getDiffD());
    }

    public static String diffDeltaString(Float difficultyDelta) {
        if (difficultyDelta == null) {
            return "unknown";
        }
        return TextWriter.getTag(difficultyDelta.floatValue() > 0.0f ? Colours.red : Colours.green) + Tann.floatFormat(difficultyDelta.floatValue()) + "[cu]";
    }

    public boolean hasMissingno() {
        return EntTypeUtils.anyMissingno(this.monsterList);
    }
}

