/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.leaderboard;

import com.tann.dice.Main;
import com.tann.dice.gameplay.battleTest.Difficulty;
import com.tann.dice.gameplay.context.config.ContextConfig;
import com.tann.dice.gameplay.leaderboard.Leaderboard;
import com.tann.dice.gameplay.mode.Mode;
import com.tann.dice.gameplay.progress.MasterStats;
import com.tann.dice.gameplay.progress.chievo.unlock.UnUtil;
import com.tann.dice.gameplay.progress.stats.stat.Stat;
import com.tann.dice.gameplay.progress.stats.stat.endOfRun.SpeedrunStat;
import com.tann.dice.util.Tann;

public class SpeedrunLeaderboard
extends Leaderboard {
    final Mode mode;

    public SpeedrunLeaderboard(Mode mode) {
        super("[yellow]Speedrun", mode.getTextButtonName() + " " + Difficulty.Normal.getColourTaggedName(), mode.getColour(), SpeedrunLeaderboard.makeUrl(mode), "time", 3600, false);
        this.mode = mode;
    }

    @Override
    public boolean isKeepHighest() {
        return false;
    }

    private static String makeUrl(Mode mode) {
        return "speedrun_" + mode.getName().toLowerCase();
    }

    @Override
    public boolean internalValid(Mode m, Difficulty d) {
        return m == this.mode && d == Difficulty.Normal;
    }

    @Override
    public String getScoreString(int value) {
        return Tann.parseSeconds(value);
    }

    @Override
    public int getScore() {
        MasterStats ms = Main.self().masterStats;
        ContextConfig cc = this.mode.getConfigs().get(Difficulty.Normal.ordinal());
        Stat ss = ms.getStat(SpeedrunStat.getName(cc));
        if (ss == null) {
            return 69;
        }
        return ss.getValue();
    }

    @Override
    public boolean isUnavailable() {
        return UnUtil.isLocked(this.mode);
    }

    @Override
    public String getSuperName() {
        return this.mode.getTextButtonName();
    }
}

