/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.mod.pool;

import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNPart;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.pos.PRNPref;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.content.item.ItemLib;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.trigger.global.pool.item.GlobalClearPoolItem;
import com.tann.dice.gameplay.trigger.global.pool.item.GlobalExtraItemPool;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PipeModItemPool
extends PipeRegexNamed<Modifier> {
    static final PRNPart PREF = new PRNPref("itempool");

    public PipeModItemPool() {
        super(PREF, ITEM_MULTI);
    }

    @Override
    protected Modifier internalMake(String[] groups) {
        String itemStrings = groups[0];
        if (PipeModItemPool.bad(itemStrings)) {
            return null;
        }
        String[] sep = itemStrings.split("\\+", -1);
        if (PipeModItemPool.bad(sep)) {
            return null;
        }
        ArrayList<Item> types = new ArrayList<Item>();
        for (int i = 0; i < sep.length; ++i) {
            types.add(ItemLib.byName(sep[i]));
        }
        return this.create(types);
    }

    private Modifier create(List<Item> types) {
        ArrayList<String> heroNames = new ArrayList<String>();
        for (int i = 0; i < types.size(); ++i) {
            Item ht = types.get(i);
            if (ht.isMissingno()) {
                return null;
            }
            heroNames.add(ht.getName());
        }
        String name = PREF + Tann.commaList(heroNames, "+", "+");
        return new Modifier(name, new GlobalClearPoolItem(), new GlobalExtraItemPool(types));
    }

    @Override
    public Modifier example() {
        return this.create(Arrays.asList(ItemLib.byName("leather vest"), ItemLib.byName("x2.leather vest"), ItemLib.byName("x3.leather vest")));
    }
}

