/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.mod.pool;

import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeLib;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNPart;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.pos.PRNPref;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.trigger.global.pool.hero.GlobalClearPoolHero;
import com.tann.dice.gameplay.trigger.global.pool.hero.GlobalExtraLevelupOptions;
import com.tann.dice.util.Tann;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PipeModHeroPool
extends PipeRegexNamed<Modifier> {
    static final PRNPart PREF = new PRNPref("heropool");

    public PipeModHeroPool() {
        super(PREF, HERO_MULTI);
    }

    @Override
    protected Modifier internalMake(String[] groups) {
        String heroStrings = groups[0];
        if (PipeModHeroPool.bad(heroStrings)) {
            return null;
        }
        String[] sep = heroStrings.split("\\+", -1);
        if (PipeModHeroPool.bad(sep)) {
            return null;
        }
        ArrayList<HeroType> types = new ArrayList<HeroType>();
        for (int i = 0; i < sep.length; ++i) {
            types.add(HeroTypeLib.byName(sep[i]));
        }
        return this.create(types);
    }

    private Modifier create(List<HeroType> types) {
        ArrayList<String> heroNames = new ArrayList<String>();
        for (int i = 0; i < types.size(); ++i) {
            HeroType ht = types.get(i);
            if (ht.isMissingno()) {
                return null;
            }
            heroNames.add(ht.getName());
        }
        String name = PREF + Tann.commaList(heroNames, "+", "+");
        return new Modifier(name, new GlobalClearPoolHero(), new GlobalExtraLevelupOptions(types));
    }

    @Override
    public Modifier example() {
        return this.create(Arrays.asList(HeroTypeLib.byName("rogue.col.r.n.Rouge"), HeroTypeLib.byName("gambler")));
    }
}

