/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.mod.level;

import com.tann.dice.gameplay.content.gen.pipe.mod.level.PipeModLevelRangeRegex;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.util.Tann;

public class PipeModLevelRegex
extends PipeRegexNamed<Modifier> {
    public PipeModLevelRegex() {
        super(LEVEL, PipeModLevelRegex.prnS("\\."), MOD);
    }

    @Override
    public Modifier example() {
        for (int i = 0; i < 50; ++i) {
            Modifier m = PipeModLevelRegex.make(Tann.randomInt(20) + 1, ModifierLib.random());
            if (m == null) continue;
            return m;
        }
        return ModifierLib.getMissingno();
    }

    public static Modifier make(int level, Modifier original) {
        return PipeModLevelRangeRegex.make(level, level, original);
    }

    public static boolean validateLevel(int level) {
        return level >= 1 && level <= 20;
    }

    @Override
    protected Modifier internalMake(String[] groups) {
        String level = groups[0];
        String mod = groups[1];
        Modifier original = ModifierLib.byName(mod);
        if (!Tann.isInt(level) || original.isMissingno()) {
            return null;
        }
        return PipeModLevelRegex.make(Integer.parseInt(level), original);
    }
}

