/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.mod.level;

import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.content.gen.pipe.mod.level.PipeModLevelRegex;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.modifier.generation.CurseDistribution;
import com.tann.dice.gameplay.trigger.Collision;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.gameplay.trigger.global.level.GlobalAddMonster;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.GlobalLevelRequirement;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.LevelRequirement;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.LevelRequirementFirst;
import com.tann.dice.gameplay.trigger.global.scaffolding.levelRequirement.LevelRequirementRange;
import com.tann.dice.util.Tann;

public class PipeModLevelRangeRegex
extends PipeRegexNamed<Modifier> {
    public PipeModLevelRangeRegex() {
        super(LEVEL, DASH, LEVEL, PipeModLevelRangeRegex.prnS("\\."), MOD);
    }

    @Override
    public Modifier example() {
        for (int i = 0; i < 50; ++i) {
            Modifier m;
            Modifier src = ModifierLib.random();
            if (Collision.collides(src.getCollisionBits(), Collision.SPECIFIC_LEVEL) || (m = PipeModLevelRangeRegex.make(Tann.randomInt(9), Tann.randomInt(9) + 10, src)) == null || src.getTier() == m.getTier() || m.getTier() == 0) continue;
            return m;
        }
        return ModifierLib.getMissingno();
    }

    public static Modifier make(int start, int end, Modifier original) {
        Global g;
        if (!PipeModLevelRangeRegex.validateModifier(original)) {
            return null;
        }
        LevelRequirement lr = PipeModLevelRangeRegex.getFrom(start, end);
        if (lr == null) {
            return null;
        }
        float tier = original.getFloatTier() * CurseDistribution.getMultLevelRange(start - 1, end);
        if (Collision.collides(original.getCollisionBits(), Collision.SPECIFIC_LEVEL)) {
            tier = 0.0f;
        }
        if ((g = original.getSingleGlobalOrNull()) == null) {
            return null;
        }
        String preTag = start + "-" + end;
        if (start == end) {
            preTag = start + "";
        }
        String name = preTag + "." + original.getName();
        Modifier result = new Modifier(tier, name, new GlobalLevelRequirement(lr, g));
        return result;
    }

    private static LevelRequirement getFrom(int start, int end) {
        if (start == 0 && end == 0) {
            return new LevelRequirementFirst();
        }
        if (!PipeModLevelRangeRegex.validateLevel(start, end)) {
            return null;
        }
        return new LevelRequirementRange(start, end);
    }

    private static boolean validateModifier(Modifier original) {
        Global first = original.getGlobals().get(0);
        if (first.allLevelsOnly()) {
            return false;
        }
        if (first instanceof GlobalLevelRequirement) {
            return false;
        }
        return !original.isOnPick();
    }

    private static boolean validateLevel(int start, int end) {
        return PipeModLevelRegex.validateLevel(start) && PipeModLevelRegex.validateLevel(end) && start <= end;
    }

    @Override
    protected Modifier internalMake(String[] groups) {
        String start = groups[0];
        String end = groups[1];
        String mod = groups[2];
        Modifier original = ModifierLib.byName(mod);
        if (!Tann.isInt(start) || !Tann.isInt(end) || original.isMissingno()) {
            return null;
        }
        return PipeModLevelRangeRegex.make(Integer.parseInt(start), Integer.parseInt(end), original);
    }

    @Override
    public boolean canGenerate(boolean wild) {
        return true;
    }

    @Override
    protected Modifier generateInternal(boolean wild) {
        if (wild) {
            return this.example();
        }
        MonsterType mt = MonsterTypeLib.randomWithRarity();
        Modifier add = GlobalAddMonster.makeGenerated(mt, false);
        if (add == null) {
            return null;
        }
        return PipeModLevelRangeRegex.make(11, 20, add);
    }

    @Override
    public float getRarity(boolean wild) {
        return 0.3f;
    }

    @Override
    public boolean skipAPI() {
        return true;
    }
}

