/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.mod;

import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.Choosable;
import com.tann.dice.gameplay.phase.levelEndPhase.rewardPhase.decisionPhase.choice.choosable.ChoosableUtils;
import com.tann.dice.gameplay.trigger.global.Global;
import java.util.ArrayList;
import java.util.List;

public class PipeModCombined
extends PipeRegexNamed<Modifier> {
    public PipeModCombined() {
        super(MOD, PipeModCombined.prnS("&"), MOD);
    }

    private static String name(Modifier a, Modifier b) {
        return a.getName() + "&" + b.getName();
    }

    @Override
    protected Modifier internalMake(String[] groups) {
        String mod1 = groups[0];
        String mod2 = groups[1];
        return this.make(ModifierLib.byName(mod1), ModifierLib.byName(mod2), true);
    }

    private Modifier make(Modifier a, Modifier b, boolean allowCollision) {
        if (a == null || a.isMissingno() || b == null || b.isMissingno()) {
            return null;
        }
        if (!allowCollision && ChoosableUtils.collides((Choosable)a, b)) {
            return null;
        }
        float at = a.getFloatTier();
        float bt = b.getFloatTier();
        float tier = this.sumTiers(at, bt);
        return new Modifier(tier, PipeModCombined.name(a, b), this.combineGlobals(a, b));
    }

    private List<Global> combineGlobals(Modifier a, Modifier b) {
        ArrayList<Global> total = new ArrayList<Global>();
        total.addAll(a.getGlobals());
        total.addAll(b.getGlobals());
        for (int i = total.size() - 1; i >= 0; --i) {
            if (!((Global)total.get(i)).metaOnly()) continue;
            total.remove(i);
        }
        return total;
    }

    private float sumTiers(float at, float bt) {
        return at + bt;
    }

    @Override
    public Modifier example() {
        Modifier m = ModifierLib.random();
        Modifier m2 = null;
        while (m2 == null || ChoosableUtils.collides((Choosable)m, m2)) {
            m2 = ModifierLib.random();
        }
        return this.make(m, m2, false);
    }

    @Override
    public boolean canGenerate(boolean wild) {
        return wild;
    }

    @Override
    protected Modifier generateInternal(boolean wild) {
        return this.example();
    }

    @Override
    public float getRarity(boolean wild) {
        return 0.5f;
    }
}

