/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.mod;

import com.tann.dice.gameplay.content.gen.pipe.MissingnoPipe;
import com.tann.dice.gameplay.content.gen.pipe.Pipe;
import com.tann.dice.gameplay.content.gen.pipe.PipeMaster;
import com.tann.dice.gameplay.content.gen.pipe.PipeUtils;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeCache;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModAddHero;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModAddMonsterMeta;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModAllItem;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModAllItemsAre;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModBecome;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModCombined;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModDelivery;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModEndTurnSpell;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModGainChoosable;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModHeroPos;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModInverted;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModPart;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModPermaItem;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModRandom;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModSetFight;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModSetParty;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModSidePos;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModSpirit;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModTurn;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModTurnEvery;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModUnpack;
import com.tann.dice.gameplay.content.gen.pipe.mod.PipeModZone;
import com.tann.dice.gameplay.content.gen.pipe.mod.keyword.PipeModAllKeyword;
import com.tann.dice.gameplay.content.gen.pipe.mod.keyword.PipeModKeywordSide;
import com.tann.dice.gameplay.content.gen.pipe.mod.level.PipeModLevelRangeRegex;
import com.tann.dice.gameplay.content.gen.pipe.mod.level.PipeModLevelRegex;
import com.tann.dice.gameplay.content.gen.pipe.mod.level.PipeModNthFight;
import com.tann.dice.gameplay.content.gen.pipe.mod.level.PipeModNthFightShifted;
import com.tann.dice.gameplay.content.gen.pipe.mod.meta.PipeModPerBoss;
import com.tann.dice.gameplay.content.gen.pipe.mod.meta.PipeModPerLevel;
import com.tann.dice.gameplay.content.gen.pipe.mod.meta.PipeModPerTurn;
import com.tann.dice.gameplay.content.gen.pipe.mod.phase.PipeModDifficulty;
import com.tann.dice.gameplay.content.gen.pipe.mod.phase.PipeModPhaseHardcoded;
import com.tann.dice.gameplay.content.gen.pipe.mod.phase.PipeModPhaseIndexed;
import com.tann.dice.gameplay.content.gen.pipe.mod.phase.PipeModPhaseModPick;
import com.tann.dice.gameplay.content.gen.pipe.mod.pool.PipeModHeroPool;
import com.tann.dice.gameplay.content.gen.pipe.mod.pool.PipeModItemPool;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaBracketed;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaDocument;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaIndexed;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaRandomTier;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaRename;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaSetTier;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.PipeMetaX;
import com.tann.dice.gameplay.content.gen.pipe.regex.meta.srcAlg.DataSourceModifier;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.modifier.Modifier;
import com.tann.dice.gameplay.modifier.ModifierLib;
import com.tann.dice.gameplay.modifier.modBal.ModTierUtils;
import com.tann.dice.gameplay.trigger.global.Global;
import com.tann.dice.gameplay.trigger.global.GlobalWishEnabled;
import com.tann.dice.gameplay.trigger.global.changeHero.GlobalChangeHeroAll;
import com.tann.dice.gameplay.trigger.global.changeHero.effects.KillHero;
import com.tann.dice.gameplay.trigger.global.linked.all.GlobalHeroes;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.AffectSides;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.SpecificSidesType;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.AddKeyword;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class PipeMod {
    public static final float GEN_FRACTION = 0.21f;
    public static List<Pipe<Modifier>> pipes;
    private static Modifier missingno;
    private static PipeCache<Modifier> pmc;
    static List<String> wildNames;
    static List<String> genNames;

    public static Modifier fetch(String modifierName) {
        return Pipe.checkPipes(pipes, modifierName, pmc);
    }

    public static Modifier fetchDesigned(String modifierName) {
        return pipes.get(0).get(modifierName);
    }

    public static void init(List<Modifier> designed) {
        DataSourceModifier ds = new DataSourceModifier();
        pipes = new ArrayList<Pipe<Modifier>>();
        pipes.add(new PipeMaster<Modifier>(designed));
        pipes.add(new PipeMaster<Modifier>(PipeMod.makeHiddenModifiers()));
        pmc = new PipeCache();
        pipes.add(pmc);
        pipes.addAll(PipeMetaDocument.makeAll(ds));
        pipes.addAll(PipeMetaRename.makeAll(ds));
        pipes.add(new PipeModAllKeyword(true));
        pipes.add(new PipeModAllKeyword(false));
        pipes.add(new PipeModKeywordSide());
        pipes.add(new PipeModHeroPos());
        pipes.add(new PipeModDifficulty());
        pipes.add(new PipeModSidePos());
        pipes.add(new PipeModPhaseHardcoded());
        pipes.add(new PipeModPhaseIndexed());
        pipes.add(new PipeModPhaseModPick());
        pipes.addAll(PipeMetaSetTier.makeAll(ds));
        pipes.addAll(PipeMetaBracketed.makeAll(ds));
        pipes.add(new PipeModLevelRangeRegex());
        pipes.add(new PipeModLevelRegex());
        pipes.add(new PipeModNthFight());
        pipes.add(new PipeModNthFightShifted());
        pipes.add(new PipeModTurn());
        pipes.add(new PipeModTurnEvery());
        pipes.add(new PipeModInverted());
        pipes.add(new PipeModPart());
        pipes.add(new PipeModZone());
        pipes.add(new PipeModDelivery());
        pipes.add(new PipeModRandom());
        pipes.add(new PipeModPerLevel());
        pipes.add(new PipeModPerBoss());
        pipes.add(new PipeModPerTurn());
        pipes.addAll(PipeMetaX.makeAll(ds));
        pipes.add(new PipeModUnpack());
        pipes.add(new PipeModEndTurnSpell());
        pipes.add(new PipeModHeroPool());
        pipes.add(new PipeModItemPool());
        pipes.add(new PipeModPermaItem());
        pipes.add(new PipeModAddMonsterMeta());
        pipes.add(new PipeModAllItem(true));
        pipes.add(new PipeModAllItem(false));
        pipes.add(new PipeModBecome());
        pipes.add(new PipeModAllItemsAre());
        pipes.add(new PipeModAddHero());
        pipes.add(new PipeModCombined());
        pipes.add(new PipeModSpirit());
        pipes.add(new PipeModSetFight());
        pipes.add(new PipeModSetParty());
        pipes.add(new PipeModGainChoosable());
        pipes.addAll(PipeMetaIndexed.makeAll(ds));
        pipes.add(new PipeMetaRandomTier<Modifier>(ds));
        missingno = PipeMod.makeMissingnoCurse();
        pipes.add(new MissingnoPipe<Modifier>(missingno));
    }

    private static List<Modifier> makeHiddenModifiers() {
        return Arrays.asList(new Modifier("Skip", new Global[0]), new Modifier("Wish", new GlobalWishEnabled()), new Modifier("Clear Party", new GlobalChangeHeroAll(new KillHero())), new Modifier(ModTierUtils.missingHero(5.0f), "Missing", new GlobalChangeHeroAll(new KillHero())));
    }

    private static Modifier makeMissingnoCurse() {
        return new Modifier(-6.0f, "BUG", new GlobalHeroes(new AffectSides(SpecificSidesType.Top, new AddKeyword(Keyword.nothing))));
    }

    public static Modifier getMissingno() {
        return missingno;
    }

    public static Modifier makeGen(boolean wild) {
        int attempts = 20;
        List<Pipe<Modifier>> gennablePipes = PipeMod.getGenPipes(wild);
        for (int i = 0; i < 20; ++i) {
            Pipe<Modifier> pm = PipeMod.randomPipeForGen(gennablePipes, wild);
            Modifier m = pm.generate(wild);
            if (m == null || m.isMissingno() || m.getTier() == 0) continue;
            PipeMod.noteGeneratedName(m.getName(), wild);
            m = PipeMod.fetch(m.getName());
            return m;
        }
        return PipeMod.getMissingno();
    }

    private static Pipe<Modifier> randomPipeForGen(List<Pipe<Modifier>> gennablePipes, boolean wild) {
        return PipeUtils.randomPipeForGen(gennablePipes, wild);
    }

    public static boolean roundtrip(Modifier m) {
        Modifier rounded = ModifierLib.byName(m.getName());
        return m.getFloatTier() == rounded.getFloatTier() && m.getFullDescription().equals(rounded.getFullDescription());
    }

    public static List<Pipe<Modifier>> getGenPipes(boolean wild) {
        return PipeUtils.getGenPipes(pipes, wild);
    }

    public static Modifier randomDesigned() {
        return pipes.get(0).example();
    }

    public static Integer getMin(Boolean blessing) {
        if (blessing == null) {
            return -20;
        }
        return blessing != false ? Integer.valueOf(1) : null;
    }

    public static Integer getMax(Boolean blessing) {
        if (blessing == null) {
            return 20;
        }
        return blessing != false ? null : Integer.valueOf(-1);
    }

    public static List<Modifier> makeGenerated(int total, Boolean blessing, boolean wild) {
        return PipeMod.makeGenerated(total, PipeMod.getMin(blessing), PipeMod.getMax(blessing), wild);
    }

    public static List<Modifier> makeGenerated(int total, Integer min, Integer max, boolean wild) {
        ArrayList<Modifier> mods = new ArrayList<Modifier>();
        block0: for (int i = 0; i < total; ++i) {
            int attempts = 10;
            for (int i1 = 0; i1 < 10; ++i1) {
                Modifier m = PipeMod.makeGen(wild);
                if (m == null || m.isMissingno() || !ModifierLib.isWithin(m, min, max)) continue;
                mods.add(m);
                continue block0;
            }
        }
        return mods;
    }

    private static void noteGeneratedName(String name, boolean wild) {
        List<String> l = wild ? wildNames : genNames;
        l.add(name);
    }

    public static Boolean getGeneratedness(String modName) {
        if (wildNames.contains(modName)) {
            return true;
        }
        if (genNames.contains(modName)) {
            return false;
        }
        return null;
    }

    static {
        wildNames = new ArrayList<String>();
        genNames = new ArrayList<String>();
    }
}

