/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.item;

import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.die.side.EntSidesLib;
import com.tann.dice.gameplay.content.ent.die.side.blob.ESB;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.gen.pipe.item.AutoItemTier;
import com.tann.dice.gameplay.content.item.ItBill;
import com.tann.dice.gameplay.content.item.Item;
import com.tann.dice.gameplay.effect.eff.keyword.Keyword;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.AffectSides;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.condition.SpecificSidesType;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.AddKeyword;
import com.tann.dice.gameplay.trigger.personal.affectSideModular.effect.ReplaceWith;
import com.tann.dice.util.Tann;
import com.tann.dice.util.tp.TP;
import java.util.Random;

public class AutoItemGeneration {
    private static TP<Integer, AffectSides> makeAs(Random r) {
        switch (r.nextInt(3)) {
            case 0: {
                return AutoItemGeneration.balancedGeneratedKeyword(r);
            }
            default: {
                return AutoItemGeneration.balancedGeneratedReplace(r);
            }
            case 2: 
        }
        return AutoItemGeneration.balancedGeneratedKeywordBonus(r);
    }

    private static TP<Integer, AffectSides> balancedGeneratedKeywordBonus(Random r) {
        EntSide added;
        float postVal;
        SpecificSidesType sst = AutoItemGeneration.getNiceSidesType(r);
        Keyword k = Tann.random(Keyword.values(), r);
        int tier = 1;
        EntSide random = EntSidesLib.random(r);
        float preVal = AutoItemTier.guessPowerReplace(tier, random, sst);
        if (preVal == (postVal = AutoItemTier.guessPowerReplace(tier, added = random.withKeyword(k), sst))) {
            return null;
        }
        int heroTierFromGuessed = (int)(postVal / 4.0f);
        float guessed = AutoItemTier.guessPowerReplace(heroTierFromGuessed, added, sst);
        return new TP<Integer, AffectSides>(Math.round(guessed), new AffectSides(sst, new ReplaceWith(added)));
    }

    private static TP<Integer, AffectSides> balancedGeneratedKeyword(Random r) {
        SpecificSidesType sst = AutoItemGeneration.getNiceSidesType(r);
        Keyword k = Tann.random(Keyword.values(), r);
        int tier = 1;
        HeroType standIn = HeroTypeUtils.defaultHero(tier);
        EntSide damage = ESB.dmgCleave.val(2);
        float preVal = damage.getApproxTotalEffectTier(standIn);
        damage = damage.withKeyword(k);
        float postVal = damage.getApproxTotalEffectTier(standIn);
        float delta = postVal - preVal;
        float sstFactor = AutoItemGeneration.getFactorKeywordAdd(sst);
        float flatMultiplier = 2.0f;
        return new TP<Integer, AffectSides>(Math.round(delta * sstFactor * flatMultiplier), new AffectSides(sst, new AddKeyword(k)));
    }

    private static float getFactorKeywordAdd(SpecificSidesType sst) {
        float result = 0.0f;
        block7: for (int side : sst.sideIndices) {
            switch (side) {
                case 2: {
                    result += 1.0f;
                    continue block7;
                }
                case 4: {
                    result += 0.85f;
                    continue block7;
                }
                case 0: 
                case 1: {
                    result += 0.7f;
                    continue block7;
                }
                case 3: {
                    result += 0.4f;
                    continue block7;
                }
                case 5: {
                    result += 0.35f;
                }
            }
        }
        return result;
    }

    public static TP<Integer, AffectSides> balancedGeneratedReplace(Random r) {
        SpecificSidesType sst = AutoItemGeneration.getNiceSidesType(r);
        EntSide es = EntSidesLib.random(r);
        float guessed = AutoItemTier.guessPowerReplace(2, es, sst);
        int heroTierFromGuessed = (int)(1.0f + guessed / 4.0f);
        guessed = AutoItemTier.guessPowerReplace(heroTierFromGuessed, es, sst);
        return new TP<Integer, AffectSides>(Math.round(guessed), new AffectSides(sst, new ReplaceWith(es)));
    }

    public static SpecificSidesType getNiceSidesType(Random r) {
        return SpecificSidesType.getNiceSidesType(r);
    }

    public static Item make(String name, Random r) {
        TP<Integer, AffectSides> as = null;
        while (as == null || (Integer)as.a <= 0) {
            as = AutoItemGeneration.makeAs(r);
        }
        return new ItBill((int)((Integer)as.a), name, "special/tier").trigger((Personal)as.b).bItem();
    }
}

