/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.gen.pipe.entity.monster;

import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.bill.MTBill;
import com.tann.dice.gameplay.content.ent.type.lib.EntTypeUtils;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.content.gen.pipe.item.PipeItemTrait;
import com.tann.dice.gameplay.content.gen.pipe.regex.PipeRegexNamed;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.PRNPart;
import com.tann.dice.gameplay.content.gen.pipe.regex.prnPart.pos.PRNMid;
import com.tann.dice.gameplay.effect.Trait;
import com.tann.dice.gameplay.trigger.global.chance.MonsterChance;
import com.tann.dice.gameplay.trigger.personal.Personal;
import com.tann.dice.gameplay.trigger.personal.util.CalcStats;
import java.util.List;

public class PipeMonsterTraited
extends PipeRegexNamed<MonsterType> {
    private static final PRNPart MID = new PRNMid("t");

    public PipeMonsterTraited() {
        super(MONSTER, MID, MONSTER);
    }

    @Override
    public MonsterType example() {
        int i = 0;
        if (i < 100) {
            return this.make(MonsterTypeLib.randomWithRarity(), MonsterTypeLib.randomWithRarity());
        }
        return this.make(MonsterTypeLib.byName("slate"), MonsterTypeLib.byName("goblin"));
    }

    @Override
    protected MonsterType internalMake(String[] groups) {
        String mName = groups[0];
        String tMName = groups[1];
        if (PipeMonsterTraited.bad(mName, tMName)) {
            return null;
        }
        return this.make(MonsterTypeLib.byName(mName), MonsterTypeLib.byName(tMName));
    }

    private MonsterType make(MonsterType src, MonsterType traitSrc) {
        if (src.isMissingno() || traitSrc.isMissingno()) {
            return null;
        }
        List<Trait> traits = PipeItemTrait.getValidTraits(traitSrc);
        if (traits.size() == 0) {
            return null;
        }
        MTBill mtb = EntTypeUtils.copy(src);
        for (int i = 0; i < traits.size(); ++i) {
            Trait t = traits.get(i);
            Personal p = t.personal;
            if (p instanceof MonsterChance) continue;
            if (t.calcStats != null) {
                float hp = t.calcStats.getHp();
                float pw = t.calcStats.getDamage();
                mtb.trait(p, new CalcStats(hp, pw), t.visible);
                continue;
            }
            mtb.trait(p, null, t.visible);
        }
        MonsterType result = mtb.bEntType();
        String realName = result.getName(false) + MID + traitSrc.getName(false);
        mtb.name(realName);
        return mtb.bEntType();
    }

    @Override
    public float getRarity(boolean wild) {
        return 0.3f;
    }

    @Override
    public boolean canGenerate(boolean wild) {
        return true;
    }

    @Override
    protected MonsterType generateInternal(boolean wild) {
        MonsterType b;
        MonsterType a = MonsterTypeLib.randomWithRarity();
        if (a == (b = MonsterTypeLib.randomWithRarity())) {
            return null;
        }
        return this.make(MonsterTypeLib.randomWithRarity(), MonsterTypeLib.randomWithRarity());
    }

    @Override
    public boolean skipAPI() {
        return true;
    }
}

