/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.ent.type.lib;

import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.type.EntType;
import com.tann.dice.gameplay.content.ent.type.HeroType;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.gameplay.content.ent.type.bill.ETBill;
import com.tann.dice.gameplay.content.ent.type.bill.HTBill;
import com.tann.dice.gameplay.content.ent.type.bill.MTBill;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeLib;
import com.tann.dice.gameplay.content.ent.type.lib.HeroTypeUtils;
import com.tann.dice.gameplay.content.ent.type.lib.MonsterTypeLib;
import com.tann.dice.gameplay.effect.Trait;
import com.tann.dice.gameplay.effect.eff.Eff;
import java.util.ArrayList;
import java.util.List;

public class EntTypeUtils {
    public static List<EntType> getAll() {
        ArrayList<EntType> result = new ArrayList<EntType>();
        result.addAll(MonsterTypeLib.getAllValidMonsters());
        result.addAll(HeroTypeLib.getMasterCopy());
        return result;
    }

    public static EntType byName(String en) {
        MonsterType mt = MonsterTypeLib.byName(en);
        if (!mt.isMissingno()) {
            return mt;
        }
        return HeroTypeLib.byName(en);
    }

    public static EntType random() {
        if (Math.random() > 0.5) {
            return MonsterTypeLib.randomWithRarity();
        }
        return HeroTypeUtils.random();
    }

    public static List<Eff> getAllEffs() {
        ArrayList<Eff> result = new ArrayList<Eff>();
        for (EntType entType : EntTypeUtils.getAll()) {
            for (EntSide side : entType.sides) {
                result.add(side.getBaseEffect());
            }
        }
        return result;
    }

    public static MTBill copy(MonsterType src) {
        MTBill mtb = new MTBill(src.size);
        EntTypeUtils.finishInit(mtb, src);
        return mtb;
    }

    public static HTBill copy(HeroType src) {
        return HeroTypeUtils.copy(src);
    }

    public static ETBill copyE(EntType src) {
        if (src instanceof MonsterType) {
            return EntTypeUtils.copy((MonsterType)src);
        }
        if (src instanceof HeroType) {
            return HeroTypeUtils.copy((HeroType)src);
        }
        return null;
    }

    public static void finishInit(ETBill htb, EntType src) {
        htb.name(src.getName(false));
        EntSide[] sides = new EntSide[6];
        for (int i = 0; i < sides.length; ++i) {
            sides[i] = src.sides[i].copy();
        }
        htb.sidesRaw(sides);
        htb.hp(src.hp);
        htb.arOverride(src.portrait);
        htb.offsetOverride(src.offsets);
        for (Trait t : src.traits) {
            htb.trait(t);
        }
    }

    public static boolean anyMissingno(List<? extends EntType> monsterList) {
        for (int i = 0; i < monsterList.size(); ++i) {
            if (!monsterList.get(i).isMissingno()) continue;
            return true;
        }
        return false;
    }
}

