/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.ent.die;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.collision.btBoxShape;
import com.tann.dice.Main;
import com.tann.dice.gameplay.content.ent.die.DieContainer;
import com.tann.dice.gameplay.content.ent.die.EntDie;
import com.tann.dice.gameplay.content.ent.die.side.Side;
import com.tann.dice.gameplay.phase.Phase;
import com.tann.dice.gameplay.phase.PhaseManager;
import com.tann.dice.gameplay.save.settings.option.OptionLib;
import com.tann.dice.statics.ImageUtils;
import com.tann.dice.statics.bullet.BulletStuff;
import com.tann.dice.statics.bullet.CollisionObject;
import com.tann.dice.statics.sound.Sounds;
import com.tann.dice.util.Chrono;
import com.tann.dice.util.Colours;
import com.tann.dice.util.Maths;
import com.tann.dice.util.Tann;
import com.tann.dice.util.TannLog;
import java.util.List;
import java.util.Random;

public abstract class Die<SideType extends Side> {
    private static final TextureRegion blank = ImageUtils.loadExt3d("blank");
    private static float BASE_SIZE = 0.02f;
    private float cantripFlashDecay;
    private float cantripFlash;
    public static final float MAX_AIRTIME = 3.7f;
    protected DieState state = DieState.Stopped;
    protected int lockedSide = -1;
    protected int prevLockedSide;
    protected float dist = 0.0f;
    protected float currentInterpSpeed;
    protected static Material MATERIAL;
    public CollisionObject physical;
    protected static int dieIndex;
    protected float dieSize;
    protected static final int ATTRIBUTES = 29;
    protected float timeInAir;
    protected Runnable moveRunnable;
    public boolean flatDraw = true;
    protected btBoxShape disposeMe;
    protected SideType[] sides;
    private static final float e1Rot = 12.3f;
    private static final float ge2Rot = 12.1f;
    protected Vector3 temp = new Vector3();
    protected Vector3 positionTest = new Vector3();
    protected static float[] rotFactors;
    protected static float[] rotActuals;
    protected Vector3 startPos = new Vector3();
    protected Vector3 targetPos = new Vector3();
    protected Quaternion startQuat = new Quaternion();
    protected Quaternion targetQuat = new Quaternion();
    protected Quaternion originalRotation = new Quaternion();
    static final Quaternion[] d6Quats;
    protected float[] faceLocs = null;
    protected Vector2 lapelLocs = null;
    protected float[] keywordLocs = null;
    boolean disposed;
    private static final float BASE_INTERP_SPEED = 0.33f;

    public float getSafeY() {
        return this.physical.radius / 2.0f + 0.01f;
    }

    public void setSide(int side) {
        this.lockedSide = side;
        this.prevLockedSide = side;
        this.setupInitialLocation();
    }

    public void setSideOverride(int side) {
        this.lockedSide = side;
        this.prevLockedSide = side;
    }

    public void setCantripFlash(float glow, float decayTime) {
        this.cantripFlash = glow;
        this.cantripFlashDecay = glow / decayTime;
    }

    public float getCantripFlash() {
        return this.cantripFlash;
    }

    public static void clearAllStatics() {
        MATERIAL = null;
    }

    public Die(int startingSide) {
        this.lockedSide = startingSide;
        this.prevLockedSide = startingSide;
    }

    protected void init() {
        this.dieSize = this.getPixelSize() * BASE_SIZE;
        this.resetSides();
        this.construct();
        this.setupInitialLocation();
    }

    public void resetSides() {
        this.sides = this.initSides();
        this.clearTextureCache();
    }

    protected abstract SideType[] initSides();

    public void setState(DieState state) {
        DieState previousState = this.state;
        this.state = state;
        switch (state) {
            case Rolling: {
                this.lockedSide = -1;
                break;
            }
            case Stopped: {
                this.damp();
                if (previousState != DieState.Rolling) break;
                this.prevLockedSide = this.lockedSide = this.getSideIndex();
                if (this.lockedSide == -1) {
                    throw new RuntimeException("Failed to get side for die: " + (Object)((Object)this.getState()));
                }
                this.stopped();
                break;
            }
            case Locked: {
                this.locked();
                break;
            }
            case Locking: 
            case SlidingToMiddle: 
            case Unlocking: {
                this.removeFromPhysics();
            }
        }
    }

    protected abstract void locked();

    protected abstract void stopped();

    public DieState getState() {
        return this.state;
    }

    public void update(float delta) {
        this.cantripFlash = Math.max(0.0f, this.cantripFlash - this.cantripFlashDecay * delta);
        switch (this.state) {
            case Stopped: {
                break;
            }
            case Locking: 
            case SlidingToMiddle: 
            case Unlocking: {
                this.dist += delta / this.currentInterpSpeed;
                if (this.dist >= 1.0f) {
                    this.dist = 1.0f;
                    if (this.state == DieState.Unlocking) {
                        this.addToPhysics();
                        this.undamp();
                        this.setState(DieState.Stopped);
                    } else if (this.state == DieState.Locking) {
                        this.setState(DieState.Locked);
                    } else if (this.state == DieState.SlidingToMiddle) {
                        this.setState(DieState.Stopped);
                    }
                }
                this.dist = Math.min(1.0f, this.dist);
                float interp = Chrono.i.apply(this.dist);
                this.physical.transform.setToRotation(0.0f, 0.0f, 0.0f, 0.0f);
                Vector3 thisFrame = this.startPos.cpy().lerp(this.targetPos, interp);
                this.physical.transform.setToTranslation(thisFrame);
                this.physical.transform.rotate(this.startQuat.cpy().slerp(this.targetQuat, interp));
                this.physical.body.setWorldTransform(this.physical.transform);
                if (this.dist != 1.0f || this.moveRunnable == null) break;
                this.moveRunnable.run();
                break;
            }
            case Locked: {
                break;
            }
            case Rolling: {
                Phase p = PhaseManager.get().getPhase();
                if (p == null || !p.updateDice()) break;
                this.outOfBoundsCheck();
                if (this.isStopped()) {
                    this.setState(DieState.Stopped);
                    break;
                }
                this.timeInAir += delta;
                if (!(this.timeInAir > 3.7f)) break;
                this.jiggle();
            }
        }
    }

    public void roll(boolean firstRoll) {
        this.roll(firstRoll, Tann.makeStdRandom());
    }

    public void roll(boolean firstRoll, Random r) {
        float mult;
        if (this.getState() != DieState.Stopped) {
            return;
        }
        this.flatDraw = false;
        this.setState(DieState.Rolling);
        this.undamp();
        this.timeInAir = 0.0f;
        this.resetSpeed();
        float up = 21.0f;
        float upRand = 0.0f;
        float side = 0.0f;
        float sideRand = 0.8f;
        float rotRand = 0.0f;
        float center = 0.2f;
        float centerRand = 0.4f;
        if (Main.isPortrait()) {
            mult = 3.0f;
            center *= mult;
            centerRand *= mult;
            side *= mult;
            sideRand *= mult;
            up *= 1.05f;
        }
        if (firstRoll) {
            center = (float)((double)center - 0.04);
        }
        mult = 1.0f;
        float rot = 12.1f;
        if (BulletStuff.dice.size() == 1) {
            rot = 12.3f;
        }
        if (OptionLib.PRE_RANDOMISE.c() || BulletStuff.forcePrerandomise()) {
            this.physical.transform.rotate(this.getSideQuaternion(r.nextInt(6), false));
            this.physical.body.setWorldTransform(this.physical.transform);
        }
        this.randomise(up, upRand, side, sideRand, rot, rotRand, center, centerRand, mult, r);
    }

    public int getSideIndex() {
        switch (this.state) {
            case Rolling: {
                return -1;
            }
            case Locked: 
            case Locking: 
            case SlidingToMiddle: 
            case Unlocking: {
                return this.lockedSide;
            }
            case Stopped: {
                if (this.lockedSide >= 0) {
                    return this.lockedSide;
                }
                if (!this.isStopped()) {
                    return -1;
                }
                this.physical.update();
                this.physical.updateBounds();
                Quaternion rot = new Quaternion();
                this.physical.transform.getRotation(rot);
                Vector3 direction = new Vector3();
                direction.set(Vector3.Z);
                direction.mul(rot);
                float dot = Vector3.Y.dot(direction);
                if (dot > 0.9f) {
                    return 1;
                }
                if (dot < -0.9f) {
                    return 0;
                }
                direction.set(Vector3.X);
                direction.mul(rot);
                dot = Vector3.Y.dot(direction);
                if (dot > 0.9f) {
                    return 5;
                }
                if (dot < -0.9f) {
                    return 4;
                }
                direction.set(Vector3.Y);
                direction.mul(rot);
                dot = Vector3.Y.dot(direction);
                if (dot > 0.9f) {
                    return 3;
                }
                if (dot < -0.9f) {
                    return 2;
                }
                TannLog.log("Failed to find a valid side for the die, returning 0", TannLog.Severity.error);
                return 0;
            }
        }
        return -1;
    }

    protected void jiggle() {
        BulletStuff.addRollSFX(1, false, true);
        this.timeInAir = 0.0f;
        this.randomise(5.0f, 0.0f, 2.7f, 0.0f, 0.06f, 0.0f, 0.0f, 0.0f);
    }

    protected void damp() {
        this.physical.body.setDamping(2.0f, 50.0f);
    }

    public void undamp() {
        this.physical.body.setDamping(0.0f, 0.0f);
    }

    public void addToScreen() {
        if (BulletStuff.instances.contains(this.physical)) {
            return;
        }
        BulletStuff.instances.add(this.physical);
        this.resetSpeed();
        this.addToPhysics();
        this.physical.body.setContactCallbackFlag(512);
        this.physical.body.setContactCallbackFilter(0);
    }

    public void removeFromScreen() {
        if (BulletStuff.instances.remove(this.physical)) {
            this.removeFromPhysics();
        }
    }

    public void removeFromPhysics() {
        BulletStuff.removeBody(this.physical.body);
    }

    public void addToPhysics() {
        this.removeFromPhysics();
        BulletStuff.addDiceBody(this.physical.body);
    }

    protected void resetSpeed() {
        this.physical.body.setLinearVelocity(new Vector3());
        this.physical.body.setAngularVelocity(new Vector3());
    }

    protected void outOfBoundsCheck() {
        this.getPosition(this.temp);
        if (this.temp.y < -100.0f) {
            this.physical.transform.setToTranslation(BulletStuff.getMiddle().add(0.0f, 5.0f, 0.0f));
            this.physical.body.setWorldTransform(this.physical.transform);
            this.physical.body.setLinearVelocity(new Vector3(0.0f, 0.0f, 0.0f));
            this.randomise(0.0f, 0.0f, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    protected void getPosition(Vector3 out) {
        if (this.getState() == DieState.Locking || this.getState() == DieState.Unlocking || this.getState() == DieState.SlidingToMiddle) {
            out.set(this.targetPos);
        } else {
            this.physical.transform.getTranslation(out);
        }
    }

    protected void randomise(float up, float upRand, float side, float sideRand, float rot, float rotRand, float centeringMult, float centeringRand) {
        this.randomise(up, upRand, side, sideRand, rot, rotRand, centeringMult, centeringRand, 1.0f, new Random());
    }

    protected void randomise(float up, float upRand, float side, float sideRand, float rot, float rotRand, float centeringMult, float centeringRand, float mult, Random r) {
        int i;
        for (int i2 = 0; i2 < 10; ++i2) {
            r.nextInt();
        }
        float x = (side + Maths.factor(sideRand, r)) * (float)Maths.mult(r);
        float y = up + Maths.factor(upRand, r);
        float z = (side + Maths.factor(sideRand, r)) * (float)Maths.mult(r);
        float totalRot = rot + r.nextFloat() * rotRand;
        float totalRotFactor = 0.0f;
        for (i = 0; i < rotFactors.length; ++i) {
            Die.rotFactors[i] = 0.8f;
            if (i == 1) continue;
            totalRotFactor += rotFactors[i];
        }
        i = 0;
        while (i < rotFactors.length) {
            int n = i++;
            rotFactors[n] = rotFactors[n] / totalRotFactor;
        }
        for (i = 0; i < rotFactors.length; ++i) {
            Die.rotActuals[i] = rotFactors[i] * totalRot * (float)Maths.mult(r);
        }
        float totalCentering = Maths.factor(centeringRand, r) + centeringMult;
        this.getPosition(this.temp);
        Vector3 middle = BulletStuff.getMiddle();
        this.applyForces((x += (middle.x - this.temp.x) * totalCentering) * mult, y * mult, (z += (middle.z - this.temp.z) * totalCentering) * mult, rotActuals[0] * mult, rotActuals[1] * mult, rotActuals[2] * mult);
    }

    protected void applyForces(float x, float y, float z, float r1, float r2, float r3) {
        this.physical.body.setLinearVelocity(new Vector3(x, y, z));
        this.physical.body.setAngularVelocity(new Vector3(r1, r2, r3));
    }

    protected boolean isStopped() {
        this.physical.transform.getTranslation(this.temp);
        return !this.isMoving() && this.temp.y < -(0.0f - this.dieSize - 0.05f);
    }

    protected boolean isMoving() {
        return this.physical.isMoving();
    }

    protected static float getFloat(TextureRegion tr) {
        return Die.getFloat(tr.getRegionX() / 128, tr.getRegionY() / 128);
    }

    protected static float getFloat(int x, int y) {
        int num = x + 16 * y;
        return (float)num / 255.0f + 0.002f;
    }

    public abstract float getPixelSize();

    protected Quaternion getSideQuaternion(boolean panel) {
        return this.getSideQuaternion(panel, false);
    }

    protected Quaternion getSideQuaternion(boolean panel, boolean randomYaw) {
        int side;
        int n = side = this.lockedSide == -1 ? this.prevLockedSide : this.lockedSide;
        if (panel) {
            double angle = Math.atan(BulletStuff.cam.position.y / BulletStuff.cam.position.z);
            return new Quaternion().setEulerAnglesRad(0.0f, (float)(-angle), 0.0f).mul(d6Quats[side]);
        }
        return this.getSideQuaternion(side, randomYaw);
    }

    protected Quaternion getSideQuaternion(int side, boolean randomYaw) {
        return new Quaternion().setEulerAnglesRad(randomYaw ? (float)(Math.random() * 1000.0) : 0.0f, -1.5707964f, 0.0f).mul(d6Quats[side]);
    }

    public void moveTo(Vector2 position, Runnable runnable, float interpSpeed) {
        this.moveTo(position.x, position.y, runnable, interpSpeed);
    }

    protected void moveTo(float screenX, float screenY, Runnable runnable, float interpSpeed) {
        this.setState(DieState.Locking);
        this.moveTo(this.screenTo3D(screenX, screenY), this.getSideQuaternion(true), runnable, interpSpeed);
    }

    public void slideToPhysicalSpace(Vector3 position) {
        this.setState(DieState.SlidingToMiddle);
        this.moveTo(position, this.getSideQuaternion(false, true), null, 0.22f);
    }

    protected void moveTo(Vector3 position, Quaternion rotation, Runnable runnable, float interpSpeed) {
        this.currentInterpSpeed = interpSpeed;
        this.moveRunnable = runnable;
        this.dist = 0.0f;
        this.physical.update();
        this.startPos = this.physical.transform.getTranslation(this.startPos);
        this.targetPos.set(position);
        this.physical.transform.getRotation(this.startQuat);
        this.targetQuat = rotation;
    }

    protected Vector3 getFreeSpot() {
        float dist = 0.0f;
        float angle = 0.0f;
        float yPos = this.getSafeY();
        float rand = 0.5f;
        float startX = Tann.random(-0.5f, 0.5f);
        float startZ = Tann.random(-0.5f, 0.5f);
        if (Main.isPortrait()) {
            startX += 0.15f;
        }
        int attemps = 20000;
        for (int i = 0; i < 20000; ++i) {
            this.positionTest.set(BulletStuff.getMiddle().add((float)Math.sin(angle) * dist + startX, yPos, (float)Math.cos(angle) * dist + startZ));
            if (this.isPositionValid(this.positionTest)) {
                return this.positionTest;
            }
            dist += 0.004f;
            angle += 1.0f;
        }
        return this.makeFailsafeFreeSpot();
    }

    private Vector3 makeFailsafeFreeSpot() {
        float randDist = 0.8f;
        return BulletStuff.getMiddle().cpy().add(Tann.random(-randDist, randDist), 0.5f, Tann.random(-randDist, randDist));
    }

    private boolean isPositionValid(Vector3 positionTest) {
        for (int i = 0; i < BulletStuff.dice.size(); ++i) {
            Die d = BulletStuff.dice.get(i);
            if (d == this) continue;
            d.getPosition(this.temp);
            float xDiff = this.temp.x - positionTest.x;
            float zDiff = this.temp.z - positionTest.z;
            float dieDist = (float)Math.sqrt(xDiff * xDiff + zDiff * zDiff);
            if ((double)dieDist < 1.4 * (double)(this.dieSize + d.dieSize)) {
                return false;
            }
            if (BulletStuff.isWithinBox(positionTest, this.physical.radius * 0.9f)) continue;
            return false;
        }
        return true;
    }

    public static void scatterDice(List<EntDie> dice) {
        if (dice.size() == 0) {
            Sounds.playSound(Sounds.error);
            return;
        }
        Sounds.playSound(Sounds.unlock);
        for (Die die : dice) {
            die.returnToPlay(null, false, 0.3f);
        }
    }

    protected Vector3 screenTo3D(float screenX, float screenY) {
        double angle = -Math.atan2(BulletStuff.cam.position.y, BulletStuff.cam.position.z);
        float factor = BulletStuff.BOX_WIDTH_FOR_PIXEL_SIZE / BulletStuff.getWidth3d();
        float yzFactor = factor * (screenY + this.getPixelSize() / 2.0f - BulletStuff.getHeight3d() / 2.0f);
        Vector3 v = BulletStuff.cam.position.cpy().add(BulletStuff.camVector.cpy().scl(BulletStuff.BOX_DISTANCE_FOR_PIXEL_SIZE + this.physical.dimensions.y / 2.0f).add(screenX * factor - BulletStuff.BOX_WIDTH_FOR_PIXEL_SIZE / 2.0f + this.physical.dimensions.y / 2.0f, (float)(Math.cos(angle) * (double)yzFactor), (float)(Math.sin(angle) * (double)yzFactor)));
        return v;
    }

    public void slideToPanel() {
        this.removeFromPhysics();
        this.physical.transform.getRotation(this.originalRotation);
        this.getDieContainer().startLockingDie();
        this.moveTo(this.getDieContainer().getDieHolderLocation(true), new Runnable(){

            @Override
            public void run() {
                Die.this.getDieContainer().lockDie();
            }
        }, this.getLockSpeed());
    }

    protected float getLockSpeed() {
        return Die.getBaseInterpSpeed() * 0.75f;
    }

    public void returnToPlay(Runnable runnable, boolean applyNewQuaternion, float interpSpeed) {
        if (this.getState() == DieState.Locked) {
            this.setupInitialLocation();
        }
        this.addToScreen();
        this.setState(DieState.Unlocking);
        int newSide = this.getSideIndex();
        if (newSide == -1) {
            newSide = this.prevLockedSide;
        }
        if (applyNewQuaternion) {
            newSide = (int)((double)this.getSideIndex() + Math.random() * 6.0) % 6;
        }
        Vector3 targetLocation = this.getFreeSpot();
        Quaternion newQuat = this.getSideQuaternion(newSide, true);
        this.moveTo(targetLocation, newQuat, runnable, interpSpeed);
        this.flatDraw = false;
        this.undamp();
    }

    public void setupInitialLocation() {
        if (this.disposed) {
            TannLog.error("trying to setup initial location when disposed?");
        }
        Vector2 dHol = new Vector2();
        if (this.getDieContainer() != null) {
            dHol = this.getDieContainer().getDieHolderLocation(true);
        }
        this.physical.transform.setToTranslation(this.screenTo3D(dHol.x, dHol.y));
        this.physical.transform.rotate(this.getSideQuaternion(true, true));
        this.physical.body.setWorldTransform(this.physical.transform);
        this.originalRotation = this.getSideQuaternion(false, false);
    }

    public float getMass() {
        return (float)Math.pow(this.getPixelSize(), 3.0);
    }

    public void clearTextureCache() {
        this.faceLocs = null;
        this.lapelLocs = null;
        this.keywordLocs = null;
    }

    public float[] getFaceLocs() {
        if (this.faceLocs != null) {
            return this.faceLocs;
        }
        this.faceLocs = new float[12];
        float width = this.getSideTexture(0).getTexture().getWidth();
        float height = this.getSideTexture(0).getTexture().getHeight();
        for (int i = 0; i < 6; ++i) {
            TextureRegion face = this.getSideTexture(i);
            if (face == null) continue;
            this.faceLocs[2 * i + 0] = (float)face.getRegionX() / width;
            this.faceLocs[2 * i + 1] = (float)face.getRegionY() / height;
        }
        return this.faceLocs;
    }

    public float[] getPipsAsFloats() {
        float[] pips = new float[6];
        for (int i = 0; i < 6; ++i) {
            pips[i] = this.getPipFloat(i, false);
        }
        return pips;
    }

    public float[] getPipBonus() {
        int i;
        float[] pips = new float[12];
        for (i = 0; i < 6; ++i) {
            pips[i] = this.getPipFloat(i, true);
        }
        for (i = 0; i < 6; ++i) {
            pips[6 + i] = this.getBonusPipFloat(i);
        }
        return pips;
    }

    protected float getBonusPipFloat(int side) {
        return 0.0f;
    }

    public Vector2 getLapelLocs() {
        if (this.lapelLocs != null) {
            return this.lapelLocs;
        }
        float width = this.getSideTexture(0).getTexture().getWidth();
        float height = this.getSideTexture(0).getTexture().getHeight();
        TextureRegion tr = this.getLapelTexture();
        if (tr == null) {
            tr = ImageUtils.loadExt3d("misc/bigempty");
        }
        this.lapelLocs = new Vector2((float)tr.getRegionX() / width, (float)tr.getRegionY() / height);
        return this.lapelLocs;
    }

    public float[] getKeywordLocs() {
        return null;
    }

    protected abstract DieContainer getDieContainer();

    public SideType getCurrentSide() {
        int side = this.getSideIndex();
        if (side >= 0) {
            return this.getSide(side);
        }
        return null;
    }

    public Color getColour() {
        return Colours.green;
    }

    protected TextureRegion getSideTexture(int side) {
        return ((Side)this.getSide(side)).getTexture();
    }

    protected float getPipFloat(int side, boolean bonus) {
        return -1.0f;
    }

    protected TextureRegion getLapelTexture() {
        return blank;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        BulletStuff.dice.remove(this);
        BulletStuff.instances.remove(this.physical);
        this.removeFromScreen();
        this.disposeMe.dispose();
        this.physical.dispose();
        this.disposed = true;
    }

    public void reset() {
        this.lockedSide = -1;
    }

    public final SideType getSide(int index) {
        return this.sides[index];
    }

    protected void construct() {
        CollisionObject co;
        ModelBuilder mb = new ModelBuilder();
        mb.begin();
        mb.node().id = "dieIndex";
        if (MATERIAL == null) {
            MATERIAL = new Material(TextureAttribute.createDiffuse(this.getSideTexture(0).getTexture()));
        }
        MeshPartBuilder mpb = mb.part("dieIndex", 4, 29L, MATERIAL);
        float normalX = 0.0f;
        float normalY = 0.0f;
        float[] f = new float[]{Die.getFloat(4, 5)};
        float inner = f[(int)(Math.random() * (double)f.length)];
        block8: for (int i = 0; i < 6; ++i) {
            normalX = i;
            SideType side = this.getSide(i);
            TextureRegion base = ((Side)side).getTexture();
            mpb.setColor(Die.getFloat(base), 0.0f, inner, (float)dieIndex / 5.0f + 0.1f);
            switch (i) {
                case 0: {
                    mpb.rect(-this.dieSize, -this.dieSize, -this.dieSize, -this.dieSize, this.dieSize, -this.dieSize, this.dieSize, this.dieSize, -this.dieSize, this.dieSize, -this.dieSize, -this.dieSize, normalX, normalY, -1.0f);
                    continue block8;
                }
                case 1: {
                    mpb.rect(-this.dieSize, this.dieSize, this.dieSize, -this.dieSize, -this.dieSize, this.dieSize, this.dieSize, -this.dieSize, this.dieSize, this.dieSize, this.dieSize, this.dieSize, normalX, normalY, 1.0f);
                    continue block8;
                }
                case 2: {
                    mpb.rect(-this.dieSize, -this.dieSize, this.dieSize, -this.dieSize, -this.dieSize, -this.dieSize, this.dieSize, -this.dieSize, -this.dieSize, this.dieSize, -this.dieSize, this.dieSize, normalX, normalY, 0.0f);
                    continue block8;
                }
                case 3: {
                    mpb.rect(-this.dieSize, this.dieSize, -this.dieSize, -this.dieSize, this.dieSize, this.dieSize, this.dieSize, this.dieSize, this.dieSize, this.dieSize, this.dieSize, -this.dieSize, normalX, normalY, 0.0f);
                    continue block8;
                }
                case 4: {
                    mpb.rect(-this.dieSize, -this.dieSize, this.dieSize, -this.dieSize, this.dieSize, this.dieSize, -this.dieSize, this.dieSize, -this.dieSize, -this.dieSize, -this.dieSize, -this.dieSize, normalX, normalY, 0.0f);
                    continue block8;
                }
                case 5: {
                    mpb.rect(this.dieSize, -this.dieSize, -this.dieSize, this.dieSize, this.dieSize, -this.dieSize, this.dieSize, this.dieSize, this.dieSize, this.dieSize, -this.dieSize, this.dieSize, normalX, normalY, 0.0f);
                }
            }
        }
        Model model = mb.end();
        this.disposeMe = new btBoxShape(new Vector3(this.dieSize, this.dieSize, this.dieSize));
        this.physical = co = new CollisionObject(model, "dieIndex", this.disposeMe, this.getMass(), 0.005f);
        co.body.setCollisionFlags(co.body.getCollisionFlags() | 8);
        this.physical.body.setActivationState(4);
        co.body.setCollisionFlags(512);
        co.body.setContactCallbackFlag(512);
        co.body.setContactCallbackFilter(512);
        co.body.setActivationState(4);
        ++dieIndex;
        co.body.userData = this;
        this.physical.userData = this;
        this.physical.updateBounds();
        this.physical.transform.setTranslation(new Vector3(500.0f, 500.0f, 500.0f));
    }

    public static float getBaseInterpSpeed() {
        return 0.33f * (Main.isPortrait() ? 1.0f : 1.0f);
    }

    static {
        dieIndex = 0;
        rotFactors = new float[3];
        rotActuals = new float[3];
        d6Quats = new Quaternion[]{new Quaternion().setEulerAngles(0.0f, 180.0f, 270.0f), new Quaternion().setEulerAngles(0.0f, 0.0f, 90.0f), new Quaternion().setEulerAngles(90.0f, 180.0f, 270.0f), new Quaternion().setEulerAngles(90.0f, 0.0f, 90.0f), new Quaternion().setEulerAngles(0.0f, 90.0f, 270.0f), new Quaternion().setEulerAngles(0.0f, 270.0f, 270.0f)};
    }

    public static enum DieState {
        Rolling,
        Stopped,
        Locked,
        Locking,
        Unlocking,
        SlidingToMiddle;


        public boolean isLockedOrLocking() {
            return this == Locked || this == Locking;
        }
    }
}

