/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.content.ent;

import com.tann.dice.gameplay.content.ent.die.side.EntSide;
import com.tann.dice.gameplay.content.ent.die.side.blob.ESB;
import com.tann.dice.gameplay.content.ent.die.side.blob.EntSidesBlobBig;
import com.tann.dice.gameplay.content.ent.die.side.blob.EntSidesBlobHuge;
import com.tann.dice.gameplay.content.ent.die.side.blob.EntSidesBlobSmall;

public enum EntSize {
    small(12, 16, 3),
    reg(16, 24, 4),
    big(22, 30, 5),
    huge(28, 64, 11);

    private final int pixels;
    private final int panelHeight;
    private final int reinforceSize;

    private EntSize(int pixels, int panelHeight, int reinforceSize) {
        this.pixels = pixels;
        this.panelHeight = panelHeight;
        this.reinforceSize = reinforceSize;
    }

    public static EntSize getFromPx(int px) {
        for (EntSize s : EntSize.values()) {
            if (s.pixels != px) continue;
            return s;
        }
        return null;
    }

    public int getNumBlood() {
        return this.panelHeight * 2;
    }

    public EntSide getBlank() {
        switch (this) {
            case small: {
                return EntSidesBlobSmall.blank;
            }
            case reg: {
                return ESB.blank;
            }
            case big: {
                return EntSidesBlobBig.blank;
            }
            case huge: {
                return EntSidesBlobHuge.blank;
            }
        }
        throw new RuntimeException("Unable to find blank for " + (Object)((Object)this));
    }

    public EntSide getExerted() {
        switch (this) {
            case small: {
                return EntSidesBlobSmall.blankExerted;
            }
            case reg: {
                return ESB.blankExerted;
            }
            case big: {
                return EntSidesBlobBig.blankExerted;
            }
            case huge: {
                return EntSidesBlobHuge.blankExerted;
            }
        }
        throw new RuntimeException("Unable to find blank for " + (Object)((Object)this));
    }

    public int getReinforceSize() {
        return this.panelHeight;
    }

    public int getPixels() {
        return this.pixels;
    }

    public int getPipWidth() {
        return this == huge ? 3 : 2;
    }
}

