/*
 * Decompiled with CFR 0.152.
 */
package com.tann.dice.gameplay.battleTest;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.tann.dice.Main;
import com.tann.dice.gameplay.battleTest.Zone;
import com.tann.dice.gameplay.battleTest.template.BossTemplateLibrary;
import com.tann.dice.gameplay.content.ent.type.MonsterType;
import com.tann.dice.screens.dungeon.panels.Explanel.DiePanel;
import com.tann.dice.screens.dungeon.panels.book.views.MonsterLedgerView;
import com.tann.dice.util.Pixl;
import com.tann.dice.util.Tann;
import com.tann.dice.util.listener.TannListener;
import java.util.ArrayList;
import java.util.List;

public class ZoneInfo {
    private static Object getMaxWidth() {
        return Main.width - 20;
    }

    private static Group makeExplainZoneActor(Zone zone) {
        return new Pixl(5, 4).text(zone.name()).row().actor(ZoneInfo.makeMonstersActor(zone)).row().actor(ZoneInfo.makeBossesActor(zone)).pix();
    }

    private static Actor makeMonstersActor(Zone zone) {
        return ZoneInfo.makeMonstersActor("Monsters", zone.validMonsters);
    }

    private static Actor makeBossesActor(Zone zone) {
        return ZoneInfo.makeMonstersActor("Bosses", BossTemplateLibrary.getAllBossMonsters(zone));
    }

    private static Actor makeMonstersActor(String topString, List<MonsterType> validMonsters) {
        return new Pixl(2, 0).text(topString).row().actor(ZoneInfo.makeMonsterGroup(validMonsters)).pix();
    }

    private static Actor makeMonsterGroup(List<MonsterType> validMonsters) {
        ArrayList<Actor> actors = new ArrayList<Actor>();
        for (final MonsterType validMonster : validMonsters) {
            MonsterLedgerView mav = new MonsterLedgerView(validMonster, false);
            mav.addListener(new TannListener(){

                @Override
                public boolean action(int button, int pointer, float x, float y) {
                    DiePanel dp = new DiePanel(validMonster.makeEnt(), true);
                    Main.getCurrentScreen().pushAndCenter(dp, 0.8f);
                    return true;
                }
            });
            actors.add(mav);
        }
        return Tann.layoutMinArea(actors, 3, (int)((float)Main.width * 0.97f), 5);
    }
}

