/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.softbody;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.linearmath.btIDebugDraw;
import com.badlogic.gdx.physics.bullet.linearmath.btVector3;
import com.badlogic.gdx.physics.bullet.softbody.SoftbodyJNI;
import com.badlogic.gdx.physics.bullet.softbody.btSoftBody;
import com.badlogic.gdx.physics.bullet.softbody.btSoftBodyWorldInfo;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class btSoftBodyHelpers
extends BulletBase {
    private long swigCPtr;

    protected btSoftBodyHelpers(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public btSoftBodyHelpers(long cPtr, boolean cMemoryOwn) {
        this("btSoftBodyHelpers", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(btSoftBodyHelpers obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SoftbodyJNI.delete_btSoftBodyHelpers(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static void Draw(btSoftBody psb, btIDebugDraw idraw, int drawflags) {
        SoftbodyJNI.btSoftBodyHelpers_Draw__SWIG_0(btSoftBody.getCPtr(psb), psb, btIDebugDraw.getCPtr(idraw), idraw, drawflags);
    }

    public static void Draw(btSoftBody psb, btIDebugDraw idraw) {
        SoftbodyJNI.btSoftBodyHelpers_Draw__SWIG_1(btSoftBody.getCPtr(psb), psb, btIDebugDraw.getCPtr(idraw), idraw);
    }

    public static void DrawInfos(btSoftBody psb, btIDebugDraw idraw, boolean masses, boolean areas, boolean stress) {
        SoftbodyJNI.btSoftBodyHelpers_DrawInfos(btSoftBody.getCPtr(psb), psb, btIDebugDraw.getCPtr(idraw), idraw, masses, areas, stress);
    }

    public static void DrawNodeTree(btSoftBody psb, btIDebugDraw idraw, int mindepth, int maxdepth) {
        SoftbodyJNI.btSoftBodyHelpers_DrawNodeTree__SWIG_0(btSoftBody.getCPtr(psb), psb, btIDebugDraw.getCPtr(idraw), idraw, mindepth, maxdepth);
    }

    public static void DrawNodeTree(btSoftBody psb, btIDebugDraw idraw, int mindepth) {
        SoftbodyJNI.btSoftBodyHelpers_DrawNodeTree__SWIG_1(btSoftBody.getCPtr(psb), psb, btIDebugDraw.getCPtr(idraw), idraw, mindepth);
    }

    public static void DrawNodeTree(btSoftBody psb, btIDebugDraw idraw) {
        SoftbodyJNI.btSoftBodyHelpers_DrawNodeTree__SWIG_2(btSoftBody.getCPtr(psb), psb, btIDebugDraw.getCPtr(idraw), idraw);
    }

    public static void DrawFaceTree(btSoftBody psb, btIDebugDraw idraw, int mindepth, int maxdepth) {
        SoftbodyJNI.btSoftBodyHelpers_DrawFaceTree__SWIG_0(btSoftBody.getCPtr(psb), psb, btIDebugDraw.getCPtr(idraw), idraw, mindepth, maxdepth);
    }

    public static void DrawFaceTree(btSoftBody psb, btIDebugDraw idraw, int mindepth) {
        SoftbodyJNI.btSoftBodyHelpers_DrawFaceTree__SWIG_1(btSoftBody.getCPtr(psb), psb, btIDebugDraw.getCPtr(idraw), idraw, mindepth);
    }

    public static void DrawFaceTree(btSoftBody psb, btIDebugDraw idraw) {
        SoftbodyJNI.btSoftBodyHelpers_DrawFaceTree__SWIG_2(btSoftBody.getCPtr(psb), psb, btIDebugDraw.getCPtr(idraw), idraw);
    }

    public static void DrawClusterTree(btSoftBody psb, btIDebugDraw idraw, int mindepth, int maxdepth) {
        SoftbodyJNI.btSoftBodyHelpers_DrawClusterTree__SWIG_0(btSoftBody.getCPtr(psb), psb, btIDebugDraw.getCPtr(idraw), idraw, mindepth, maxdepth);
    }

    public static void DrawClusterTree(btSoftBody psb, btIDebugDraw idraw, int mindepth) {
        SoftbodyJNI.btSoftBodyHelpers_DrawClusterTree__SWIG_1(btSoftBody.getCPtr(psb), psb, btIDebugDraw.getCPtr(idraw), idraw, mindepth);
    }

    public static void DrawClusterTree(btSoftBody psb, btIDebugDraw idraw) {
        SoftbodyJNI.btSoftBodyHelpers_DrawClusterTree__SWIG_2(btSoftBody.getCPtr(psb), psb, btIDebugDraw.getCPtr(idraw), idraw);
    }

    public static void DrawFrame(btSoftBody psb, btIDebugDraw idraw) {
        SoftbodyJNI.btSoftBodyHelpers_DrawFrame(btSoftBody.getCPtr(psb), psb, btIDebugDraw.getCPtr(idraw), idraw);
    }

    public static btSoftBody CreateRope(btSoftBodyWorldInfo worldInfo, Vector3 from, Vector3 to, int res, int fixeds) {
        long cPtr = SoftbodyJNI.btSoftBodyHelpers_CreateRope(btSoftBodyWorldInfo.getCPtr(worldInfo), worldInfo, from, to, res, fixeds);
        return cPtr == 0L ? null : new btSoftBody(cPtr, false);
    }

    public static btSoftBody CreatePatch(btSoftBodyWorldInfo worldInfo, Vector3 corner00, Vector3 corner10, Vector3 corner01, Vector3 corner11, int resx, int resy, int fixeds, boolean gendiags) {
        long cPtr = SoftbodyJNI.btSoftBodyHelpers_CreatePatch(btSoftBodyWorldInfo.getCPtr(worldInfo), worldInfo, corner00, corner10, corner01, corner11, resx, resy, fixeds, gendiags);
        return cPtr == 0L ? null : new btSoftBody(cPtr, false);
    }

    public static btSoftBody CreatePatchUV(btSoftBodyWorldInfo worldInfo, Vector3 corner00, Vector3 corner10, Vector3 corner01, Vector3 corner11, int resx, int resy, int fixeds, boolean gendiags, FloatBuffer tex_coords) {
        assert (tex_coords.isDirect()) : "Buffer must be allocated direct.";
        long cPtr = SoftbodyJNI.btSoftBodyHelpers_CreatePatchUV__SWIG_0(btSoftBodyWorldInfo.getCPtr(worldInfo), worldInfo, corner00, corner10, corner01, corner11, resx, resy, fixeds, gendiags, tex_coords);
        return cPtr == 0L ? null : new btSoftBody(cPtr, false);
    }

    public static btSoftBody CreatePatchUV(btSoftBodyWorldInfo worldInfo, Vector3 corner00, Vector3 corner10, Vector3 corner01, Vector3 corner11, int resx, int resy, int fixeds, boolean gendiags) {
        long cPtr = SoftbodyJNI.btSoftBodyHelpers_CreatePatchUV__SWIG_1(btSoftBodyWorldInfo.getCPtr(worldInfo), worldInfo, corner00, corner10, corner01, corner11, resx, resy, fixeds, gendiags);
        return cPtr == 0L ? null : new btSoftBody(cPtr, false);
    }

    public static float CalculateUV(int resx, int resy, int ix, int iy, int id) {
        return SoftbodyJNI.btSoftBodyHelpers_CalculateUV(resx, resy, ix, iy, id);
    }

    public static btSoftBody CreateEllipsoid(btSoftBodyWorldInfo worldInfo, Vector3 center, Vector3 radius, int res) {
        long cPtr = SoftbodyJNI.btSoftBodyHelpers_CreateEllipsoid(btSoftBodyWorldInfo.getCPtr(worldInfo), worldInfo, center, radius, res);
        return cPtr == 0L ? null : new btSoftBody(cPtr, false);
    }

    public static btSoftBody CreateFromTriMesh(btSoftBodyWorldInfo worldInfo, FloatBuffer vertices, IntBuffer triangles, int ntriangles, boolean randomizeConstraints) {
        assert (vertices.isDirect()) : "Buffer must be allocated direct.";
        assert (triangles.isDirect()) : "Buffer must be allocated direct.";
        long cPtr = SoftbodyJNI.btSoftBodyHelpers_CreateFromTriMesh__SWIG_0(btSoftBodyWorldInfo.getCPtr(worldInfo), worldInfo, vertices, triangles, ntriangles, randomizeConstraints);
        return cPtr == 0L ? null : new btSoftBody(cPtr, false);
    }

    public static btSoftBody CreateFromTriMesh(btSoftBodyWorldInfo worldInfo, FloatBuffer vertices, IntBuffer triangles, int ntriangles) {
        assert (vertices.isDirect()) : "Buffer must be allocated direct.";
        assert (triangles.isDirect()) : "Buffer must be allocated direct.";
        long cPtr = SoftbodyJNI.btSoftBodyHelpers_CreateFromTriMesh__SWIG_1(btSoftBodyWorldInfo.getCPtr(worldInfo), worldInfo, vertices, triangles, ntriangles);
        return cPtr == 0L ? null : new btSoftBody(cPtr, false);
    }

    public static btSoftBody CreateFromConvexHull(btSoftBodyWorldInfo worldInfo, btVector3 vertices, int nvertices, boolean randomizeConstraints) {
        long cPtr = SoftbodyJNI.btSoftBodyHelpers_CreateFromConvexHull__SWIG_0(btSoftBodyWorldInfo.getCPtr(worldInfo), worldInfo, btVector3.getCPtr(vertices), vertices, nvertices, randomizeConstraints);
        return cPtr == 0L ? null : new btSoftBody(cPtr, false);
    }

    public static btSoftBody CreateFromConvexHull(btSoftBodyWorldInfo worldInfo, btVector3 vertices, int nvertices) {
        long cPtr = SoftbodyJNI.btSoftBodyHelpers_CreateFromConvexHull__SWIG_1(btSoftBodyWorldInfo.getCPtr(worldInfo), worldInfo, btVector3.getCPtr(vertices), vertices, nvertices);
        return cPtr == 0L ? null : new btSoftBody(cPtr, false);
    }

    public static btSoftBody CreateFromTetGenData(btSoftBodyWorldInfo worldInfo, String ele, String face, String node, boolean bfacelinks, boolean btetralinks, boolean bfacesfromtetras) {
        long cPtr = SoftbodyJNI.btSoftBodyHelpers_CreateFromTetGenData(btSoftBodyWorldInfo.getCPtr(worldInfo), worldInfo, ele, face, node, bfacelinks, btetralinks, bfacesfromtetras);
        return cPtr == 0L ? null : new btSoftBody(cPtr, false);
    }

    public static void ReoptimizeLinkOrder(btSoftBody psb) {
        SoftbodyJNI.btSoftBodyHelpers_ReoptimizeLinkOrder(btSoftBody.getCPtr(psb), psb);
    }

    public btSoftBodyHelpers() {
        this(SoftbodyJNI.new_btSoftBodyHelpers(), true);
    }
}

