#ifdef GL_ES 
#define LOWP lowp
#define MED mediump
#define HIGH highp
precision highp float;
#else
#define MED
#define LOWP
#define HIGH
#endif

varying vec4 v_color;  
varying vec2 v_texCoords;  
uniform float u_alpha;
uniform float u_random;
uniform float u_time;
uniform vec4 u_bounds;
uniform sampler2D u_texture;  

uniform vec4 u_noiseBounds;
float noise(vec2 loc) {
  vec2 bigLoc = mod(loc, u_noiseBounds.ba*2.0);
  vec2 smallLoc = mod(loc, u_noiseBounds.ba*1.0);
  vec2 quadrants = bigLoc/u_noiseBounds.ba;
  int index = int(quadrants.x) + int(quadrants.y)*2;
  vec4 col = texture2D(u_texture, u_noiseBounds.xy + smallLoc.xy);
  return col[index];
}
float noise(vec2 loc, int octaves) {
  float val = 0.5;
  for(int i=0;i<octaves;i++) {
    float power = pow(2.0, float(i));
    val += (noise(loc * power)-0.5)/power;
  }
  return val;
}

void main(){              
  vec4 col = v_color * texture2D(u_texture, v_texCoords);
  
  vec2 ratioPos = (gl_FragCoord.xy - u_bounds.xy) / u_bounds.zw;	
  

  float noiseFreqX = 0.0030;
  float noiseFreqY = 0.0025;
  float noiseVal = noise(gl_FragCoord.xy*vec2(noiseFreqX, noiseFreqY)+u_random*1000.0, 5);

  float noiseStrength = 3.8/pow(u_bounds.w, 0.5);

  float burnAmt = (1.0-ratioPos.y) - u_alpha*(1.0+noiseStrength) + noiseVal*noiseStrength;

  if(burnAmt < 0.0 ) {
    col.a=0.0;
  }

  float yellowStep = 0.9, orangeStep=0.8, redStep=0.7, sootStep=0.6, clearStep=0.5;
  float stepAlpha = 1.0-burnAmt;

  float yellowAmt = smoothstep(yellowStep, 1.0, stepAlpha);
  float orangeAmt = smoothstep(orangeStep, yellowStep, stepAlpha);
  float redAmt = smoothstep(redStep, orangeStep, stepAlpha);
  float sootAmt = smoothstep(sootStep, redStep, stepAlpha);


  col.rgb = mix(col.rgb, vec3(.1,.1,.1), sootAmt);
  col.rgb = mix(col.rgb, vec3(.8,.2,.2), redAmt);
  col.rgb = mix(col.rgb, vec3(1,.5,.1), orangeAmt);
  col.rgb = mix(col.rgb, vec3(.8,.8,.1), yellowAmt);

  gl_FragColor = col;
}

