/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools.impl;

import com.ibm.jvm.dtfjview.Session;
import com.ibm.jvm.dtfjview.tools.CommandException;
import com.ibm.jvm.dtfjview.tools.Tool;
import com.ibm.jvm.dtfjview.tools.ToolsRegistry;
import com.ibm.jvm.dtfjview.tools.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class CmdFileTool
extends Tool {
    public static final String[] AS_COMMENT_INDICATORS = new String[]{"//", "#"};
    public static final String COMMAND = "cmdfile";
    public static final String ARGUMENT_DESCRIPTION = "<commandFilePath> [charset]";
    public static final String HELP_DESCRIPTION = "To execute all the commands in a file.";
    public static final String USAGE = "cmdfile\t<commandFilePath> [charset]\tTo execute all the commands in a file.\n     Options:\n          <commandFilePath> : the path to a file which specifies a series of jdmpview commands.  \n               These commands are read and run sequentially.\n               Empty lines or lines starting with \"//\" or \"#\" will be ignored.\n     [charset] : the character set for the commands specified in the command file.\n          The character set name must be a supported charset as defined in java.nio.charset.Charset. For example, US-ASCII.";
    private String defaultCharset = null;

    public CmdFileTool(String string) {
        this.defaultCharset = string;
    }

    public static List<String> parseCmdFile(File file, String string) throws UnsupportedEncodingException, IOException {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray = FileUtils.read(file, string)) {
            if ((string2 = string2.trim()).length() <= 0 || string2.startsWith("//") || string2.startsWith("#")) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    @Override
    public boolean accept(String string, String[] stringArray) {
        return string.equalsIgnoreCase(COMMAND);
    }

    @Override
    public void process(String string, String[] stringArray, PrintStream printStream) throws CommandException {
        if (stringArray.length == 0) {
            printStream.println(USAGE);
            return;
        }
        File file = new File(stringArray[0]);
        if (!file.exists() || !file.isFile()) {
            printStream.println("The specified command file " + file.getAbsolutePath() + " does not exist or is not a file");
            return;
        }
        if (file.length() > Integer.MAX_VALUE) {
            printStream.println("The specified command file " + file.getAbsolutePath() + " is too large to be read");
            return;
        }
        String string2 = this.defaultCharset;
        if (stringArray.length == 2) {
            string2 = stringArray[1];
        } else if (stringArray.length > 2) {
            printStream.println(USAGE);
            return;
        }
        try {
            List<String> list = CmdFileTool.parseCmdFile(file, string2);
            for (String string3 : list) {
                printStream.println(Session.prompt + string3);
                try {
                    ToolsRegistry.process(string3, printStream);
                }
                catch (CommandException commandException) {
                    printStream.println(commandException.getMessage());
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            printStream.println("The supplied charset " + string2 + " for reading the command file is not supported");
        }
        catch (IOException iOException) {
            printStream.println("Error reading from command file " + file.getAbsolutePath());
        }
    }

    @Override
    public String getCommandName() {
        return COMMAND;
    }

    @Override
    public String getArgumentDescription() {
        return ARGUMENT_DESCRIPTION;
    }

    @Override
    public String getHelpDescription() {
        return HELP_DESCRIPTION;
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println(USAGE);
    }
}

