/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapRegionManagerPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_OwnableSynchronizerObjectListPointer;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckOwnableSynchronizerList
extends Check {
    CheckOwnableSynchronizerList() {
    }

    @Override
    public void check() {
        try {
            MM_HeapRegionManagerPointer mM_HeapRegionManagerPointer = this.getGCExtensions().heapRegionManager();
            long l = mM_HeapRegionManagerPointer._totalHeapSize().longValue() / J9Consts.J9_GC_MINIMUM_OBJECT_SIZE;
            MM_OwnableSynchronizerObjectListPointer mM_OwnableSynchronizerObjectListPointer = this.getGCExtensions().ownableSynchronizerObjectLists();
            while (mM_OwnableSynchronizerObjectListPointer.notNull()) {
                J9ObjectPointer j9ObjectPointer = mM_OwnableSynchronizerObjectListPointer._head();
                long l2 = 0L;
                this._engine.clearPreviousObjects();
                while (j9ObjectPointer.notNull() && this._engine.checkSlotOwnableSynchronizerList(j9ObjectPointer, mM_OwnableSynchronizerObjectListPointer) == 0) {
                    if (++l2 > l) {
                        this._engine.reportOwnableSynchronizerCircularReferenceError(j9ObjectPointer, mM_OwnableSynchronizerObjectListPointer);
                        break;
                    }
                    this._engine.pushPreviousObject(j9ObjectPointer);
                    j9ObjectPointer = ObjectAccessBarrier.getOwnableSynchronizerLink(j9ObjectPointer);
                }
                mM_OwnableSynchronizerObjectListPointer = mM_OwnableSynchronizerObjectListPointer._nextList();
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        if (this._engine.needVerifyOwnableSynchronizerConsistency()) {
            this._engine.verifyOwnableSynchronizerObjectCounts();
        }
    }

    @Override
    public String getCheckName() {
        return "OWNABLE_SYNCHRONIZER";
    }

    @Override
    public void print() {
        try {
            MM_OwnableSynchronizerObjectListPointer mM_OwnableSynchronizerObjectListPointer = this.getGCExtensions().ownableSynchronizerObjectLists();
            ScanFormatter scanFormatter = new ScanFormatter(this, "ownableSynchronizerObjectList");
            while (mM_OwnableSynchronizerObjectListPointer.notNull()) {
                scanFormatter.section("list", mM_OwnableSynchronizerObjectListPointer);
                J9ObjectPointer j9ObjectPointer = mM_OwnableSynchronizerObjectListPointer._head();
                while (j9ObjectPointer.notNull()) {
                    scanFormatter.entry(j9ObjectPointer);
                    j9ObjectPointer = ObjectAccessBarrier.getOwnableSynchronizerLink(j9ObjectPointer);
                }
                scanFormatter.endSection();
                mM_OwnableSynchronizerObjectListPointer = mM_OwnableSynchronizerObjectListPointer._nextList();
            }
            scanFormatter.end("ownableSynchronizerObjectList");
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

