/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.stackwalker.BaseStackWalkerCallbacks;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalkResult;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalker;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalkerUtils;
import com.ibm.j9ddr.vm29.j9.stackwalker.TerseStackWalkerCallbacks;
import com.ibm.j9ddr.vm29.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMEntryLocalStoragePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import java.io.PrintStream;

public class StackWalkCommand
extends Command {
    public StackWalkCommand() {
        this.addCommand("stack", "<thread>", "Walks the Java stack for <thread>");
        this.addCommand("stackslots", "<thread>", "Walks the Java stack (including objects) for <thread>");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            UDATAPointer uDATAPointer = UDATAPointer.NULL;
            UDATAPointer uDATAPointer2 = UDATAPointer.NULL;
            U8Pointer u8Pointer = U8Pointer.NULL;
            J9MethodPointer j9MethodPointer = J9MethodPointer.NULL;
            J9VMEntryLocalStoragePointer j9VMEntryLocalStoragePointer = J9VMEntryLocalStoragePointer.NULL;
            String[] stringArray2 = null;
            if (stringArray.length != 0) {
                stringArray2 = stringArray[0].split(",");
            }
            if (stringArray.length == 0 || stringArray2.length != 1 && stringArray2.length != 5 && stringArray2.length != 6) {
                CommandUtils.dbgPrint(printStream, "Usage:\n");
                CommandUtils.dbgPrint(printStream, "\t!stack thread\n");
                CommandUtils.dbgPrint(printStream, "\t!stack thread,sp,a0,pc,literals\n");
                CommandUtils.dbgPrint(printStream, "\t!stack thread,sp,a0,pc,literals,els\n");
                CommandUtils.dbgPrint(printStream, "\tUse !stackslots instead of !stack to see slot values\n");
                if (J9BuildFlags.interp_nativeSupport) {
                    CommandUtils.dbgPrint(printStream, "\tUse !jitstack or !jitstackslots to start the walk at a JIT frame\n");
                }
                return;
            }
            long l = CommandUtils.parsePointer(stringArray2[0], J9BuildFlags.env_data64);
            if (0L == l) {
                return;
            }
            J9VMThreadPointer j9VMThreadPointer = J9VMThreadPointer.cast(l);
            StackWalkerUtils.enableVerboseLogging(3, printStream);
            WalkState walkState = new WalkState();
            walkState.flags = J9Consts.J9_STACKWALK_RECORD_BYTECODE_PC_OFFSET;
            if (stringArray2.length >= 5) {
                l = CommandUtils.parsePointer(stringArray2[1], J9BuildFlags.env_data64);
                uDATAPointer = UDATAPointer.cast(l);
                l = CommandUtils.parsePointer(stringArray2[2], J9BuildFlags.env_data64);
                uDATAPointer2 = UDATAPointer.cast(l);
                l = CommandUtils.parsePointer(stringArray2[3], J9BuildFlags.env_data64);
                u8Pointer = U8Pointer.cast(l);
                l = CommandUtils.parsePointer(stringArray2[4], J9BuildFlags.env_data64);
                j9MethodPointer = J9MethodPointer.cast(l);
            } else {
                uDATAPointer = j9VMThreadPointer.sp();
                uDATAPointer2 = j9VMThreadPointer.arg0EA();
                u8Pointer = j9VMThreadPointer.pc();
                j9MethodPointer = j9VMThreadPointer.literals();
            }
            if (stringArray2.length >= 6) {
                l = CommandUtils.parsePointer(stringArray2[5], J9BuildFlags.env_data64);
                j9VMEntryLocalStoragePointer = J9VMEntryLocalStoragePointer.cast(l);
            } else if (J9BuildFlags.interp_nativeSupport) {
                j9VMEntryLocalStoragePointer = j9VMThreadPointer.entryLocalStorage();
            }
            if (string.equalsIgnoreCase("!stackslots")) {
                walkState.flags |= J9Consts.J9_STACKWALK_ITERATE_O_SLOTS;
                StackWalkerUtils.enableVerboseLogging(100, printStream);
                walkState.callBacks = new BaseStackWalkerCallbacks();
            } else {
                StackWalkerUtils.enableVerboseLogging(0, printStream);
                walkState.callBacks = new TerseStackWalkerCallbacks();
                walkState.flags |= J9Consts.J9_STACKWALK_ITERATE_FRAMES;
            }
            walkState.walkThread = j9VMThreadPointer;
            StackWalkResult stackWalkResult = StackWalker.walkStackFrames(walkState, uDATAPointer, uDATAPointer2, u8Pointer, j9MethodPointer, j9VMEntryLocalStoragePointer);
            if (stackWalkResult != StackWalkResult.NONE) {
                printStream.println("Stack walk result: " + (Object)((Object)stackWalkResult));
            }
            StackWalkerUtils.disableVerboseLogging();
            printStream.flush();
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

