/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.StructureCommandUtil;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.IClassWalkCallbacks;
import java.util.HashMap;
import java.util.regex.Pattern;

public abstract class ClassWalker {
    protected HashMap<String, String> debugExtMap = new HashMap();
    protected StructurePointer clazz;
    protected IClassWalkCallbacks classWalkerCallback;
    private static final Pattern TypeTagPattern = Pattern.compile("\\s*\\b(class|struct)\\s+");

    public abstract void allSlotsInObjectDo(IClassWalkCallbacks var1) throws CorruptDataException;

    public abstract Context getContext();

    protected void fillDebugExtMap() {
    }

    public StructurePointer getClazz() {
        return this.clazz;
    }

    public IClassWalkCallbacks getClassWalkerCallbacks() {
        return this.classWalkerCallback;
    }

    protected String getDebugExtForMethodName(String string) {
        return this.debugExtMap.get(string);
    }

    protected void addObjectsAsSlot(StructurePointer structurePointer, HashMap<String, String> hashMap) throws CorruptDataException {
        String string = structurePointer.getClass().getSimpleName().substring(0, structurePointer.getClass().getSimpleName().indexOf("Pointer"));
        StructureReader.StructureDescriptor structureDescriptor = StructureCommandUtil.getStructureDescriptor(string, this.getContext());
        if (structureDescriptor == null) {
            throw new CorruptDataException("Structure \"" + string + "\" can not be found.");
        }
        for (StructureReader.FieldDescriptor fieldDescriptor : structureDescriptor.getFields()) {
            String string2 = fieldDescriptor.getName();
            IClassWalkCallbacks.SlotType slotType = ClassWalker.getTypeByFieldTypeName(fieldDescriptor.getType());
            U8Pointer u8Pointer = U8Pointer.cast(structurePointer).addOffset(fieldDescriptor.getOffset());
            if (null != hashMap && hashMap.containsKey(string2)) {
                string2 = hashMap.get(string2);
            }
            this.classWalkerCallback.addSlot(this.clazz, slotType, u8Pointer, string2, this.getDebugExtForMethodName(string2));
        }
    }

    protected void addObjectsasSlot(StructurePointer structurePointer) throws CorruptDataException {
        this.addObjectsAsSlot(structurePointer, null);
    }

    private static IClassWalkCallbacks.SlotType getTypeByFieldTypeName(String string) throws CorruptDataException {
        String string2 = TypeTagPattern.matcher(string).replaceAll("");
        if (string2.equals("J9WSRP") || string2.startsWith("J9WSRP(")) {
            return IClassWalkCallbacks.SlotType.J9_WSRP;
        }
        if (string2.equals("J9SRP") || string2.startsWith("J9SRP(")) {
            return string2.startsWith("J9SRP(J9UTF8") ? IClassWalkCallbacks.SlotType.J9_SRP_TO_STRING : IClassWalkCallbacks.SlotType.J9_SRP;
        }
        if (string2.equals("J9UTF8*")) {
            return IClassWalkCallbacks.SlotType.J9_ROM_UTF8;
        }
        if (string2.equals("U8")) {
            return IClassWalkCallbacks.SlotType.J9_U8;
        }
        if (string2.equals("I8")) {
            return IClassWalkCallbacks.SlotType.J9_I8;
        }
        if (string2.equals("U16")) {
            return IClassWalkCallbacks.SlotType.J9_U16;
        }
        if (string2.equals("I16")) {
            return IClassWalkCallbacks.SlotType.J9_I16;
        }
        if (string2.equals("U32")) {
            return IClassWalkCallbacks.SlotType.J9_U32;
        }
        if (string2.equals("I32")) {
            return IClassWalkCallbacks.SlotType.J9_I32;
        }
        if (string2.equals("U64")) {
            return IClassWalkCallbacks.SlotType.J9_U64;
        }
        if (string2.equals("I64")) {
            return IClassWalkCallbacks.SlotType.J9_I64;
        }
        if (string2.equals("UDATA")) {
            return IClassWalkCallbacks.SlotType.J9_UDATA;
        }
        if (string2.equals("IDATA")) {
            return IClassWalkCallbacks.SlotType.J9_IDATA;
        }
        if (string2.equals("J9ROMNameAndSignature")) {
            return IClassWalkCallbacks.SlotType.J9_NAS;
        }
        if (string2.endsWith("*")) {
            return IClassWalkCallbacks.SlotType.J9_UDATA;
        }
        throw new CorruptDataException("Field type name '" + string + "' is not recognized.");
    }
}

