/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.stackwalker;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.J9StackWalkState;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StackWalkerUtils {
    public static final Logger logger = Logger.getLogger("j9ddr.stackwalker");
    private static int messageLevel = 0;
    private static PrintStream messageStream = null;
    public static final int INITIAL_O_SLOTS_CORRUPTION_THRESHOLD = 5;
    private static int oslotsCorruptionThreshold = 5;
    public static final boolean DEBUG_STACKMAP = false;
    public static final boolean DEBUG_LOCALMAP = false;
    static final int[] jitArgumentRegisterNumbers;

    public static void swPrintf(WalkState walkState, int n, String string, Object ... objectArray) {
        Object object;
        if (messageLevel >= n && messageStream != null) {
            object = MessageFormat.format("<" + Long.toHexString(walkState.walkThread.getAddress()) + "> " + string, objectArray);
            messageStream.println((String)object);
        }
        Object object2 = n == 1 ? Level.FINE : (object = n == 2 ? Level.FINER : Level.FINEST);
        if (logger.isLoggable((Level)object)) {
            logger.logp((Level)object, (String)null, (String)null, "<" + Long.toHexString(walkState.walkThread.getAddress()) + "> " + string, objectArray);
        }
    }

    public static void swPrintMethod(WalkState walkState) throws CorruptDataException {
        StackWalkerUtils.swPrintMethod(walkState, walkState.method);
    }

    public static void swPrintMethod(WalkState walkState, J9MethodPointer j9MethodPointer) throws CorruptDataException {
        if (j9MethodPointer.notNull()) {
            J9UTF8Pointer j9UTF8Pointer = ConstantPoolHelpers.J9_CLASS_FROM_METHOD(j9MethodPointer).romClass().className();
            J9ROMMethodPointer j9ROMMethodPointer = ROMHelp.J9_ROM_METHOD_FROM_RAM_METHOD(j9MethodPointer);
            J9UTF8Pointer j9UTF8Pointer2 = j9ROMMethodPointer.nameAndSignature().name();
            J9UTF8Pointer j9UTF8Pointer3 = j9ROMMethodPointer.nameAndSignature().signature();
            StackWalkerUtils.swPrintf(walkState, 2, "\tMethod: {0}.{1}{2} !j9method {3}", J9UTF8Helper.stringValue(j9UTF8Pointer), J9UTF8Helper.stringValue(j9UTF8Pointer2), J9UTF8Helper.stringValue(j9UTF8Pointer3), j9MethodPointer.getHexAddress());
        }
    }

    public static void WALK_METHOD_CLASS(WalkState walkState) throws CorruptDataException {
        if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_METHOD_CLASS_SLOTS) != 0L) {
            StackWalkerUtils.SWALK_PRINT_CLASS_OF_RUNNING_METHOD(walkState);
            walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_INTERNAL;
            walkState.slotIndex = -1;
            StackWalkerUtils.WALK_O_SLOT(walkState, walkState.constantPool.ramClass().classObjectEA());
        }
    }

    public static void WALK_NAMED_INDIRECT_O_SLOT(WalkState walkState, PointerPointer pointerPointer, VoidPointer voidPointer, String string) throws CorruptDataException {
        UDATA uDATA = UDATAPointer.cast(pointerPointer).at(0L);
        if (voidPointer.notNull()) {
            StackWalkerUtils.swPrintf(walkState, 4, "\t\t{0}[{1} -> {2}] = {3}", string != null ? string : "O-Slot", voidPointer.getHexAddress(), pointerPointer.getHexAddress(), uDATA.getHexValue());
        } else {
            StackWalkerUtils.swPrintf(walkState, 4, "\t\t{0}[{1}] = {2}", string != null ? string : "O-Slot", pointerPointer.getHexAddress(), uDATA.getHexValue());
        }
        walkState.callBacks.objectSlotWalkFunction(walkState.walkThread, walkState, pointerPointer, VoidPointer.cast(pointerPointer));
    }

    public static void WALK_NAMED_INDIRECT_I_SLOT(WalkState walkState, PointerPointer pointerPointer, VoidPointer voidPointer, String string) throws CorruptDataException {
        if (voidPointer.notNull()) {
            StackWalkerUtils.swPrintf(walkState, 4, "\t\t{0}[{1} -> {2}] = {3}", string != null ? string : "I-Slot", voidPointer.getHexAddress(), pointerPointer.getHexAddress(), UDATAPointer.cast(pointerPointer).at(0L).getHexValue());
        } else {
            StackWalkerUtils.swPrintf(walkState, 4, "\t\t{0}[{1}] = {2}", string != null ? string : "I-Slot", pointerPointer.getHexAddress(), UDATAPointer.cast(pointerPointer).at(0L).getHexValue());
        }
    }

    public static void WALK_INDIRECT_O_SLOT(WalkState walkState, PointerPointer pointerPointer, VoidPointer voidPointer) throws CorruptDataException {
        StackWalkerUtils.WALK_NAMED_INDIRECT_O_SLOT(walkState, pointerPointer, voidPointer, null);
    }

    public static void WALK_INDIRECT_I_SLOT(WalkState walkState, PointerPointer pointerPointer, VoidPointer voidPointer) throws CorruptDataException {
        StackWalkerUtils.WALK_NAMED_INDIRECT_I_SLOT(walkState, pointerPointer, voidPointer, null);
    }

    public static void WALK_NAMED_O_SLOT(WalkState walkState, PointerPointer pointerPointer, String string) throws CorruptDataException {
        StackWalkerUtils.WALK_NAMED_INDIRECT_O_SLOT(walkState, pointerPointer, VoidPointer.cast(0L), string);
    }

    public static void WALK_NAMED_I_SLOT(WalkState walkState, PointerPointer pointerPointer, String string) throws CorruptDataException {
        StackWalkerUtils.WALK_NAMED_INDIRECT_I_SLOT(walkState, pointerPointer, VoidPointer.cast(0L), string);
    }

    public static void WALK_O_SLOT(WalkState walkState, PointerPointer pointerPointer) throws CorruptDataException {
        StackWalkerUtils.WALK_INDIRECT_O_SLOT(walkState, pointerPointer, VoidPointer.cast(0L));
    }

    public static void WALK_I_SLOT(WalkState walkState, PointerPointer pointerPointer) throws CorruptDataException {
        StackWalkerUtils.WALK_INDIRECT_I_SLOT(walkState, pointerPointer, VoidPointer.cast(0L));
    }

    private static void SWALK_PRINT_CLASS_OF_RUNNING_METHOD(WalkState walkState) {
        StackWalkerUtils.swPrintf(walkState, 4, "\tClass of running method", new Object[0]);
    }

    public static UDATA JIT_RESOLVE_PARM(WalkState walkState, int n) throws CorruptDataException {
        if (J9BuildFlags.arch_x86 && !J9BuildFlags.env_data64) {
            return walkState.bp.at(n);
        }
        return walkState.walkedEntryLocalStorage.jitGlobalStorageBase().at(jitArgumentRegisterNumbers[n - 1]);
    }

    public static void resetOSlotsCorruptionThreshold() {
        oslotsCorruptionThreshold = 5;
    }

    public static boolean oSlotsCorruptionThresholdReached() {
        return oslotsCorruptionThreshold < 0;
    }

    public static void handleOSlotsCorruption(WalkState walkState, String string, String string2, CorruptDataException corruptDataException) {
        if (oslotsCorruptionThreshold > 0) {
            --oslotsCorruptionThreshold;
            EventManager.raiseCorruptDataEvent("CorruptData encountered iterating o-slots. walkThread = " + walkState.walkThread.getHexAddress(), corruptDataException, false);
        }
        if (oslotsCorruptionThreshold == 0) {
            EventManager.raiseCorruptDataEvent("Corruption threshold hit. Will stop walking object slots on this thread. walkThread = " + walkState.walkThread.getHexAddress(), corruptDataException, false);
            walkState.flags &= (J9Consts.J9_STACKWALK_ITERATE_O_SLOTS | J9Consts.J9_STACKWALK_MAINTAIN_REGISTER_MAP) ^ 0xFFFFFFFFFFFFFFFFL;
            oslotsCorruptionThreshold = -1;
        }
    }

    public static void enableVerboseLogging(int n) {
        StackWalkerUtils.enableVerboseLogging(n, System.err);
    }

    public static void enableVerboseLogging(int n, PrintStream printStream) {
        messageLevel = n;
        messageStream = printStream;
    }

    public static void disableVerboseLogging() {
        messageLevel = 0;
        messageStream = null;
    }

    static {
        if (J9BuildFlags.arch_x86) {
            jitArgumentRegisterNumbers = J9BuildFlags.env_data64 ? new int[]{0, 5, 3, 2} : new int[0];
        } else if (J9BuildFlags.arch_arm) {
            jitArgumentRegisterNumbers = new int[]{0, 1, 2, 3};
        } else if (J9BuildFlags.arch_aarch64) {
            jitArgumentRegisterNumbers = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
        } else if (J9BuildFlags.arch_power) {
            jitArgumentRegisterNumbers = new int[]{3, 4, 5, 6, 7, 8, 9, 10};
        } else if (J9BuildFlags.arch_s390) {
            jitArgumentRegisterNumbers = new int[]{1, 2, 3};
        } else if (J9BuildFlags.arch_riscv) {
            jitArgumentRegisterNumbers = new int[]{10, 11, 12, 13, 14, 15, 16, 17};
        } else {
            throw new IllegalArgumentException("Unsupported platform");
        }
    }
}

