/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMGCSegregatedAllocationCacheEntryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.structure.MM_HeapRegionDescriptor;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;

class GCObjectHeapIteratorSegregated_V1
extends GCObjectHeapIterator {
    protected J9ObjectPointer currentObject = null;
    protected U8Pointer scanPtr;
    protected U8Pointer scanPtrTop;
    protected J9ObjectPointer smallPtrTop;
    protected long type;
    protected UDATA cellSize;
    protected U8Pointer[][] allocationCacheRanges;
    protected int currentAllocationCacheRange;
    protected static ArrayList<U8Pointer[]> threadAllocationCacheRanges;
    protected static Comparator<U8Pointer[]> rangeSorter;

    protected GCObjectHeapIteratorSegregated_V1(U8Pointer u8Pointer, U8Pointer u8Pointer2, long l, UDATA uDATA, boolean bl, boolean bl2) throws CorruptDataException {
        super(bl, bl2);
        this.scanPtr = u8Pointer;
        this.scanPtrTop = u8Pointer2;
        this.type = l;
        this.cellSize = uDATA;
        this.currentAllocationCacheRange = 0;
        this.calculateActualScanPtrTop();
        ArrayList<U8Pointer[]> arrayList = new ArrayList<U8Pointer[]>(threadAllocationCacheRanges);
        arrayList.add(new U8Pointer[]{this.scanPtrTop, this.scanPtrTop});
        Collections.sort(arrayList, rangeSorter);
        this.allocationCacheRanges = new U8Pointer[arrayList.size()][2];
        arrayList.toArray((T[])this.allocationCacheRanges);
    }

    @Override
    public boolean hasNext() {
        try {
            if (null != this.currentObject) {
                return true;
            }
            while (this.scanPtr.lt(this.scanPtrTop)) {
                while (this.scanPtr.gt(this.allocationCacheRanges[this.currentAllocationCacheRange][1])) {
                    ++this.currentAllocationCacheRange;
                }
                if (this.scanPtr.gte(this.allocationCacheRanges[this.currentAllocationCacheRange][0])) {
                    this.scanPtr = U8Pointer.cast(this.allocationCacheRanges[this.currentAllocationCacheRange][1]);
                    ++this.currentAllocationCacheRange;
                    continue;
                }
                this.currentObject = J9ObjectPointer.cast(this.scanPtr);
                if (MM_HeapRegionDescriptor.RegionType.SEGREGATED_SMALL == this.type) {
                    UDATA uDATA;
                    if (!ObjectModel.isDeadObject(this.currentObject)) {
                        uDATA = ObjectModel.getConsumedSizeInBytesWithHeader(this.currentObject);
                        if (uDATA.gt(this.cellSize)) {
                            this.currentObject = null;
                            throw new CorruptDataException("Allocated object at " + this.scanPtr.getHexAddress() + " has an invalid size of " + uDATA.getHexValue());
                        }
                        this.scanPtr = this.scanPtr.add(this.cellSize);
                        if (!this.includeLiveObjects) continue;
                        return true;
                    }
                    uDATA = ObjectModel.getSizeInBytesDeadObject(this.currentObject);
                    if (uDATA.lt(this.cellSize)) {
                        this.currentObject = null;
                        throw new CorruptDataException("GCHeapLinkedFreeHeader at " + this.scanPtr.getHexAddress() + " has an invalid size of " + uDATA.getHexValue());
                    }
                    this.scanPtr = this.scanPtr.addOffset(uDATA);
                    if (!this.includeDeadObjects) continue;
                    return true;
                }
                if (MM_HeapRegionDescriptor.RegionType.SEGREGATED_LARGE == this.type) {
                    this.scanPtr = U8Pointer.cast(this.scanPtrTop);
                    if (!this.includeLiveObjects) continue;
                    return true;
                }
                throw new CorruptDataException("Invalid region type");
            }
            return false;
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Error getting next item", corruptDataException, false);
            return false;
        }
    }

    @Override
    public void advance(UDATA uDATA) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public J9ObjectPointer next() {
        if (this.hasNext()) {
            J9ObjectPointer j9ObjectPointer = this.currentObject;
            this.currentObject = null;
            return j9ObjectPointer;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    private void calculateActualScanPtrTop() {
        if (MM_HeapRegionDescriptor.RegionType.SEGREGATED_SMALL == this.type) {
            UDATA uDATA = UDATA.cast(this.scanPtrTop).sub(UDATA.cast(this.scanPtr)).div(this.cellSize);
            UDATA uDATA2 = uDATA.mult(this.cellSize);
            this.scanPtrTop = this.scanPtr.add(uDATA2);
        }
    }

    @Override
    public J9ObjectPointer peek() {
        if (this.hasNext()) {
            return this.currentObject;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    static {
        rangeSorter = new Comparator<U8Pointer[]>(){

            @Override
            public int compare(U8Pointer[] u8PointerArray, U8Pointer[] u8PointerArray2) {
                return u8PointerArray[0].compare(u8PointerArray2[0]);
            }
        };
        try {
            ArrayList<U8Pointer[]> arrayList = new ArrayList<U8Pointer[]>();
            GCVMThreadListIterator gCVMThreadListIterator = new GCVMThreadListIterator();
            while (gCVMThreadListIterator.hasNext()) {
                Field field;
                Class<?> clazz;
                J9VMThreadPointer j9VMThreadPointer = gCVMThreadListIterator.next();
                long l = 0L;
                long l2 = 0L;
                try {
                    clazz = Class.forName(DataType.getStructurePackageName() + ".J9VMGCSizeClasses");
                    field = clazz.getDeclaredField("J9VMGC_SIZECLASSES_NUM_SMALL");
                    l = field.getLong(null);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new UnsupportedOperationException("This shouldn't happen considering how DDR works");
                }
                try {
                    clazz = Class.forName(DataType.getStructurePackageName() + ".J9Consts");
                    field = clazz.getDeclaredField("J9VMGC_SIZECLASSES_NUM_SMALL");
                    l2 = field.getLong(null);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new UnsupportedOperationException("This shouldn't happen considering how DDR works");
                }
                if (l == 0L && l2 == 0L) {
                    throw new UnsupportedOperationException("This cores seems invalid.. J9VMGC_SIZECLASSES_NUM_SMALL must be defined in either J9Consts or J9VMGCSizeClasses");
                }
                if (l != 0L && l2 != 0L) {
                    throw new UnsupportedOperationException("This cores seems invalid.. J9VMGC_SIZECLASSES_NUM_SMALL can't be defined in two places");
                }
                long l3 = l != 0L ? l : l2;
                int n = 0;
                while ((long)n < l3 + 1L) {
                    U8Pointer u8Pointer;
                    J9VMGCSegregatedAllocationCacheEntryPointer j9VMGCSegregatedAllocationCacheEntryPointer = j9VMThreadPointer.segregatedAllocationCache();
                    U8Pointer u8Pointer2 = U8Pointer.cast((j9VMGCSegregatedAllocationCacheEntryPointer = j9VMGCSegregatedAllocationCacheEntryPointer.add(n)).current());
                    if (u8Pointer2.lt(u8Pointer = U8Pointer.cast(j9VMGCSegregatedAllocationCacheEntryPointer.top()))) {
                        arrayList.add(new U8Pointer[]{u8Pointer2, u8Pointer});
                    }
                    ++n;
                }
            }
            Collections.sort(arrayList, rangeSorter);
            threadAllocationCacheRanges = arrayList;
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Error calculating active allocation cache ranges", corruptDataException, true);
        }
    }
}

