/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.util.IteratorHelpers;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.CorruptFreeEntryException;
import com.ibm.j9ddr.vm29.j9.gc.CorruptHintException;
import com.ibm.j9ddr.vm29.j9.gc.GCBase;
import com.ibm.j9ddr.vm29.j9.gc.GCFreeListHeapIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCFreeListHeapIteratorSplitAddressOrderedList;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapLinkedFreeHeader;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCMemoryPool;
import com.ibm.j9ddr.vm29.j9.gc.GCModronAllocateHintIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCModronAllocateHintIteratorSAOL;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModronAllocateHintPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModronFreeListPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapLinkedFreeHeaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MemoryPoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MemoryPoolSplitAddressOrderedListPointer;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class GCMemoryPoolSplitAddressOrderedList
extends GCMemoryPool {
    protected UDATA _heapFreeListCount = new UDATA(0L);
    protected MM_MemoryPoolSplitAddressOrderedListPointer _memoryPool = null;
    protected J9ModronFreeListPointer _heapFreeLists = null;
    protected GCHeapRegionDescriptor _region = null;

    protected GCMemoryPoolSplitAddressOrderedList(GCHeapRegionDescriptor gCHeapRegionDescriptor, MM_MemoryPoolPointer mM_MemoryPoolPointer) throws CorruptDataException {
        super(gCHeapRegionDescriptor, mM_MemoryPoolPointer);
        this.init(gCHeapRegionDescriptor, mM_MemoryPoolPointer);
    }

    private void init(GCHeapRegionDescriptor gCHeapRegionDescriptor, MM_MemoryPoolPointer mM_MemoryPoolPointer) throws CorruptDataException {
        this._region = gCHeapRegionDescriptor;
        this._memoryPoolType = GCMemoryPool.MemoryPoolType.SAOL;
        this._memoryPool = MM_MemoryPoolSplitAddressOrderedListPointer.cast(mM_MemoryPoolPointer);
        this._heapFreeLists = this._memoryPool._heapFreeLists();
        this._heapFreeListCount = this._memoryPool._heapFreeListCount();
    }

    public UDATA getFreeListCount() throws CorruptDataException {
        return this._heapFreeListCount;
    }

    public GCModronAllocateHintIterator hintIterator() throws CorruptDataException {
        return new GCModronAllocateHintIteratorSAOL(this);
    }

    public GCHeapLinkedFreeHeader getFirstEntryAtFreeListIndex(UDATA uDATA) throws CorruptDataException {
        return GCHeapLinkedFreeHeader.fromLinkedFreeHeaderPointer(this._heapFreeLists.add(uDATA)._freeList());
    }

    public J9ModronAllocateHintPointer getFirstHintForFreeList(UDATA uDATA) throws CorruptDataException {
        return this._heapFreeLists.add(uDATA)._hintActive();
    }

    private void freeEntryCheck(GCHeapLinkedFreeHeader gCHeapLinkedFreeHeader, GCHeapLinkedFreeHeader gCHeapLinkedFreeHeader2) throws CorruptFreeEntryException, CorruptDataException {
        MM_HeapLinkedFreeHeaderPointer mM_HeapLinkedFreeHeaderPointer = gCHeapLinkedFreeHeader.getHeader();
        MM_HeapLinkedFreeHeaderPointer mM_HeapLinkedFreeHeaderPointer2 = MM_HeapLinkedFreeHeaderPointer.NULL;
        this.freeEntryCheckGeneric(gCHeapLinkedFreeHeader);
        if (null != gCHeapLinkedFreeHeader2 && (mM_HeapLinkedFreeHeaderPointer2 = gCHeapLinkedFreeHeader2.getHeader()).gte(mM_HeapLinkedFreeHeaderPointer)) {
            throw new CorruptFreeEntryException("invalidOrdering", mM_HeapLinkedFreeHeaderPointer);
        }
        if (gCHeapLinkedFreeHeader.getSize().lt(GCBase.getExtensions().tlhMinimumSize())) {
            throw new CorruptFreeEntryException("sizeFieldInvalid", gCHeapLinkedFreeHeader.getHeader());
        }
    }

    public GCFreeListHeapIterator freeListIterator() throws CorruptDataException {
        return new GCFreeListHeapIteratorSplitAddressOrderedList(this);
    }

    @Override
    public void checkFreeListsImpl() {
        try {
            GCFreeListHeapIterator gCFreeListHeapIterator = this.freeListIterator();
            GCHeapLinkedFreeHeader gCHeapLinkedFreeHeader = null;
            J9ModronAllocateHintPointer j9ModronAllocateHintPointer = null;
            MM_HeapLinkedFreeHeaderPointer mM_HeapLinkedFreeHeaderPointer = null;
            List list = IteratorHelpers.toList(this.hintIterator());
            Collections.sort(list, new Comparator<J9ModronAllocateHintPointer>(){

                @Override
                public int compare(J9ModronAllocateHintPointer j9ModronAllocateHintPointer, J9ModronAllocateHintPointer j9ModronAllocateHintPointer2) {
                    try {
                        if (j9ModronAllocateHintPointer2.heapFreeHeader().gt(j9ModronAllocateHintPointer.heapFreeHeader())) {
                            return -1;
                        }
                        if (j9ModronAllocateHintPointer2.heapFreeHeader().eq(j9ModronAllocateHintPointer.heapFreeHeader())) {
                            return 0;
                        }
                        return 1;
                    }
                    catch (CorruptDataException corruptDataException) {
                        EventManager.raiseCorruptDataEvent("corruption detected in allocation hints", corruptDataException, false);
                        throw new UnsupportedOperationException("Unreachable");
                    }
                }
            });
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                j9ModronAllocateHintPointer = (J9ModronAllocateHintPointer)iterator.next();
                mM_HeapLinkedFreeHeaderPointer = j9ModronAllocateHintPointer.heapFreeHeader();
            }
            while (gCFreeListHeapIterator.hasNext()) {
                GCHeapLinkedFreeHeader gCHeapLinkedFreeHeader2 = gCFreeListHeapIterator.next();
                try {
                    this.freeEntryCheck(gCHeapLinkedFreeHeader2, gCHeapLinkedFreeHeader);
                    gCHeapLinkedFreeHeader = gCHeapLinkedFreeHeader2;
                }
                catch (CorruptFreeEntryException corruptFreeEntryException) {
                    EventManager.raiseCorruptDataEvent("Free list corruption detected", corruptFreeEntryException, false);
                }
                catch (CorruptDataException corruptDataException) {
                    EventManager.raiseCorruptDataEvent("Corruption detected in free entry", corruptDataException, false);
                }
                MM_HeapLinkedFreeHeaderPointer mM_HeapLinkedFreeHeaderPointer2 = gCHeapLinkedFreeHeader2.getHeader();
                while (null != mM_HeapLinkedFreeHeaderPointer && mM_HeapLinkedFreeHeaderPointer.lte(mM_HeapLinkedFreeHeaderPointer2)) {
                    if (mM_HeapLinkedFreeHeaderPointer.lt(mM_HeapLinkedFreeHeaderPointer2)) {
                        throw new CorruptHintException("allocHintFreeEntryCorrupt", j9ModronAllocateHintPointer);
                    }
                    if (iterator.hasNext()) {
                        j9ModronAllocateHintPointer = (J9ModronAllocateHintPointer)iterator.next();
                        mM_HeapLinkedFreeHeaderPointer = j9ModronAllocateHintPointer.heapFreeHeader();
                        continue;
                    }
                    mM_HeapLinkedFreeHeaderPointer = null;
                }
            }
            if (null != mM_HeapLinkedFreeHeaderPointer) {
                EventManager.raiseCorruptDataEvent("Hint corruption detected ", new CorruptHintException("allocHintFreeEntryCorrupt", j9ModronAllocateHintPointer), false);
            }
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Data corruption detected while validating freelists", corruptDataException, false);
        }
    }
}

