/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.minidump;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.memory.EnvironmentUtils;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.corereaders.memory.ProcessAddressSpace;
import com.ibm.j9ddr.corereaders.minidump.MiniDumpReader;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class WindowsProcessAddressSpace
extends ProcessAddressSpace {
    private final MiniDumpReader reader;
    private Properties environment;

    WindowsProcessAddressSpace(int n, ByteOrder byteOrder, MiniDumpReader miniDumpReader) {
        super(n, byteOrder, miniDumpReader);
        this.reader = miniDumpReader;
    }

    @Override
    public ICore getCore() {
        return this.reader;
    }

    @Override
    public String getCommandLine() throws CorruptDataException, DataUnavailableException {
        return this.reader.getCommandLine();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof WindowsProcessAddressSpace)) {
            return false;
        }
        WindowsProcessAddressSpace windowsProcessAddressSpace = (WindowsProcessAddressSpace)object;
        return this.reader.equals(windowsProcessAddressSpace.reader);
    }

    public int hashCode() {
        return this.reader.hashCode();
    }

    @Override
    public Properties getEnvironmentVariables() throws DataUnavailableException, CorruptDataException {
        if (null == this.environment) {
            LinkedList<ISymbol> linkedList = this.getEnvironmentSymbols();
            ISymbol iSymbol = null;
            if (0 == linkedList.size()) {
                throw new DataUnavailableException("Couldn't find environment symbol");
            }
            for (int i = 0; i < linkedList.size(); ++i) {
                iSymbol = linkedList.get(i);
                long l = this.getPointerAt(iSymbol.getAddress());
                this.environment = EnvironmentUtils.readEnvironment(this, l);
                if (this.environment.containsKey("IBM_JAVA_COMMAND_LINE")) break;
            }
        }
        return this.environment;
    }

    private LinkedList<ISymbol> getEnvironmentSymbols() throws CorruptDataException {
        Collection collection = this.getModules();
        LinkedList<ISymbol> linkedList = new LinkedList<ISymbol>();
        for (IModule iModule : collection) {
            try {
                for (ISymbol iSymbol : iModule.getSymbols()) {
                    if (!iSymbol.getName().equals("_environ")) continue;
                    linkedList.add(iSymbol);
                }
            }
            catch (DataUnavailableException dataUnavailableException) {
            }
        }
        return linkedList;
    }

    @Override
    public IModule getExecutable() throws CorruptDataException {
        return this.reader.getExecutable();
    }

    public List<IModule> getModules() throws CorruptDataException {
        return this.reader.getModules();
    }

    @Override
    public long getProcessId() throws CorruptDataException {
        return this.reader.getPid();
    }

    public List<IOSThread> getThreads() throws CorruptDataException {
        return this.reader.getThreads();
    }

    @Override
    public Platform getPlatform() {
        return Platform.WINDOWS;
    }

    @Override
    public int getSignalNumber() throws DataUnavailableException {
        throw new DataUnavailableException("Signal number not available on Windows");
    }

    @Override
    public boolean isFailingProcess() throws DataUnavailableException {
        throw new DataUnavailableException("Not available on this platform");
    }
}

